/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.address;

import gov.nist.siplite.parser.Lexer;

public final class UserInfo {
    private String user;
    private String password;
    protected int userType;
    public static final int TELEPHONE_SUBSCRIBER = 1;
    public static final int USER = 2;

    public boolean equals(Object obj) {
        if (!this.getClass().getName().equals(obj.getClass().getName())) {
            return false;
        }
        UserInfo other = (UserInfo)obj;
        if (this.userType != other.userType) {
            return false;
        }
        String u1 = this.user;
        String u2 = other.user;
        if (u1 == null) {
            u1 = "";
        }
        if (u2 == null) {
            u2 = "";
        }
        if (!u1.toLowerCase().equals(u2.toLowerCase())) {
            return false;
        }
        u1 = this.password;
        u2 = other.password;
        if (u1 == null) {
            u1 = "";
        }
        if (u2 == null) {
            u2 = "";
        }
        return u1.equals(u2);
    }

    public String encode() {
        if (this.password != null) {
            return this.user + ":" + this.password;
        }
        return this.user;
    }

    public void clearPassword() {
        this.password = null;
    }

    public int getUserType() {
        return this.userType;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUser(String user) throws IllegalArgumentException {
        if (!Lexer.isValidUserName(user)) {
            throw new IllegalArgumentException("User name '" + user + "' contains " + "illegal characters");
        }
        this.user = user;
        if (user != null && (user.indexOf("#") >= 0 || user.indexOf(";") >= 0)) {
            this.setUserType(1);
        } else {
            this.setUserType(2);
        }
    }

    public void setPassword(String p) throws IllegalArgumentException {
        this.password = p;
    }

    public void setUserType(int type) throws IllegalArgumentException {
        if (type != 1 && type != 2) {
            throw new IllegalArgumentException("Parameter not in range");
        }
        this.userType = type;
    }

    public Object clone() {
        UserInfo retval = new UserInfo();
        try {
            retval.setUser(this.user);
            retval.setPassword(this.password);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return retval;
    }
}

