/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.header;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.siplite.header.ParametersHeader;

public class AcceptContactHeader
extends ParametersHeader {
    public static Class clazz = new AcceptContactHeader().getClass();
    public static final String NAME = "Accept-Contact";

    public AcceptContactHeader() {
        super(NAME);
    }

    public void setParameter(NameValue nv) {
        Object val = nv.getValue();
        this.setParameter(nv.getName(), val == null ? null : val.toString());
    }

    public void setParameter(String name, String value) throws IllegalArgumentException {
        NameValue nv = this.parameters.getNameValue(name.toLowerCase());
        if (value == null) {
            throw new NullPointerException("null value");
        }
        boolean quoteStart = value.startsWith("\"");
        boolean quoteEnd = value.endsWith("\"");
        if (quoteStart && !quoteEnd || !quoteStart && quoteEnd) {
            throw new IllegalArgumentException(value + " : Unexpected DOUBLE_QUOTE");
        }
        if (quoteStart) {
            value = value.substring(1, value.length() - 1);
        }
        if (nv == null) {
            nv = new NameValue(name.toLowerCase(), value);
            nv.setQuotedValue();
            super.setParameter(nv);
        } else {
            nv.setValue(value);
        }
    }

    public void setType(String value) {
        this.setParameter("type", value);
    }

    public String getParameter(String name) {
        String returnValue = super.getParameter(name);
        if (returnValue != null) {
            returnValue = returnValue.substring(1, returnValue.length() - 1);
        }
        return returnValue;
    }

    public String getType() {
        return this.getParameter("type");
    }

    public String encodeBody() {
        return "*" + this.parameters.encode();
    }

    public Object clone() {
        try {
            AcceptContactHeader retval = (AcceptContactHeader)this.getClass().newInstance();
            if (this.parameters != null) {
                retval.parameters = (NameValueList)this.parameters.clone();
            }
            return retval;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
            return null;
        }
    }

    public boolean equals(Object that) {
        if (!that.getClass().equals(this.getClass())) {
            return false;
        }
        AcceptContactHeader other = (AcceptContactHeader)that;
        return this.parameters.equals(other.parameters);
    }

    public Object getValue() {
        return "*";
    }
}

