/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.header;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.core.ParseException;
import gov.nist.siplite.address.URI;
import gov.nist.siplite.header.ParametersHeader;

public abstract class AuthenticationHeader
extends ParametersHeader {
    public static String DOMAIN = "domain";
    public static String REALM = "realm";
    public static String OPAQUE = "opaque";
    public static String ALGORITHM = "algorithm";
    public static String QOP = "qop";
    public static String STALE = "stale";
    public static String SIGNATURE = "signature";
    public static String RESPONSE = "response";
    public static String SIGNED_BY = "signed-by";
    public static String NC = "nc";
    public static String URI = "uri";
    public static String USERNAME = "username";
    public static String CNONCE = "cnonce";
    public static String NONCE = "nonce";
    public static String DIGEST = "Digest";
    public static String NEXT_NONCE = "next-nonce";
    protected String scheme;

    public AuthenticationHeader(String name) {
        super(name);
        this.parameters.setSeparator(",");
        this.scheme = DIGEST;
    }

    public AuthenticationHeader() {
        this.parameters.setSeparator(",");
    }

    public void setParameter(NameValue nv) {
        Object val = nv.getValue();
        this.setParameter(nv.getName(), val == null ? null : val.toString());
    }

    public void setParameter(String name, String value) throws IllegalArgumentException {
        NameValue nv = this.parameters.getNameValue(name.toLowerCase());
        boolean quotedParam = false;
        if (this.isQuoted(name)) {
            if (value == null) {
                throw new NullPointerException("null value");
            }
            quotedParam = true;
            boolean quoteStart = value.startsWith("\"");
            boolean quoteEnd = value.endsWith("\"");
            if (quoteStart && !quoteEnd || !quoteStart && quoteEnd) {
                throw new IllegalArgumentException(value + " : Unexpected DOUBLE_QUOTE");
            }
            if (quoteStart) {
                value = value.substring(1, value.length() - 1);
            }
        }
        if (nv == null) {
            nv = new NameValue(name.toLowerCase(), value);
            if (quotedParam) {
                nv.setQuotedValue();
            }
            super.setParameter(nv);
        } else {
            nv.setValue(value);
        }
    }

    public String getParameter(String name) {
        String returnValue = super.getParameter(name);
        if (returnValue != null && this.isQuoted(name)) {
            returnValue = returnValue.substring(1, returnValue.length() - 1);
        }
        return returnValue;
    }

    private boolean isQuoted(String name) {
        return AuthenticationHeader.equalsIgnoreCase(name, QOP) || AuthenticationHeader.equalsIgnoreCase(name, REALM) || AuthenticationHeader.equalsIgnoreCase(name, URI) || AuthenticationHeader.equalsIgnoreCase(name, CNONCE) || AuthenticationHeader.equalsIgnoreCase(name, NONCE) || AuthenticationHeader.equalsIgnoreCase(name, USERNAME) || AuthenticationHeader.equalsIgnoreCase(name, DOMAIN) || AuthenticationHeader.equalsIgnoreCase(name, OPAQUE) || AuthenticationHeader.equalsIgnoreCase(name, NEXT_NONCE) || AuthenticationHeader.equalsIgnoreCase(name, RESPONSE);
    }

    public String encodeBody() {
        return this.scheme + " " + this.parameters.encode();
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setRealm(String realm) {
        if (realm == null) {
            throw new NullPointerException("null realm");
        }
        this.setParameter(REALM, realm);
    }

    public String getRealm() {
        return this.getParameter(REALM);
    }

    public void setNonce(String nonce) {
        if (nonce == null) {
            throw new NullPointerException("null nonce");
        }
        this.setParameter(NONCE, nonce);
    }

    public String getNonce() {
        return this.getParameter(NONCE);
    }

    public void setURI(URI uri) {
        if (uri == null) {
            throw new NullPointerException("Null URI");
        }
        NameValue nv = new NameValue(URI, uri);
        nv.setQuotedValue();
        this.parameters.set(nv);
    }

    public URI getURI() {
        return this.getParameterAsURI(URI);
    }

    public void setAlgorithm(String algorithm) throws ParseException {
        if (algorithm == null) {
            throw new NullPointerException("null arg");
        }
        this.setParameter(ALGORITHM, algorithm);
    }

    public String getAlgorithm() {
        return this.getParameter(ALGORITHM);
    }

    public void setQop(String qop) throws ParseException {
        if (qop == null) {
            throw new NullPointerException("null arg");
        }
        this.setParameter(QOP, qop);
    }

    public String getQop() {
        return this.getParameter(QOP);
    }

    public void setOpaque(String opaque) throws ParseException {
        if (opaque == null) {
            throw new NullPointerException("null arg");
        }
        this.setParameter(OPAQUE, opaque);
    }

    public String getOpaque() {
        return this.getParameter(OPAQUE);
    }

    public void setDomain(String domain) throws ParseException {
        if (domain == null) {
            throw new NullPointerException("null arg");
        }
        this.setParameter(DOMAIN, domain);
    }

    public String getDomain() {
        return this.getParameter(DOMAIN);
    }

    public void setStale(boolean stale) {
        this.setParameter(new NameValue(STALE, new Boolean(stale)));
    }

    public boolean isStale() {
        return this.getParameterAsBoolean(STALE);
    }

    public void setCNonce(String cnonce) throws ParseException {
        this.setParameter(CNONCE, cnonce);
    }

    public String getCNonce() {
        return this.getParameter(CNONCE);
    }

    public int getNonceCount() {
        return this.getParameterAsHexInt(NC);
    }

    public void setNonceCount(int nonceCount) throws ParseException, IllegalArgumentException {
        if (nonceCount < 0) {
            throw new IllegalArgumentException("bad value");
        }
        String nc = Integer.toHexString(nonceCount);
        String base = "00000000";
        nc = base.substring(0, 8 - nc.length()) + nc;
        this.setParameter(NC, nc);
    }

    public String getResponse() {
        return (String)this.getParameterValue(RESPONSE);
    }

    public void setResponse(String response) throws ParseException {
        if (response == null) {
            throw new NullPointerException("Null parameter");
        }
        this.setParameter(RESPONSE, response);
    }

    public String getUsername() {
        return this.getParameter(USERNAME);
    }

    public void setUsername(String username) {
        this.setParameter(USERNAME, username);
    }

    public Object clone() {
        ReflectiveOperationException ex = null;
        try {
            AuthenticationHeader retval = (AuthenticationHeader)this.getClass().newInstance();
            if (this.scheme != null) {
                retval.scheme = new String(this.scheme);
            }
            if (this.parameters != null) {
                retval.parameters = (NameValueList)this.parameters.clone();
            }
            return retval;
        }
        catch (InstantiationException ie) {
            ex = ie;
        }
        catch (IllegalAccessException iae) {
            ex = iae;
        }
        if (ex != null) {
            InternalErrorHandler.handleException(ex);
        }
        return null;
    }

    public boolean equals(Object that) {
        if (!that.getClass().equals(this.getClass())) {
            return false;
        }
        AuthenticationHeader other = (AuthenticationHeader)that;
        return AuthenticationHeader.equalsIgnoreCase(this.scheme, other.scheme) && this.parameters.equals(other.parameters);
    }

    public Object getValue() {
        return this.getScheme();
    }
}

