/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.header;

import gov.nist.siplite.header.CallIdentifier;
import gov.nist.siplite.header.ParameterLessHeader;

public class CallIdHeader
extends ParameterLessHeader {
    public static final String NAME = "Call-ID";
    public static Class clazz = new CallIdHeader().getClass();
    protected CallIdentifier callIdentifier;

    public CallIdHeader() {
        super(NAME);
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        CallIdHeader that = (CallIdHeader)other;
        return this.callIdentifier.equals(that.callIdentifier);
    }

    public String encode() {
        return this.headerName + ":" + " " + this.callIdentifier.encode() + "\r\n";
    }

    public String encodeBody() {
        if (this.callIdentifier == null) {
            return "";
        }
        return this.callIdentifier.encode();
    }

    public String getCallId() {
        return this.encodeBody();
    }

    public CallIdentifier getCallIdentifer() {
        return this.callIdentifier;
    }

    public void setCallId(String cid) throws IllegalArgumentException {
        this.callIdentifier = new CallIdentifier(cid);
    }

    public void setCallIdentifier(CallIdentifier cid) {
        this.callIdentifier = cid;
    }

    public Object clone() {
        CallIdHeader retval = new CallIdHeader();
        if (this.callIdentifier != null) {
            retval.callIdentifier = (CallIdentifier)this.callIdentifier.clone();
        }
        return retval;
    }

    public Object getValue() {
        return this.callIdentifier;
    }

    public void setHeaderValue(String value) throws IllegalArgumentException {
        this.setCallId(value);
    }
}

