/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.header;

import gov.nist.core.GenericObject;
import gov.nist.core.Utils;
import gov.nist.siplite.parser.Lexer;

public final class CallIdentifier
extends GenericObject {
    protected String localId;
    protected String host;

    public CallIdentifier() {
    }

    public CallIdentifier(String localId, String host) {
        this.localId = localId;
        this.host = host;
    }

    public CallIdentifier(String cid) throws IllegalArgumentException {
        this.setCallIdHeader(cid);
    }

    public String encode() {
        if (this.host != null) {
            return this.localId + "@" + this.host;
        }
        return this.localId;
    }

    public boolean equals(Object other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        CallIdentifier that = (CallIdentifier)other;
        if (this.localId.compareTo(that.localId) != 0) {
            return false;
        }
        if (this.host == that.host) {
            return true;
        }
        if (this.host == null && that.host != null || this.host != null && that.host == null) {
            return false;
        }
        return Utils.compareToIgnoreCase(this.host, that.host) == 0;
    }

    public String getLocalId() {
        return this.localId;
    }

    public String getHost() {
        return this.host;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public void setCallIdHeader(String cid) throws IllegalArgumentException {
        if (cid == null) {
            throw new IllegalArgumentException("NULL!");
        }
        int index = cid.indexOf(64);
        if (index == -1) {
            this.checkValue(cid);
            this.localId = cid;
            this.host = null;
        } else {
            if (index == 0 || index == cid.length() - 1) {
                throw new IllegalArgumentException("CallIdHeader must be token@token or token");
            }
            String temp1 = cid.substring(0, index);
            String temp2 = cid.substring(index + 1, cid.length());
            this.checkValue(temp1);
            this.checkValue(temp2);
            this.localId = temp1;
            this.host = temp2;
        }
    }

    private void checkValue(String cid) throws IllegalArgumentException {
        String word = "-.!%*_+`'~()<>:\\\"/[]?{}";
        for (int i = 0; i < cid.length(); ++i) {
            char c = cid.charAt(i);
            if (Lexer.isAlpha(c) || Lexer.isHexDigit(c) || word.indexOf(c) != -1) continue;
            throw new IllegalArgumentException("Wrong Call-Id value:illegal use of symbol '" + c + "' at '" + cid + "'");
        }
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Object clone() {
        CallIdentifier retval = new CallIdentifier();
        if (this.localId != null) {
            retval.localId = new String(this.localId);
        }
        if (this.host != null) {
            retval.host = new String(this.host);
        }
        return retval;
    }

    public String toString() {
        return this.encode();
    }
}

