/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.header;

import gov.nist.core.NameValueList;
import gov.nist.siplite.address.Address;
import gov.nist.siplite.header.AddressParametersHeader;

public final class ContactHeader
extends AddressParametersHeader {
    public static Class clazz = new ContactHeader().getClass();
    public static final String NAME = "Contact";
    public static final String PARAM_EXPIRES = "expires";
    public static final String PARAM_ACTION = "action";
    public static final String PARAM_Q = "q";
    protected boolean wildCardFlag = false;
    protected String comment;

    public ContactHeader() {
        super(NAME);
    }

    public String encodeBody() {
        String encoding = "";
        if (this.wildCardFlag) {
            return encoding + "*";
        }
        if (this.address != null) {
            encoding = encoding + this.address.encode();
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            encoding = encoding + ";" + this.parameters.encode();
        }
        if (this.comment != null) {
            encoding = encoding + "(" + this.comment + ")";
        }
        return encoding;
    }

    public boolean getWildCardFlag() {
        return this.wildCardFlag;
    }

    public String getAction() {
        return this.getParameter(PARAM_ACTION);
    }

    public Object getValue() {
        return this.address;
    }

    public String getComment() {
        return this.comment;
    }

    public String getExpires() {
        return this.getParameter(PARAM_EXPIRES);
    }

    public void setExpires(String expires) {
        this.setParameter(PARAM_EXPIRES, expires);
    }

    public void setExpires(int expires) {
        this.setParameter(PARAM_EXPIRES, new Integer(expires).toString());
    }

    public String getQValue() {
        return this.getParameter(PARAM_Q);
    }

    public boolean hasQValue() {
        return this.hasParameter(PARAM_Q);
    }

    public void setWildCardFlag(boolean w) {
        this.wildCardFlag = w;
    }

    public void setAddress(Address newAddress) {
        if (newAddress != null) {
            this.address = newAddress;
        }
    }

    public void setComment(String newComment) {
        if (newComment != null) {
            this.comment = newComment;
        }
    }

    public Object clone() {
        ContactHeader retval = new ContactHeader();
        retval.wildCardFlag = this.wildCardFlag;
        if (this.comment != null) {
            retval.comment = new String(this.comment);
        }
        if (this.parameters != null) {
            retval.parameters = (NameValueList)this.parameters.clone();
        }
        if (this.address != null) {
            retval.address = (Address)this.address.clone();
        }
        return retval;
    }
}

