/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.header;

import gov.nist.core.NameValueList;
import gov.nist.siplite.header.MediaRange;
import gov.nist.siplite.header.ParametersHeader;

public class ContentTypeHeader
extends ParametersHeader {
    protected MediaRange mediaRange;
    public static Class clazz = new ContentTypeHeader().getClass();
    public static final String NAME = "Content-Type";

    public ContentTypeHeader() {
        super(NAME);
    }

    public ContentTypeHeader(String contentType, String contentSubtype) {
        this();
        this.setContentType(contentType, contentSubtype);
    }

    public int compareMediaRange(String media) {
        return ContentTypeHeader.compareToIgnoreCase(this.mediaRange.type + "/" + this.mediaRange.subtype, media);
    }

    public String encodeBody() {
        if (this.hasParameters()) {
            return this.mediaRange.encode() + ";" + this.parameters.encode();
        }
        return this.mediaRange.encode();
    }

    public MediaRange getMediaRange() {
        return this.mediaRange;
    }

    public String getMediaType() {
        return this.mediaRange.type;
    }

    public String getMediaSubType() {
        return this.mediaRange.subtype;
    }

    public String getContentSubType() {
        return this.mediaRange == null ? null : this.mediaRange.getSubtype();
    }

    public String getContentTypeHeader() {
        return this.mediaRange == null ? null : this.mediaRange.getType();
    }

    public String getCharset() {
        return this.getParameter("charset");
    }

    public void setMediaRange(MediaRange m) {
        this.mediaRange = m;
    }

    public void setContentType(String contentType, String contentSubType) {
        if (this.mediaRange == null) {
            this.mediaRange = new MediaRange();
        }
        this.mediaRange.setType(contentType);
        this.mediaRange.setSubtype(contentSubType);
    }

    public void setContentType(String contentType) {
        if (contentType == null) {
            throw new NullPointerException("null arg");
        }
        if (this.mediaRange == null) {
            this.mediaRange = new MediaRange();
        }
        this.mediaRange.setType(contentType);
    }

    public void setContentSubType(String contentType) {
        if (contentType == null) {
            throw new NullPointerException("null arg");
        }
        if (this.mediaRange == null) {
            this.mediaRange = new MediaRange();
        }
        this.mediaRange.setSubtype(contentType);
    }

    public Object getValue() {
        return this.mediaRange;
    }

    public Object clone() {
        ContentTypeHeader retval = new ContentTypeHeader();
        retval.parameters = (NameValueList)this.parameters.clone();
        retval.mediaRange = (MediaRange)this.mediaRange.clone();
        return retval;
    }
}

