/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.header;

import gov.nist.core.GenericObject;
import gov.nist.core.NameValueList;
import gov.nist.core.Utils;
import java.util.Calendar;

public abstract class Header
extends GenericObject {
    public static final String ERROR_INFO = "Error-Info";
    public static final String MIME_VERSION = "Mime-Version";
    public static final String IN_REPLY_TO = "In-Reply-To";
    public static final String ALLOW = "Allow";
    public static final String ALLOW_EVENTS = "Allow-Events";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String CALL_INFO = "Call-Info";
    public static final String CSEQ = "CSeq";
    public static final String ALERT_INFO = "Alert-Info";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ACCEPT = "Accept";
    public static final String ENCRYPTION = "Encryption";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String ACCEPT_CONTACT = "Accept-Contact";
    public static final String RECORD_ROUTE = "Record-Route";
    public static final String TIMESTAMP = "Timestamp";
    public static final String TO = "To";
    public static final String VIA = "Via";
    public static final String FROM = "From";
    public static final String CALL_ID = "Call-ID";
    public static final String AUTHENTICATION_INFO = "Authentication-Info";
    public static final String AUTHORIZATION = "Authorization";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String SERVER = "Server";
    public static final String UNSUPPORTED = "Unsupported";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String HIDE = "Hide";
    public static final String ROUTE = "Route";
    public static final String CONTACT = "Contact";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String MAX_FORWARDS = "Max-Forwards";
    public static final String ORGANIZATION = "Organization";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String PROXY_REQUIRE = "Proxy-Require";
    public static final String REQUIRE = "Require";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String SUBJECT = "Subject";
    public static final String USER_AGENT = "User-Agent";
    public static final String WARNING = "Warning";
    public static final String PRIORITY = "Priority";
    public static final String DATE = "Date";
    public static final String MIN_EXPIRES = "Min-Expires";
    public static final String EXPIRES = "Expires";
    public static final String RESPONSE_KEY = "Response-Key";
    public static final String WARN_AGENT = "Warn-Agent";
    public static final String SUPPORTED = "Supported";
    public static final String EVENT = "Event";
    public static final String EXTENSION = "Extension";
    public static final String SUBSCRIPTION_STATE = "Subscription-State";
    public static final String SIP_ETAG = "SIP-ETag";
    public static final String SIP_IF_MATCH = "SIP-If-Match";
    public static final String REFER_TO = "Refer-To";
    public static final String RSEQ = "RSeq";
    public static final String RACK = "RAck";
    public String headerName;
    public String headerValue;
    public static final String[] parameterLessHeaders = new String[]{"Authentication-Info", null, "Allow", null, null, null, null, null, "In-Reply-To", "Priority", null, null, "Mime-Version", "Server", "Timestamp", "User-Agent", null, "Min-Expires", "Subject", null, null, null, "Content-Language", null, "Warning", "Content-Encoding", "Organization", "Unsupported", null, null, null, "Require", "Supported", null, null, null, "Proxy-Require", null, null};

    public Header() {
    }

    public Header(String headerName) {
        this.headerName = headerName;
    }

    public Header(String headerName, String headerValue) {
        this.headerName = headerName;
        this.headerValue = headerValue;
    }

    public void setHeaderName(String name) {
        this.headerName = name;
    }

    public void setHeaderValue(String value) {
        this.headerValue = value;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String getName() {
        return this.headerName;
    }

    public String getHeaderValue() {
        return this.encodeBody();
    }

    public String encode() {
        if (this.headerName == null) {
            return "";
        }
        return this.headerName + ":" + " " + this.encodeBody() + "\r\n";
    }

    public Object clone() {
        return this;
    }

    public static String encodeCalendar(Calendar date) {
        StringBuffer sbuf = new StringBuffer();
        int wkday = date.get(7);
        switch (wkday) {
            case 2: {
                sbuf.append("Mon");
                break;
            }
            case 3: {
                sbuf.append("Tue");
                break;
            }
            case 4: {
                sbuf.append("Wed");
                break;
            }
            case 5: {
                sbuf.append("Thu");
                break;
            }
            case 6: {
                sbuf.append("Fri");
                break;
            }
            case 7: {
                sbuf.append("Sat");
                break;
            }
            case 1: {
                sbuf.append("Sun");
                break;
            }
            default: {
                new Exception("bad day of week?? Huh?? " + wkday).printStackTrace();
                return null;
            }
        }
        int day = date.get(5);
        if (day < 10) {
            sbuf.append(", 0" + day);
        } else {
            sbuf.append(", " + day);
        }
        sbuf.append(" ");
        int month = date.get(2);
        switch (month) {
            case 0: {
                sbuf.append("Jan");
                break;
            }
            case 1: {
                sbuf.append("Feb");
                break;
            }
            case 2: {
                sbuf.append("Mar");
                break;
            }
            case 3: {
                sbuf.append("Apr");
                break;
            }
            case 4: {
                sbuf.append("May");
                break;
            }
            case 5: {
                sbuf.append("Jun");
                break;
            }
            case 6: {
                sbuf.append("Jul");
                break;
            }
            case 7: {
                sbuf.append("Aug");
                break;
            }
            case 8: {
                sbuf.append("Sep");
                break;
            }
            case 9: {
                sbuf.append("Oct");
                break;
            }
            case 10: {
                sbuf.append("Nov");
                break;
            }
            case 11: {
                sbuf.append("Dec");
                break;
            }
            default: {
                return null;
            }
        }
        sbuf.append(" ");
        int year = date.get(1);
        sbuf.append(year);
        sbuf.append(" ");
        int hour = date.get(11);
        if (hour < 10) {
            sbuf.append("0" + hour);
        } else {
            sbuf.append(hour);
        }
        sbuf.append(":");
        int min = date.get(12);
        if (min < 10) {
            sbuf.append("0" + min);
        } else {
            sbuf.append(min);
        }
        sbuf.append(":");
        int sec = date.get(13);
        if (sec < 10) {
            sbuf.append("0" + sec);
        } else {
            sbuf.append(sec);
        }
        sbuf.append(" GMT");
        return sbuf.toString();
    }

    public abstract NameValueList getParameters();

    public abstract Object getValue();

    protected abstract String encodeBody();

    public String toString() {
        return this.encode();
    }

    public static byte getStringHash(String s) {
        String sl = s.toLowerCase();
        int len = sl.length();
        int headersCount = parameterLessHeaders.length;
        int hash = len;
        for (int i = 0; i < len; ++i) {
            hash += sl.charAt(i);
        }
        if ((hash = (int)((byte)(hash % headersCount))) == 6) {
            hash = (hash + 9 + sl.charAt(0)) % headersCount;
        } else if (hash == 7) {
            hash = (hash + 13 + sl.charAt(0)) % headersCount;
        }
        return (byte)hash;
    }

    public static boolean isParameterLess(String name) {
        byte hash = Header.getStringHash(name);
        return parameterLessHeaders[hash] != null && parameterLessHeaders[hash].equalsIgnoreCase(name);
    }

    public static boolean isAuthorization(String name) {
        if (name == null) {
            return false;
        }
        return name.equalsIgnoreCase(AUTHORIZATION) || name.equalsIgnoreCase(PROXY_AUTHORIZATION) || name.equalsIgnoreCase(PROXY_AUTHENTICATE) || name.equalsIgnoreCase(WWW_AUTHENTICATE);
    }

    public static boolean isReliableTagPresent(String strOptionTags) {
        if (Utils.equalsIgnoreCase(strOptionTags, "100rel")) {
            return true;
        }
        String tag = null;
        int delimIndex = strOptionTags.indexOf(",");
        while (delimIndex > 0) {
            tag = strOptionTags.substring(0, delimIndex).trim();
            strOptionTags = strOptionTags.substring(delimIndex + 1, strOptionTags.length()).trim();
            if (Utils.equalsIgnoreCase(tag, "100rel") || Utils.equalsIgnoreCase(strOptionTags, "100rel")) {
                return true;
            }
            delimIndex = strOptionTags.indexOf(",");
        }
        return false;
    }
}

