/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.header;

import gov.nist.core.NameValueList;
import gov.nist.siplite.header.Header;
import gov.nist.siplite.header.NameMap;
import java.util.Enumeration;
import java.util.Vector;

public class HeaderList
extends Header {
    protected Vector sipHeaderVector = new Vector();

    public Object clone() {
        try {
            HeaderList retval = (HeaderList)this.getClass().newInstance();
            if (this.headerName != null) {
                retval.headerName = new String(this.headerName);
            }
            if (this.headerValue != null) {
                retval.headerValue = new String(this.headerValue);
            }
            retval.sipHeaderVector = new Vector();
            for (int i = 0; i < this.sipHeaderVector.size(); ++i) {
                Header siphdr = (Header)this.sipHeaderVector.elementAt(i);
                Header newHdr = (Header)siphdr.clone();
                retval.sipHeaderVector.addElement(newHdr);
            }
            return retval;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.print("Problem with clone method");
            System.exit(0);
            return null;
        }
    }

    public HeaderList() {
    }

    public void concatenate(HeaderList other, boolean top) {
        block4: {
            if (other == null) break block4;
            if (top) {
                for (int i = 0; i < this.size(); ++i) {
                    Header sipHeader = (Header)this.elementAt(i);
                    other.add(sipHeader);
                }
            } else {
                for (int i = 0; i < other.size(); ++i) {
                    Header sipHeader = (Header)other.elementAt(i);
                    this.add(sipHeader);
                }
            }
        }
    }

    public HeaderList(String sipHeaderName) {
        this.headerName = sipHeaderName;
    }

    public void add(Object sipHeader) throws IllegalArgumentException {
        String expandedName2;
        String expandedName1;
        if (this.headerName != null && !(expandedName1 = NameMap.expandHeaderName(this.headerName)).equalsIgnoreCase(expandedName2 = NameMap.expandHeaderName(((Header)sipHeader).getHeaderName()))) {
            throw new IllegalArgumentException("bad type");
        }
        if (sipHeader != null) {
            this.sipHeaderVector.addElement(sipHeader);
        }
    }

    public void addFirst(Object sipHeader) {
        if (sipHeader != null) {
            Vector<Object> vec = new Vector<Object>();
            vec.addElement(sipHeader);
            for (int i = 0; i < this.sipHeaderVector.size(); ++i) {
                vec.addElement(this.sipHeaderVector.elementAt(i));
            }
            this.sipHeaderVector = vec;
        }
    }

    public boolean isEmpty() {
        return this.sipHeaderVector.isEmpty();
    }

    public int size() {
        return this.sipHeaderVector.size();
    }

    public Object elementAt(int i) {
        return this.sipHeaderVector.elementAt(i);
    }

    public void removeElement(Object element) {
        this.sipHeaderVector.removeElement(element);
    }

    public void removeFirst() {
        if (this.sipHeaderVector.size() == 0) {
            return;
        }
        this.sipHeaderVector.removeElementAt(0);
    }

    public void removeLast() {
        if (this.sipHeaderVector.size() != 0) {
            this.sipHeaderVector.removeElementAt(this.sipHeaderVector.size() - 1);
        }
    }

    public Vector getHeadersAsEncodedStrings() {
        Vector<String> retval = new Vector<String>();
        for (int i = 0; i < this.size(); ++i) {
            Header sipheader = (Header)this.elementAt(i);
            retval.addElement(sipheader.encode());
        }
        return retval;
    }

    public Enumeration getElements() {
        return this.sipHeaderVector.elements();
    }

    public Header getFirst() {
        if (this.sipHeaderVector.size() == 0) {
            return null;
        }
        return (Header)this.sipHeaderVector.elementAt(0);
    }

    public Object first() {
        if (this.sipHeaderVector.size() == 0) {
            return null;
        }
        return this.sipHeaderVector.elementAt(0);
    }

    public Object last() {
        if (this.sipHeaderVector.size() == 0) {
            return null;
        }
        return (Header)this.sipHeaderVector.elementAt(this.sipHeaderVector.size() - 1);
    }

    public Object getValue() {
        Vector<Header> retval = new Vector<Header>();
        for (int i = 0; i < this.size(); ++i) {
            Header sipheader = (Header)this.elementAt(i);
            retval.addElement(sipheader);
        }
        return retval;
    }

    public NameValueList getParameters() {
        return null;
    }

    public String encode() {
        if (this.sipHeaderVector.isEmpty() || this.headerName == null) {
            return "";
        }
        StringBuffer encoding = new StringBuffer();
        if (this.headerName.equals("WWW-Authenticate") || this.headerName.equals("Proxy-Authenticate") || this.headerName.equals("Authorization") || this.headerName.equals("Proxy-Authorization")) {
            for (int i = 0; i < this.sipHeaderVector.size(); ++i) {
                Header sipheader = (Header)this.sipHeaderVector.elementAt(i);
                encoding.append(sipheader.encode());
            }
            return encoding.toString();
        }
        return this.headerName + ":" + " " + this.encodeBody() + "\r\n";
    }

    protected String encodeBody() {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < this.sipHeaderVector.size(); ++i) {
            Header sipHeader = (Header)this.sipHeaderVector.elementAt(i);
            sbuf.append(sipHeader.encodeBody());
            if (i + 1 >= this.sipHeaderVector.size()) continue;
            sbuf.append(",");
        }
        return sbuf.toString();
    }

    public Vector getHeaders() {
        return this.sipHeaderVector;
    }
}

