/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.header;

import gov.nist.siplite.header.AcceptContactHeader;
import gov.nist.siplite.header.AuthorizationHeader;
import gov.nist.siplite.header.CSeqHeader;
import gov.nist.siplite.header.CallIdHeader;
import gov.nist.siplite.header.ContactHeader;
import gov.nist.siplite.header.ContentLengthHeader;
import gov.nist.siplite.header.ContentTypeHeader;
import gov.nist.siplite.header.DateHeader;
import gov.nist.siplite.header.EventHeader;
import gov.nist.siplite.header.ExpiresHeader;
import gov.nist.siplite.header.FromHeader;
import gov.nist.siplite.header.MaxForwardsHeader;
import gov.nist.siplite.header.ProxyAuthenticateHeader;
import gov.nist.siplite.header.ProxyAuthorizationHeader;
import gov.nist.siplite.header.RAckHeader;
import gov.nist.siplite.header.RSeqHeader;
import gov.nist.siplite.header.RecordRouteHeader;
import gov.nist.siplite.header.RouteHeader;
import gov.nist.siplite.header.SubscriptionStateHeader;
import gov.nist.siplite.header.ToHeader;
import gov.nist.siplite.header.ViaHeader;
import gov.nist.siplite.header.WWWAuthenticateHeader;
import java.util.Hashtable;

public class NameMap {
    static Hashtable nameMap;

    protected static void putNameMap(String headerName, Class clazz) {
        nameMap.put(headerName.toLowerCase(), clazz);
    }

    public static String expandHeaderName(String headerName) {
        int idx;
        String shortNames = "imelcfsktvoura";
        String[] fullNames = new String[]{"Call-ID", "Contact", "Content-Encoding", "Content-Length", "Content-Type", "From", "Subject", "Supported", "To", "Via", "Event", "Allow-Events", "Refer-To", "Accept-Contact"};
        String name = headerName;
        if (name.length() == 1 && (idx = shortNames.indexOf(name.toLowerCase().charAt(0))) != -1) {
            name = fullNames[idx];
        }
        return name;
    }

    public static Class getClassFromName(String headerName) {
        return (Class)nameMap.get(headerName.toLowerCase());
    }

    public static boolean isHeaderSupported(String headerName) {
        return nameMap.containsKey(headerName);
    }

    private static void initializeNameMap() {
        nameMap = new Hashtable();
        NameMap.putNameMap("CSeq", CSeqHeader.clazz);
        NameMap.putNameMap("Record-Route", RecordRouteHeader.clazz);
        NameMap.putNameMap("Via", ViaHeader.clazz);
        NameMap.putNameMap("From", FromHeader.clazz);
        NameMap.putNameMap("Call-ID", CallIdHeader.clazz);
        NameMap.putNameMap("Max-Forwards", MaxForwardsHeader.clazz);
        NameMap.putNameMap("Proxy-Authenticate", ProxyAuthenticateHeader.clazz);
        NameMap.putNameMap("Content-Type", ContentTypeHeader.clazz);
        NameMap.putNameMap("Content-Length", ContentLengthHeader.clazz);
        NameMap.putNameMap("Route", RouteHeader.clazz);
        NameMap.putNameMap("Contact", ContactHeader.clazz);
        NameMap.putNameMap("WWW-Authenticate", WWWAuthenticateHeader.clazz);
        NameMap.putNameMap("Proxy-Authorization", ProxyAuthorizationHeader.clazz);
        NameMap.putNameMap("Date", DateHeader.clazz);
        NameMap.putNameMap("Expires", ExpiresHeader.clazz);
        NameMap.putNameMap("Authorization", AuthorizationHeader.clazz);
        NameMap.putNameMap("To", ToHeader.clazz);
        NameMap.putNameMap("Event", EventHeader.clazz);
        NameMap.putNameMap("Subscription-State", SubscriptionStateHeader.clazz);
        NameMap.putNameMap("RSeq", RSeqHeader.clazz);
        NameMap.putNameMap("RAck", RAckHeader.clazz);
        NameMap.putNameMap("Accept-Contact", AcceptContactHeader.clazz);
    }

    static {
        NameMap.initializeNameMap();
    }
}

