/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.header;

import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.core.ParseException;
import gov.nist.siplite.address.URI;
import gov.nist.siplite.header.Header;
import java.util.Vector;

public abstract class ParametersHeader
extends Header {
    protected NameValueList parameters = new NameValueList();

    protected ParametersHeader() {
    }

    protected ParametersHeader(String hdrName) {
        super(hdrName);
    }

    public String getParameter(String name) {
        return this.parameters.getParameter(name);
    }

    public Object getParameterValue(String name) {
        return this.parameters.getValue(name);
    }

    public Vector getParameterNames() {
        return this.parameters.getNames();
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    public void removeParameter(String name) {
        this.parameters.delete(name);
    }

    public void setParameter(String name, String value) {
        NameValue nv = this.parameters.getNameValue(name);
        if (nv != null) {
            nv.setValue(value);
        } else {
            nv = new NameValue(name, value);
        }
        this.parameters.set(nv);
    }

    public void setQuotedParameter(String name, String value) throws ParseException {
        NameValue nv = this.parameters.getNameValue(name);
        if (nv != null) {
            nv.setValue(value);
            nv.setQuotedValue();
        } else {
            nv = new NameValue(name, value);
            nv.setQuotedValue();
            this.parameters.set(nv);
        }
    }

    protected void setParameter(String name, int value) {
        Integer val = new Integer(value);
        NameValue nv = this.parameters.getNameValue(name);
        if (nv != null) {
            nv.setValue(val);
        } else {
            nv = new NameValue(name, val);
            this.parameters.set(nv);
        }
    }

    protected void setParameter(String name, boolean value) {
        Boolean val = new Boolean(value);
        NameValue nv = this.parameters.getNameValue(name);
        if (nv != null) {
            nv.setValue(val);
        } else {
            nv = new NameValue(name, val);
            this.parameters.set(nv);
        }
    }

    protected void setParameter(String name, Object value) {
        NameValue nv = this.parameters.getNameValue(name);
        if (nv != null) {
            nv.setValue(value);
        } else {
            nv = new NameValue(name, value);
            this.parameters.set(nv);
        }
    }

    public boolean hasParameter(String parameterName) {
        return this.parameters.hasNameValue(parameterName);
    }

    public void removeParameters() {
        this.parameters = new NameValueList();
    }

    public NameValueList getParameters() {
        return this.parameters;
    }

    public void setParameter(NameValue nameValue) {
        this.parameters.set(nameValue);
    }

    public void setParameters(NameValueList parameters) {
        this.parameters = parameters;
    }

    protected int getParameterAsInt(String parameterName) {
        if (this.getParameterValue(parameterName) != null) {
            try {
                if (this.getParameterValue(parameterName) instanceof String) {
                    return Integer.parseInt(this.getParameter(parameterName));
                }
                return (Integer)this.getParameterValue(parameterName);
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }
        return -1;
    }

    protected int getParameterAsHexInt(String parameterName) {
        if (this.getParameterValue(parameterName) != null) {
            try {
                if (this.getParameterValue(parameterName) instanceof String) {
                    return Integer.parseInt(this.getParameter(parameterName), 16);
                }
                return (Integer)this.getParameterValue(parameterName);
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }
        return -1;
    }

    protected long getParameterAsLong(String parameterName) {
        if (this.getParameterValue(parameterName) != null) {
            try {
                if (this.getParameterValue(parameterName) instanceof String) {
                    return Long.parseLong(this.getParameter(parameterName));
                }
                return (Long)this.getParameterValue(parameterName);
            }
            catch (NumberFormatException ex) {
                return -1L;
            }
        }
        return -1L;
    }

    protected URI getParameterAsURI(String parameterName) {
        Object val = this.getParameterValue(parameterName);
        if (val instanceof URI) {
            return (URI)val;
        }
        try {
            return new URI((String)val);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    protected boolean getParameterAsBoolean(String parameterName) {
        Object val = this.getParameterValue(parameterName);
        if (val == null) {
            return false;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            return ParametersHeader.equalsIgnoreCase((String)val, "true");
        }
        return false;
    }

    public NameValue getNameValue(String parameterName) {
        return this.parameters.getNameValue(parameterName);
    }

    protected abstract String encodeBody();
}

