/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.header;

import gov.nist.core.GenericObject;
import gov.nist.core.Utils;

public class Protocol
extends GenericObject {
    protected String protocolName = "SIP";
    protected String protocolVersion = "2.0";
    protected String transport = "UDP";

    public boolean equals(Object other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        Protocol that = (Protocol)other;
        if (Utils.compareToIgnoreCase(this.protocolName, that.protocolName) != 0) {
            return false;
        }
        if (Utils.compareToIgnoreCase(this.protocolVersion, this.protocolVersion) != 0) {
            return false;
        }
        return Utils.compareToIgnoreCase(this.transport, that.transport) == 0;
    }

    public String encode() {
        return this.protocolName.toUpperCase() + "/" + this.protocolVersion + "/" + this.transport.toUpperCase();
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getTransport() {
        return this.transport;
    }

    public void setProtocolName(String p) {
        this.protocolName = p;
    }

    public void setProtocolVersion(String p) {
        this.protocolVersion = p;
    }

    public void setTransport(String t) {
        this.transport = t;
    }

    public Object clone() {
        Protocol retval = new Protocol();
        if (this.protocolName != null) {
            retval.protocolName = new String(this.protocolName);
        }
        if (this.protocolVersion != null) {
            retval.protocolVersion = new String(this.protocolVersion);
        }
        if (this.transport != null) {
            retval.transport = new String(this.transport);
        }
        return retval;
    }
}

