/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.header;

import gov.nist.siplite.header.ParameterLessHeader;

public class RAckHeader
extends ParameterLessHeader {
    public static Class clazz = new RAckHeader().getClass();
    public static final String NAME = "RAck";
    protected Integer responseNum;
    protected Integer cseqNum;
    protected String method;

    public RAckHeader() {
        super(NAME);
    }

    public RAckHeader(int responseNumber, int cseqNumber, String method) {
        this();
        this.responseNum = new Integer(responseNumber);
        this.cseqNum = new Integer(cseqNumber);
    }

    public boolean equals(Object other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        RAckHeader that = (RAckHeader)other;
        if (!this.responseNum.equals(that.responseNum)) {
            return false;
        }
        if (!this.cseqNum.equals(that.cseqNum)) {
            return false;
        }
        return RAckHeader.equalsIgnoreCase(this.method, that.method);
    }

    public String encodeBody() {
        return this.responseNum + " " + this.cseqNum + " " + this.method.toUpperCase();
    }

    public String getMethod() {
        return this.method.toUpperCase();
    }

    public void setResponseNumber(int responseNumber) {
        if (responseNumber < 0) {
            throw new IllegalArgumentException("the sequence number parameter is < 0");
        }
        this.responseNum = new Integer(responseNumber);
    }

    public void setSequenceNumber(int sequenceNumber) {
        if (sequenceNumber < 0) {
            throw new IllegalArgumentException("the sequence number parameter is < 0");
        }
        this.cseqNum = new Integer(sequenceNumber);
    }

    public void setMethod(String newMethod) {
        if (newMethod == null) {
            throw new NullPointerException("parameter is null");
        }
        this.method = newMethod;
    }

    public int getResponseNumber() {
        if (this.responseNum == null) {
            return 0;
        }
        return this.responseNum;
    }

    public int getSequenceNumber() {
        if (this.cseqNum == null) {
            return 0;
        }
        return this.cseqNum;
    }

    public Object clone() {
        RAckHeader retval = new RAckHeader();
        if (this.responseNum != null) {
            retval.responseNum = new Integer(this.responseNum);
        }
        if (this.cseqNum != null) {
            retval.cseqNum = new Integer(this.cseqNum);
        }
        retval.method = this.method;
        return retval;
    }

    public Object getValue() {
        return this.responseNum + " " + this.cseqNum + " " + this.method.toUpperCase();
    }

    public void setHeaderValue(String value) throws IllegalArgumentException {
        int delimIndex1 = (value = value.trim()).indexOf(32);
        if (delimIndex1 == -1) {
            throw new IllegalArgumentException("Invalid value");
        }
        String strResponse = value.substring(0, delimIndex1).trim();
        int newResponseNo = Integer.parseInt(strResponse);
        this.setResponseNumber(newResponseNo);
        String strCseqMethod = value.substring(delimIndex1, value.length()).trim();
        int delimIndex2 = strCseqMethod.indexOf(32);
        if (delimIndex2 == -1) {
            throw new IllegalArgumentException("Invalid value");
        }
        String strCseq = strCseqMethod.substring(0, delimIndex2).trim();
        int newSeqNo = Integer.parseInt(strCseq);
        this.setSequenceNumber(newSeqNo);
        String newMethod = strCseqMethod.substring(delimIndex2, strCseqMethod.length()).trim();
        this.setMethod(newMethod);
    }
}

