/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.header;

import gov.nist.core.GenericObject;

public final class StatusLine
extends GenericObject {
    protected String sipVersion = "SIP/2.0";
    protected int statusCode;
    protected String reasonPhrase = null;
    public static Class clazz = new StatusLine().getClass();

    public String encode() {
        String encoding = "SIP/2.0 " + this.statusCode;
        if (this.reasonPhrase != null) {
            encoding = encoding + " " + this.reasonPhrase;
        }
        encoding = encoding + "\r\n";
        return encoding;
    }

    public String getSipVersion() {
        return this.sipVersion;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public void setSipVersion(String s) {
        this.sipVersion = s;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    public String getVersionMajor() {
        if (this.sipVersion == null) {
            return null;
        }
        String major = null;
        boolean slash = false;
        for (int i = 0; i < this.sipVersion.length(); ++i) {
            if (this.sipVersion.charAt(i) == '.') {
                slash = false;
            }
            if (slash) {
                major = major == null ? "" + this.sipVersion.charAt(i) : major + this.sipVersion.charAt(i);
            }
            if (this.sipVersion.charAt(i) != '/') continue;
            slash = true;
        }
        return major;
    }

    public String getVersionMinor() {
        if (this.sipVersion == null) {
            return null;
        }
        String minor = null;
        boolean dot = false;
        for (int i = 0; i < this.sipVersion.length(); ++i) {
            if (dot) {
                minor = minor == null ? "" + this.sipVersion.charAt(i) : minor + this.sipVersion.charAt(i);
            }
            if (this.sipVersion.charAt(i) != '.') continue;
            dot = true;
        }
        return minor;
    }

    public Object clone() {
        StatusLine retval = new StatusLine();
        if (this.sipVersion != null) {
            retval.sipVersion = new String(this.sipVersion);
        }
        retval.statusCode = this.statusCode;
        if (this.reasonPhrase != null) {
            retval.reasonPhrase = new String(this.reasonPhrase);
        }
        return retval;
    }

    public boolean equals(Object that) {
        if (that instanceof StatusLine) {
            return this.statusCode == ((StatusLine)that).statusCode;
        }
        return false;
    }
}

