/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.header;

import gov.nist.siplite.header.ParametersHeader;

public class SubscriptionStateHeader
extends ParametersHeader {
    public static Class clazz = new SubscriptionStateHeader().getClass();
    public static final String NAME = "Subscription-State";
    public static final String STATE_ACTIVE = "active";
    public static final String STATE_PENDING = "pending";
    public static final String STATE_TERMINATED = "terminated";
    public static final String PARAM_REASON = "reason";
    public static final String PARAM_EXPIRES = "expires";
    public static final String PARAM_RETRY_AFTER = "retry-after";
    private String state = null;

    public SubscriptionStateHeader() {
        super(NAME);
    }

    public SubscriptionStateHeader(String subscriptionState) throws IllegalArgumentException {
        super(NAME);
        this.setState(subscriptionState);
    }

    public String encodeBody() {
        if (this.state == null) {
            return "";
        }
        String encoding = this.state;
        if (this.parameters != null && !this.parameters.isEmpty()) {
            encoding = encoding + ";" + this.parameters.encode();
        }
        return encoding;
    }

    public boolean isActive() {
        if (this.state == null) {
            return false;
        }
        return this.state.equalsIgnoreCase(STATE_ACTIVE);
    }

    public boolean isTerminated() {
        if (this.state == null) {
            return false;
        }
        return this.state.equalsIgnoreCase(STATE_TERMINATED);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String newState) throws IllegalArgumentException {
        if (newState == null || newState.equals("")) {
            throw new IllegalArgumentException("Invalid state value: " + newState);
        }
        this.state = newState.trim();
    }

    public Object getValue() {
        return this.state;
    }

    public String getExpires() {
        return this.getParameter(PARAM_EXPIRES);
    }

    public void setExpires(String expires) throws IllegalArgumentException {
        int intExpires;
        try {
            intExpires = Integer.parseInt(expires);
        }
        catch (NumberFormatException e) {
            intExpires = -1;
        }
        if (intExpires < 0) {
            throw new IllegalArgumentException("Invalid 'expires': " + expires);
        }
        this.setParameter(PARAM_EXPIRES, expires);
    }

    public void setExpires(int expires) throws IllegalArgumentException {
        if (expires < 0) {
            throw new IllegalArgumentException("Invalid 'expires': " + expires);
        }
        this.setParameter(PARAM_EXPIRES, new Integer(expires).toString());
    }
}

