/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.header;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.NameValueList;
import gov.nist.core.ParseException;
import gov.nist.siplite.header.ParametersHeader;
import gov.nist.siplite.header.Protocol;
import gov.nist.siplite.header.ViaList;
import gov.nist.siplite.parser.Lexer;
import gov.nist.siplite.parser.StringMsgParser;

public class ViaHeader
extends ParametersHeader {
    public static Class clazz = new ViaHeader().getClass();
    public static final String NAME = "Via";
    public static final String BRANCH = "branch";
    public static final String HIDDEN = "hidden";
    public static final String RECEIVED = "received";
    public static final String MADDR = "maddr";
    public static final String TTL = "ttl";
    protected Protocol sentProtocol;
    protected HostPort sentBy = new HostPort();
    protected String comment;

    public ViaHeader() {
        super(NAME);
        this.sentProtocol = new Protocol();
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ViaHeader that = (ViaHeader)other;
        if (!this.sentProtocol.equals(that.sentProtocol)) {
            return false;
        }
        if (!this.parameters.equals(that.parameters)) {
            return false;
        }
        return this.sentBy.equals(that.sentBy);
    }

    public String encodeBody() {
        String encoding = "";
        encoding = encoding + this.sentProtocol.encode() + " " + this.sentBy.encode();
        if (!this.sentBy.hasPort()) {
            encoding = encoding + ":5060";
        }
        if (this.comment != null) {
            encoding = encoding + "(" + this.comment + ")";
        }
        if (!this.parameters.isEmpty()) {
            encoding = encoding + ";" + this.parameters.encode();
        }
        return encoding;
    }

    public String getProtocolVersion() {
        if (this.sentProtocol == null) {
            return null;
        }
        return this.sentProtocol.getProtocolVersion();
    }

    public Protocol getSentProtocol() {
        return this.sentProtocol;
    }

    public HostPort getSentBy() {
        return this.sentBy;
    }

    public String getHost() {
        if (this.sentBy == null) {
            return null;
        }
        Host host = this.sentBy.getHost();
        if (host == null) {
            return null;
        }
        return host.getHostname();
    }

    public int getPort() {
        if (this.sentBy == null) {
            return -1;
        }
        return this.sentBy.getPort();
    }

    public boolean hasPort() {
        if (this.sentBy == null) {
            return false;
        }
        return this.getSentBy().hasPort();
    }

    public String getComment() {
        return this.comment;
    }

    public String getBranch() {
        return super.getParameter(BRANCH);
    }

    public String getReceived() {
        return super.getParameter(RECEIVED);
    }

    public String getMaddr() {
        return super.getParameter(MADDR);
    }

    public String getTTL() {
        return super.getParameter(TTL);
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public void removeComment() {
        this.comment = null;
    }

    public void setProtocolVersion(String protocolVersion) {
        if (this.sentProtocol == null) {
            this.sentProtocol = new Protocol();
        }
        this.sentProtocol.setProtocolVersion(protocolVersion);
    }

    public void setSentProtocol(Protocol s) {
        this.sentProtocol = s;
    }

    public void setTransport(String transport) {
        if (this.sentProtocol == null) {
            this.sentProtocol = new Protocol();
        }
        this.sentProtocol.setTransport(transport);
    }

    public void setSentBy(HostPort s) {
        this.sentBy = s;
    }

    public void setComment(String c) {
        this.comment = c;
    }

    public Object clone() {
        ViaHeader retval = new ViaHeader();
        if (this.comment != null) {
            retval.comment = new String(this.comment);
        }
        if (this.parameters != null) {
            retval.parameters = (NameValueList)this.parameters.clone();
        }
        if (this.sentBy != null) {
            retval.sentBy = (HostPort)this.sentBy.clone();
        }
        if (this.sentProtocol != null) {
            retval.sentProtocol = (Protocol)this.sentProtocol.clone();
        }
        return retval;
    }

    public Object getValue() {
        return this.sentProtocol.encode() + " " + this.sentBy.encode();
    }

    public void setHeaderValue(String value) throws IllegalArgumentException {
        StringMsgParser smp = new StringMsgParser();
        ViaList hl = null;
        String strNewHeader = "Via:" + value;
        try {
            hl = (ViaList)smp.parseHeader(strNewHeader);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.toString());
        }
        if (hl.size() > 1) {
            throw new IllegalArgumentException("Ivalid Via header value: " + value);
        }
        ViaHeader header = (ViaHeader)hl.elementAt(0);
        this.setSentBy(header.getSentBy());
        this.setSentProtocol(header.getSentProtocol());
        if (this.sentProtocol != null) {
            this.setProtocolVersion(header.getProtocolVersion());
            this.setTransport(header.getTransport());
        }
        if (this.sentBy != null) {
            this.setHost(header.getHost());
            this.setPort(header.getPort());
        }
    }

    public void setParameter(String name, String value) throws IllegalArgumentException {
        if (name.equalsIgnoreCase(TTL)) {
            this.setTTL(value);
        } else if (name.equalsIgnoreCase(RECEIVED)) {
            this.setReceived(value);
        } else {
            super.setParameter(name, value);
        }
    }

    public void setReceived(String received) throws IllegalArgumentException {
        if (!Lexer.isValidIpv4Address(received) && !Lexer.isValidIpv6Address(received)) {
            throw new IllegalArgumentException("Invalid IP address");
        }
        super.setParameter(RECEIVED, received);
    }

    public void setMaddr(String maddr) throws IllegalArgumentException {
        super.setParameter(MADDR, maddr);
    }

    public void setTTL(String strTTL) throws IllegalArgumentException {
        int ttl = 0;
        try {
            ttl = Integer.parseInt(strTTL);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot parse TTL '" + strTTL + "': " + e);
        }
        if (ttl < 0 || ttl > 255) {
            throw new IllegalArgumentException("Invalid TTL: " + strTTL);
        }
        super.setParameter(TTL, strTTL);
    }

    public void setBranch(String branch) {
        super.setParameter(BRANCH, branch);
    }

    public void setHost(String host) {
        this.sentBy.setHost(new Host(host));
    }

    public void setHost(Host host) {
        this.sentBy.setHost(host);
    }

    public void setPort(int port) {
        this.sentBy.setPort(port);
    }

    public String getTransport() {
        if (this.sentProtocol == null) {
            return null;
        }
        return this.sentProtocol.getTransport();
    }
}

