/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.message;

import gov.nist.core.GenericObject;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.ParseException;
import gov.nist.core.Utils;
import gov.nist.siplite.header.CSeqHeader;
import gov.nist.siplite.header.CallIdHeader;
import gov.nist.siplite.header.ContactList;
import gov.nist.siplite.header.ContentLengthHeader;
import gov.nist.siplite.header.ContentTypeHeader;
import gov.nist.siplite.header.FromHeader;
import gov.nist.siplite.header.Header;
import gov.nist.siplite.header.HeaderList;
import gov.nist.siplite.header.NameMap;
import gov.nist.siplite.header.RecordRouteList;
import gov.nist.siplite.header.RequestLine;
import gov.nist.siplite.header.RouteList;
import gov.nist.siplite.header.StatusLine;
import gov.nist.siplite.header.ToHeader;
import gov.nist.siplite.header.ViaHeader;
import gov.nist.siplite.header.ViaList;
import gov.nist.siplite.message.ListMap;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.parser.HeaderParser;
import gov.nist.siplite.parser.ParserFactory;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.sip.SipException;

public abstract class Message
extends GenericObject {
    private static Class sipHeaderListClass;
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected Vector unrecognizedHeaders = new Vector();
    protected Vector headers = new Vector();
    protected FromHeader fromHeader;
    protected ToHeader toHeader;
    protected CSeqHeader cSeqHeader;
    protected CallIdHeader callIdHeader;
    protected ContentLengthHeader contentLengthHeader;
    protected String messageContent;
    protected byte[] messageContentBytes;
    protected Object messageContentObject;
    private Hashtable nameTable = new Hashtable();

    private void removeHeaderFromList(String headerName) {
        Enumeration li = this.headers.elements();
        int index = -1;
        while (li.hasMoreElements()) {
            Header sipHeader = (Header)li.nextElement();
            ++index;
            String currName = NameMap.expandHeaderName(sipHeader.getName());
            if (!Utils.equalsIgnoreCase(currName, headerName)) continue;
            break;
        }
        if (index != -1 && index < this.headers.size()) {
            this.headers.removeElementAt(index);
        }
    }

    public static boolean isRequestHeader(Header sipHeader) {
        return sipHeader.getHeaderName().equals("Alert-Info") || sipHeader.getHeaderName().equals("In-Reply-To") || sipHeader.getHeaderName().equals("Authorization") || sipHeader.getHeaderName().equals("Max-Forwards") || sipHeader.getHeaderName().equals("Priority") || sipHeader.getHeaderName().equals("Proxy-Authorization") || sipHeader.getHeaderName().equals("Proxy-Require") || sipHeader.getHeaderName().equals("Route") || sipHeader.getHeaderName().equals("Subject") || sipHeader.getHeaderName().equals("Accept-Contact");
    }

    public static boolean isResponseHeader(Header sipHeader) {
        return sipHeader.getHeaderName().equals("Error-Info") || sipHeader.getHeaderName().equals("Proxy-Authenticate") || sipHeader.getHeaderName().equals("Server") || sipHeader.getHeaderName().equals("Unsupported") || sipHeader.getHeaderName().equals("Retry-After") || sipHeader.getHeaderName().equals("Warning") || sipHeader.getHeaderName().equals("WWW-Authenticate");
    }

    public String getDialogId(boolean isServer) {
        CallIdHeader cid = this.getCallId();
        StringBuffer retval = new StringBuffer(cid.getCallId());
        FromHeader from = this.getFromHeader();
        ToHeader to = this.getTo();
        if (!isServer) {
            if (to.getTag() != null) {
                retval.append(to.getTag());
            }
            if (from.getTag() != null) {
                retval.append(from.getTag());
            }
        } else {
            if (from.getTag() != null) {
                retval.append(from.getTag());
            }
            if (to.getTag() != null) {
                retval.append(to.getTag());
            }
        }
        return retval.toString().toLowerCase();
    }

    public String getDialogId(boolean isServer, String toTag) {
        FromHeader from = this.getFromHeader();
        ToHeader to = this.getTo();
        CallIdHeader cid = this.getCallId();
        StringBuffer retval = new StringBuffer(cid.getCallId());
        if (!isServer) {
            if (toTag != null) {
                retval.append(toTag);
            }
            if (from.getTag() != null) {
                retval.append(from.getTag());
            }
        } else {
            if (from.getTag() != null) {
                retval.append(from.getTag());
            }
            if (toTag != null) {
                retval.append(toTag);
            }
        }
        return retval.toString().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode() {
        StringBuffer encoding = new StringBuffer();
        Vector vector = this.headers;
        synchronized (vector) {
            Enumeration it = this.headers.elements();
            while (it.hasMoreElements()) {
                Header siphdr = (Header)it.nextElement();
                if (siphdr instanceof ContentLengthHeader) continue;
                encoding.append(siphdr.encode());
            }
        }
        if (this.contentLengthHeader != null) {
            encoding.append(this.contentLengthHeader.encode()).append("\r\n");
        }
        if (this.messageContentObject != null) {
            String mbody = this.getContent().toString();
            encoding.append(mbody);
        } else if (this.messageContent != null || this.messageContentBytes != null) {
            String content = null;
            try {
                content = this.messageContent != null ? this.messageContent : new String(this.messageContentBytes, DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                content = "";
            }
            encoding.append(content);
        }
        return encoding.toString();
    }

    public byte[] encodeAsBytes() {
        StringBuffer encoding = new StringBuffer();
        Enumeration it = this.headers.elements();
        while (it.hasMoreElements()) {
            Header siphdr = (Header)it.nextElement();
            if (siphdr instanceof ContentLengthHeader) continue;
            encoding.append(siphdr.encode());
        }
        byte[] retval = null;
        byte[] content = this.getRawContent();
        if (content != null) {
            encoding.append("Content-Length: " + content.length + "\r\n");
            encoding.append("\r\n");
            byte[] msgarray = null;
            try {
                msgarray = encoding.toString().getBytes(DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException(ex);
            }
            retval = new byte[msgarray.length + content.length];
            System.arraycopy(msgarray, 0, retval, 0, msgarray.length);
            System.arraycopy(content, 0, retval, msgarray.length, content.length);
        } else {
            encoding.append("Content-Length: 0\r\n");
            encoding.append("\r\n");
            try {
                retval = encoding.toString().getBytes(DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException(ex);
            }
        }
        return retval;
    }

    public Object clone() {
        Message retval = null;
        try {
            retval = (Message)this.getClass().newInstance();
        }
        catch (IllegalAccessException ex) {
            InternalErrorHandler.handleException(ex);
        }
        catch (InstantiationException ex) {
            InternalErrorHandler.handleException(ex);
        }
        Enumeration li = this.headers.elements();
        while (li.hasMoreElements()) {
            Header sipHeader = (Header)((Header)li.nextElement()).clone();
            try {
                retval.attachHeader(sipHeader);
            }
            catch (SipException ex) {}
        }
        if (retval instanceof Request) {
            Request thisRequest = (Request)this;
            RequestLine rl = (RequestLine)thisRequest.getRequestLine().clone();
            ((Request)retval).setRequestLine(rl);
        } else {
            Response thisResponse = (Response)this;
            StatusLine sl = (StatusLine)thisResponse.getStatusLine().clone();
            ((Response)retval).setStatusLine(sl);
        }
        if (this.getContent() != null) {
            try {
                retval.setContent(this.getContent(), this.getContentTypeHeader());
            }
            catch (SipException sipException) {
                // empty catch block
            }
        }
        return retval;
    }

    private void attachHeader(Header h) throws IllegalArgumentException, SipException {
        HeaderList hl;
        if (h == null) {
            throw new IllegalArgumentException("null header!");
        }
        if (h instanceof HeaderList && (hl = (HeaderList)h).isEmpty()) {
            return;
        }
        this.attachHeader(h, false, false);
    }

    public void setHeader(Header header) throws IllegalArgumentException, SipException {
        HeaderList hl;
        if (header == null) {
            throw new IllegalArgumentException("null header!");
        }
        if (header instanceof HeaderList && (hl = (HeaderList)header).isEmpty()) {
            return;
        }
        this.attachHeader(header, true, false);
    }

    public void setHeaders(Vector headers) throws SipException {
        Enumeration elements = headers.elements();
        while (elements.hasMoreElements()) {
            Header sipHeader = (Header)elements.nextElement();
            this.attachHeader(sipHeader, false);
        }
    }

    public void attachHeader(Header h, boolean replaceflag) throws SipException {
        this.attachHeader(h, replaceflag, false);
    }

    public void attachHeader(Header header, boolean replaceFlag, boolean top) throws SipException {
        HeaderList hdrlist;
        Header h;
        if (header == null) {
            throw new NullPointerException("null header");
        }
        String expandedHeaderName = NameMap.expandHeaderName(header.getHeaderName()).toLowerCase();
        if (ListMap.hasList(header) && !sipHeaderListClass.isAssignableFrom(header.getClass())) {
            HeaderList hdrList = ListMap.getList(header);
            if (replaceFlag && hdrList.size() > 0) {
                hdrList.removeElement(hdrList.elementAt(0));
            }
            hdrList.add(header);
            h = hdrList;
        } else {
            h = header;
        }
        if (!replaceFlag && this.nameTable.containsKey(expandedHeaderName) && !(h instanceof HeaderList)) {
            throw new SipException("Header '" + header.getHeaderName() + "' already exist. Only one header of this type is allowed.", 6);
        }
        if (replaceFlag || h instanceof HeaderList) {
            Enumeration li = this.headers.elements();
            int index = 0;
            while (li.hasMoreElements()) {
                Header next = (Header)li.nextElement();
                String currName = NameMap.expandHeaderName(next.getHeaderName());
                if (expandedHeaderName.equalsIgnoreCase(currName)) {
                    this.headers.removeElementAt(index);
                    break;
                }
                ++index;
            }
        }
        Header hRef = h;
        if (h instanceof HeaderList && (hdrlist = (HeaderList)this.nameTable.get(expandedHeaderName)) != null) {
            if (replaceFlag) {
                hdrlist.removeFirst();
            }
            hdrlist.concatenate((HeaderList)h, top);
            if (!top) {
                hRef = hdrlist;
            }
        }
        this.nameTable.put(expandedHeaderName, hRef);
        this.headers.addElement(hRef);
        if (h instanceof FromHeader) {
            this.fromHeader = (FromHeader)h;
        } else if (h instanceof ContentLengthHeader) {
            this.contentLengthHeader = (ContentLengthHeader)h;
        } else if (h instanceof ToHeader) {
            this.toHeader = (ToHeader)h;
        } else if (h instanceof CSeqHeader) {
            this.cSeqHeader = (CSeqHeader)h;
        } else if (h instanceof CallIdHeader) {
            this.callIdHeader = (CallIdHeader)h;
        }
    }

    public void removeHeader(String headerName, boolean top) {
        Header toRemove = (Header)this.nameTable.get(headerName = NameMap.expandHeaderName(headerName).toLowerCase());
        if (toRemove == null) {
            return;
        }
        if (toRemove instanceof HeaderList) {
            HeaderList hdrList = (HeaderList)toRemove;
            if (top) {
                hdrList.removeFirst();
            } else {
                hdrList.removeLast();
            }
            if (hdrList.isEmpty()) {
                this.removeHeaderFromList(headerName);
            }
        } else {
            this.nameTable.remove(headerName);
            if (toRemove instanceof FromHeader) {
                this.fromHeader = null;
            } else if (toRemove instanceof ToHeader) {
                this.toHeader = null;
            } else if (toRemove instanceof CSeqHeader) {
                this.cSeqHeader = null;
            } else if (toRemove instanceof CallIdHeader) {
                this.callIdHeader = null;
            } else if (toRemove instanceof ContentLengthHeader) {
                this.contentLengthHeader = null;
            }
            this.removeHeaderFromList(headerName);
        }
    }

    public void removeHeader(String headerName) {
        if (headerName == null) {
            throw new NullPointerException("null arg");
        }
        Header toRemove = (Header)this.nameTable.get(headerName = NameMap.expandHeaderName(headerName).toLowerCase());
        if (toRemove == null) {
            return;
        }
        this.nameTable.remove(headerName);
        if (toRemove instanceof FromHeader) {
            this.fromHeader = null;
        } else if (toRemove instanceof ToHeader) {
            this.toHeader = null;
        } else if (toRemove instanceof CSeqHeader) {
            this.cSeqHeader = null;
        } else if (toRemove instanceof CallIdHeader) {
            this.callIdHeader = null;
        } else if (toRemove instanceof ContentLengthHeader) {
            this.contentLengthHeader = null;
        }
        this.removeHeaderFromList(headerName);
    }

    public String getTransactionId() {
        String hc;
        ViaHeader topVia = null;
        if (!this.getViaHeaders().isEmpty()) {
            topVia = (ViaHeader)this.getViaHeaders().first();
        }
        if (topVia.getBranch() != null && topVia.getBranch().startsWith("z9hG4bK")) {
            return topVia.getBranch().toLowerCase();
        }
        StringBuffer retval = new StringBuffer();
        FromHeader from = this.getFromHeader();
        ToHeader to = this.getTo();
        String hpFromHeader = from.getUserAtHostPort();
        retval.append(hpFromHeader).append(":");
        if (from.hasTag()) {
            retval.append(from.getTag()).append(":");
        }
        String hpTo = to.getUserAtHostPort();
        retval.append(hpTo).append(":");
        String cid = this.callIdHeader.getCallId();
        retval.append(cid).append(":");
        retval.append(this.cSeqHeader.getSequenceNumber()).append(":").append(this.cSeqHeader.getMethod());
        if (topVia != null) {
            retval.append(":").append(topVia.getSentBy().encode());
            if (!topVia.getSentBy().hasPort()) {
                retval.append(":").append(5060);
            }
        }
        if ((hc = Utils.toHexString(retval.toString().toLowerCase().getBytes())).length() < 32) {
            return hc;
        }
        return hc.substring(hc.length() - 32, hc.length() - 1);
    }

    public boolean hasContent() {
        return this.messageContent != null || this.messageContentBytes != null;
    }

    public Enumeration getHeaders() {
        return this.headers.elements();
    }

    public Header getHeader(String headerName) {
        if (headerName == null) {
            throw new NullPointerException("bad name");
        }
        Header sipHeader = (Header)this.nameTable.get(headerName = NameMap.expandHeaderName(headerName).toLowerCase());
        if (sipHeader == null) {
            return null;
        }
        if (sipHeader instanceof HeaderList) {
            return ((HeaderList)sipHeader).getFirst();
        }
        return sipHeader;
    }

    public ContentTypeHeader getContentTypeHeader() {
        return (ContentTypeHeader)this.getHeader("Content-Type");
    }

    public FromHeader getFromHeader() {
        return this.fromHeader;
    }

    public ContactList getContactHeaders() {
        return (ContactList)this.getHeaderList("Contact");
    }

    public ViaList getViaHeaders() {
        return (ViaList)this.getHeaderList("Via");
    }

    public void setVia(ViaList viaList) throws SipException {
        this.setHeader(viaList);
    }

    public void setVia(Vector viaList) throws SipException {
        this.removeHeader("Via");
        for (int i = 0; i < viaList.size(); ++i) {
            ViaHeader via = (ViaHeader)viaList.elementAt(i);
            this.addHeader(via);
        }
    }

    public void setHeader(HeaderList sipHeaderList) throws SipException {
        this.setHeader((Header)sipHeaderList);
    }

    public ViaHeader getTopmostVia() {
        if (this.getViaHeaders() == null) {
            return null;
        }
        return (ViaHeader)this.getViaHeaders().getFirst();
    }

    public CSeqHeader getCSeqHeader() {
        return this.cSeqHeader;
    }

    public int getCSeqHeaderNumber() {
        return this.cSeqHeader.getSequenceNumber();
    }

    public RouteList getRouteHeaders() {
        return (RouteList)this.getHeaderList("Route");
    }

    public CallIdHeader getCallId() {
        return this.callIdHeader;
    }

    public void setCallId(CallIdHeader callId) throws SipException {
        this.setHeader(callId);
    }

    public void setCallId(String callId) throws ParseException, SipException {
        if (this.callIdHeader == null) {
            this.setHeader(new CallIdHeader());
        }
        this.callIdHeader.setCallId(callId);
    }

    public String getCallIdentifier() {
        return this.callIdHeader.getCallId();
    }

    public RecordRouteList getRecordRouteHeaders() {
        return (RecordRouteList)this.getHeaderList("Record-Route");
    }

    public ToHeader getTo() {
        return this.toHeader;
    }

    public void setTo(ToHeader to) throws SipException {
        this.setHeader(to);
    }

    public void setFromHeader(FromHeader from) throws SipException {
        this.setHeader(from);
    }

    public ContentLengthHeader getContentLengthHeader() {
        return this.contentLengthHeader;
    }

    public String getMessageContent() throws UnsupportedEncodingException {
        if (this.messageContent == null && this.messageContentBytes == null) {
            return null;
        }
        if (this.messageContent == null) {
            String charset;
            ContentTypeHeader contentTypeHeader = (ContentTypeHeader)this.nameTable.get("Content-Type".toLowerCase());
            this.messageContent = contentTypeHeader != null ? ((charset = contentTypeHeader.getCharset()) != null ? new String(this.messageContentBytes, charset) : new String(this.messageContentBytes, DEFAULT_ENCODING)) : new String(this.messageContentBytes, DEFAULT_ENCODING);
        }
        return this.messageContent;
    }

    public byte[] getRawContent() {
        try {
            if (this.messageContent == null && this.messageContentBytes == null && this.messageContentObject == null) {
                return null;
            }
            if (this.messageContentObject != null) {
                String charset;
                String messageContent = this.messageContentObject.toString();
                ContentTypeHeader contentTypeHeader = (ContentTypeHeader)this.nameTable.get("Content-Type".toLowerCase());
                byte[] messageContentBytes = contentTypeHeader != null ? ((charset = contentTypeHeader.getCharset()) != null ? messageContent.getBytes(charset) : messageContent.getBytes(DEFAULT_ENCODING)) : messageContent.getBytes(DEFAULT_ENCODING);
                return messageContentBytes;
            }
            if (this.messageContent != null) {
                String charset;
                ContentTypeHeader contentTypeHeader = (ContentTypeHeader)this.nameTable.get("Content-Type".toLowerCase());
                byte[] messageContentBytes = contentTypeHeader != null ? ((charset = contentTypeHeader.getCharset()) != null ? this.messageContent.getBytes(charset) : this.messageContent.getBytes(DEFAULT_ENCODING)) : this.messageContent.getBytes(DEFAULT_ENCODING);
                return messageContentBytes;
            }
            return this.messageContentBytes;
        }
        catch (UnsupportedEncodingException ex) {
            InternalErrorHandler.handleException(ex);
            return null;
        }
    }

    public void setMessageContent(String type, String subType, String messageContent) throws IllegalArgumentException {
        if (messageContent == null) {
            throw new IllegalArgumentException("messgeContent is null");
        }
        ContentTypeHeader ct = new ContentTypeHeader(type, subType);
        try {
            this.setHeader(ct);
        }
        catch (SipException se) {
            throw new IllegalArgumentException(se.getMessage());
        }
        this.messageContentBytes = null;
        this.messageContentObject = null;
        ContentLengthHeader h = this.getContentLengthHeader();
        if (h != null) {
            h.setContentLength(messageContent.length());
        }
    }

    public void setContent(Object content, ContentTypeHeader contentTypeHeader) throws SipException {
        if (content == null) {
            throw new NullPointerException("null content");
        }
        String contentString = content.toString();
        this.setMessageContent(contentString);
        this.setHeader(contentTypeHeader);
        this.removeContent();
        if (content instanceof String) {
            this.messageContent = (String)content;
        } else if (content instanceof byte[]) {
            this.messageContentBytes = (byte[])content;
        } else {
            this.messageContentObject = content;
        }
        int length = -1;
        if (content instanceof String) {
            length = ((String)content).length();
        } else if (content instanceof byte[]) {
            length = ((byte[])content).length;
        }
        ContentLengthHeader h = this.getContentLengthHeader();
        if (length != -1 && h != null) {
            h.setContentLength(length);
        }
    }

    public void setContent(Object content) {
        if (content == null) {
            throw new NullPointerException("null content");
        }
        String contentString = content.toString();
        this.setMessageContent(contentString);
        this.removeContent();
        if (content instanceof String) {
            this.messageContent = (String)content;
        } else if (content instanceof byte[]) {
            this.messageContentBytes = (byte[])content;
        } else {
            this.messageContentObject = content;
        }
        int length = -1;
        if (content instanceof String) {
            length = ((String)content).length();
        } else if (content instanceof byte[]) {
            length = ((byte[])content).length;
        }
        ContentLengthHeader h = this.getContentLengthHeader();
        if (length != -1 && h != null) {
            h.setContentLength(length);
        }
    }

    public Object getContent() {
        if (this.messageContentObject != null) {
            return this.messageContentObject;
        }
        if (this.messageContentBytes != null) {
            return this.messageContentBytes;
        }
        if (this.messageContent != null) {
            return this.messageContent;
        }
        return null;
    }

    public void setMessageContent(String type, String subType, byte[] messageContent) throws SipException {
        ContentTypeHeader ct = new ContentTypeHeader(type, subType);
        this.setHeader(ct);
        this.setMessageContent(messageContent);
        ContentLengthHeader h = this.getContentLengthHeader();
        if (h != null) {
            h.setContentLength(messageContent.length);
        }
    }

    public void setMessageContent(String content) {
        ContentLengthHeader h = this.getContentLengthHeader();
        if (h != null) {
            int clength = content == null ? 0 : content.length();
            h.setContentLength(clength);
        }
        this.messageContent = content;
        this.messageContentBytes = null;
        this.messageContentObject = null;
    }

    public void setMessageContent(byte[] content) {
        ContentLengthHeader h = this.getContentLengthHeader();
        if (h != null) {
            h.setContentLength(content.length);
        }
        this.messageContentBytes = content;
        this.messageContent = null;
        this.messageContentObject = null;
    }

    public void removeContent() {
        this.messageContent = null;
        this.messageContentBytes = null;
        this.messageContentObject = null;
    }

    public Enumeration getHeaders(String headerName) {
        if (headerName == null) {
            throw new NullPointerException("null headerName");
        }
        Header sipHeader = (Header)this.nameTable.get(NameMap.expandHeaderName(headerName).toLowerCase());
        if (sipHeader == null) {
            return new Vector().elements();
        }
        if (sipHeader instanceof HeaderList) {
            return ((HeaderList)sipHeader).getElements();
        }
        Vector<Header> v = new Vector<Header>();
        v.addElement(sipHeader);
        return v.elements();
    }

    public HeaderList getHeaderList(String headerName) {
        Header header = (Header)this.nameTable.get(NameMap.expandHeaderName(headerName).toLowerCase());
        if (header == null) {
            return null;
        }
        if (header instanceof HeaderList) {
            return (HeaderList)header;
        }
        HeaderList hl = new HeaderList();
        hl.add(header);
        return hl;
    }

    public boolean hasHeader(String headerName) {
        return this.nameTable.containsKey(NameMap.expandHeaderName(headerName).toLowerCase());
    }

    public boolean hasFromHeaderTag() {
        return this.fromHeader != null && this.fromHeader.getTag() != null;
    }

    public boolean hasToTag() {
        return this.toHeader != null && this.toHeader.getTag() != null;
    }

    public String getFromHeaderTag() {
        return this.fromHeader == null ? null : this.fromHeader.getTag();
    }

    public void setFromHeaderTag(String tag) throws SipException {
        this.fromHeader.setTag(tag);
    }

    public void setToTag(String tag) throws SipException {
        this.toHeader.setTag(tag);
    }

    public String getToTag() {
        return this.toHeader == null ? null : this.toHeader.getTag();
    }

    public abstract String getFirstLine();

    public void addHeader(Header sipHeader) throws SipException {
        Header sh = sipHeader;
        this.attachHeader(sh, false, true);
    }

    public void addUnparsed(String unparsed) {
        this.unrecognizedHeaders.addElement(unparsed);
    }

    public void addHeader(String sipHeader) throws SipException {
        String hdrString = sipHeader.trim() + "\n";
        try {
            HeaderParser parser = ParserFactory.createParser(sipHeader);
            Header sh = parser.parse();
            this.attachHeader(sh, false);
        }
        catch (ParseException ex) {
            this.unrecognizedHeaders.addElement(hdrString);
        }
    }

    public Enumeration getUnrecognizedHeaders() {
        return this.unrecognizedHeaders.elements();
    }

    public Enumeration getHeaderNames() {
        Enumeration li = this.headers.elements();
        Vector<String> retval = new Vector<String>();
        while (li.hasMoreElements()) {
            Header sipHeader = (Header)li.nextElement();
            String name = sipHeader.getName();
            retval.addElement(name);
        }
        return retval.elements();
    }

    public boolean equals(Object other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        Message otherMessage = (Message)other;
        Enumeration values = this.nameTable.elements();
        Hashtable otherNameTable = otherMessage.nameTable;
        if (otherNameTable.size() != this.nameTable.size()) {
            return false;
        }
        while (values.hasMoreElements()) {
            Header mine = (Header)values.nextElement();
            String mineName = NameMap.expandHeaderName(mine.getHeaderName()).trim().toLowerCase();
            Header hisHeader = (Header)otherNameTable.get(mineName);
            String his = null;
            if (hisHeader != null) {
                his = hisHeader.toString().trim();
            }
            if (his == null) {
                return false;
            }
            if (his.equals(mine.toString().trim())) continue;
            return false;
        }
        return true;
    }

    public void setContentLength(ContentLengthHeader contentLength) throws SipException {
        this.setHeader(contentLength);
    }

    public void setCSeqHeader(CSeqHeader cseqHeader) throws SipException {
        this.setHeader(cseqHeader);
    }

    public abstract void setSIPVersion(String var1) throws ParseException;

    public abstract String getSIPVersion();

    static {
        try {
            sipHeaderListClass = Class.forName("gov.nist.siplite.header.HeaderList");
        }
        catch (ClassNotFoundException ex) {
            InternalErrorHandler.handleException(ex);
        }
    }
}

