/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.message;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.ParseException;
import gov.nist.core.Utils;
import gov.nist.siplite.address.SipURI;
import gov.nist.siplite.address.URI;
import gov.nist.siplite.header.AcceptContactHeader;
import gov.nist.siplite.header.CSeqHeader;
import gov.nist.siplite.header.CallIdHeader;
import gov.nist.siplite.header.ContactList;
import gov.nist.siplite.header.ContentLengthHeader;
import gov.nist.siplite.header.ContentTypeHeader;
import gov.nist.siplite.header.ExpiresHeader;
import gov.nist.siplite.header.FromHeader;
import gov.nist.siplite.header.Header;
import gov.nist.siplite.header.MaxForwardsHeader;
import gov.nist.siplite.header.RecordRouteList;
import gov.nist.siplite.header.RequestLine;
import gov.nist.siplite.header.RouteList;
import gov.nist.siplite.header.ToHeader;
import gov.nist.siplite.header.ViaHeader;
import gov.nist.siplite.header.ViaList;
import gov.nist.siplite.message.Message;
import gov.nist.siplite.message.Response;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.microedition.sip.SipException;

public final class Request
extends Message {
    public static final String ACK = "ACK";
    public static final String BYE = "BYE";
    public static final String CANCEL = "CANCEL";
    public static final String INVITE = "INVITE";
    public static final String OPTIONS = "OPTIONS";
    public static final String REGISTER = "REGISTER";
    public static final String NOTIFY = "NOTIFY";
    public static final String SUBSCRIBE = "SUBSCRIBE";
    public static final String MESSAGE = "MESSAGE";
    public static final String REFER = "REFER";
    public static final String INFO = "INFO";
    public static final String PRACK = "PRACK";
    public static final String UPDATE = "UPDATE";
    public static final String PUBLISH = "PUBLISH";
    public static final String DEFAULT_USER = "ip";
    public static final int DEFAULT_TTL = 1;
    public static final String DEFAULT_TRANSPORT = "UDP";
    public static final String DEFAULT_METHOD = "INVITE";
    private Object transactionPointer;
    protected RequestLine requestLine;

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public void setRequestLine(RequestLine requestLine) {
        this.requestLine = requestLine;
    }

    protected void checkHeaders() throws ParseException {
        String prefix = "Missing Header ";
        if (this.getCSeqHeader() == null) {
            throw new ParseException(prefix + "CSeq", 0);
        }
        if (this.getTo() == null) {
            throw new ParseException(prefix + "To", 0);
        }
        if (this.getFromHeader() == null) {
            throw new ParseException(prefix + "From", 0);
        }
        if (this.getViaHeaders() == null) {
            throw new ParseException(prefix + "Via", 0);
        }
        if (this.requestLine != null && this.requestLine.getMethod() != null && this.getCSeqHeader().getMethod() != null && Request.compareToIgnoreCase(this.requestLine.getMethod(), this.getCSeqHeader().getMethod()) != 0) {
            throw new ParseException("CSEQ method mismatch with Request-Line ", 0);
        }
    }

    protected void setDefaults() {
        if (this.requestLine == null) {
            return;
        }
        String method = this.requestLine.getMethod();
        if (method == null) {
            return;
        }
        URI u = this.requestLine.getUri();
        if (u == null) {
            return;
        }
        if ((method.compareTo(REGISTER) == 0 || method.compareTo("INVITE") == 0) && u instanceof SipURI) {
            SipURI sipUri = (SipURI)u;
            sipUri.setUserParam(DEFAULT_USER);
            try {
                sipUri.setTransportParam(DEFAULT_TRANSPORT);
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
    }

    protected void setRequestLineDefaults() {
        CSeqHeader cseq;
        String method = this.requestLine.getMethod();
        if (method == null && (cseq = this.getCSeqHeader()) != null) {
            method = cseq.getMethod();
            this.requestLine.setMethod(method);
        }
    }

    public URI getRequestURI() {
        if (this.requestLine == null) {
            return null;
        }
        return this.requestLine.getUri();
    }

    public void setRequestURI(URI uri) {
        if (this.requestLine == null) {
            this.requestLine = new RequestLine();
        }
        this.requestLine.setUri(uri);
    }

    public void setMethod(String method) throws IllegalArgumentException {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        if (this.requestLine == null) {
            this.requestLine = new RequestLine();
        }
        this.requestLine.setMethod(method);
        if (this.cSeqHeader != null) {
            this.cSeqHeader.setMethod(method);
        }
    }

    public String getMethod() {
        if (this.requestLine == null) {
            return null;
        }
        return this.requestLine.getMethod();
    }

    public String encode() {
        String retval;
        if (this.requestLine != null) {
            this.setRequestLineDefaults();
            retval = this.requestLine.encode() + super.encode();
        } else {
            retval = super.encode();
        }
        return retval;
    }

    public String toString() {
        return this.encode();
    }

    public Object clone() {
        Request retval = (Request)super.clone();
        if (this.requestLine != null) {
            retval.requestLine = (RequestLine)this.requestLine.clone();
            retval.setRequestLineDefaults();
        }
        return retval;
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        Request that = (Request)other;
        boolean retval = this.requestLine.equals(that.requestLine) && super.equals(other);
        return retval;
    }

    public byte[] encodeAsBytes() {
        byte[] rlbytes = null;
        if (this.requestLine != null) {
            try {
                rlbytes = this.requestLine.encode().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException(ex);
            }
        }
        byte[] superbytes = super.encodeAsBytes();
        byte[] retval = new byte[rlbytes.length + superbytes.length];
        boolean i = false;
        System.arraycopy(rlbytes, 0, retval, 0, rlbytes.length);
        System.arraycopy(superbytes, 0, retval, rlbytes.length, superbytes.length);
        return retval;
    }

    public Response createResponse(int statusCode) {
        String reasonPhrase = Response.getReasonPhrase(statusCode);
        return this.createResponse(statusCode, reasonPhrase);
    }

    public Response createResponse(int statusCode, String reasonPhrase) throws IllegalArgumentException {
        Response newResponse = new Response();
        try {
            newResponse.setStatusCode(statusCode);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Bad code " + statusCode);
        }
        if (reasonPhrase != null) {
            newResponse.setReasonPhrase(reasonPhrase);
        } else {
            newResponse.setReasonPhrase(Response.getReasonPhrase(statusCode));
        }
        Enumeration headerIterator = super.getHeaders();
        while (headerIterator.hasMoreElements()) {
            boolean isReliableProvResponse;
            Header nextHeader = (Header)headerIterator.nextElement();
            if (nextHeader instanceof FromHeader || nextHeader instanceof ToHeader || nextHeader instanceof ViaList || nextHeader instanceof CallIdHeader || nextHeader instanceof RecordRouteList || nextHeader instanceof CSeqHeader || nextHeader instanceof ExpiresHeader || Utils.equalsIgnoreCase(nextHeader.getName(), "Timestamp")) {
                try {
                    newResponse.attachHeader(nextHeader, false);
                }
                catch (SipException ex) {}
                continue;
            }
            if (!Utils.equalsIgnoreCase(nextHeader.getName(), "Require") || !(isReliableProvResponse = Header.isReliableTagPresent(nextHeader.getHeaderValue()))) continue;
            try {
                newResponse.attachHeader(nextHeader, true);
            }
            catch (SipException ex) {}
        }
        String method = this.getMethod();
        if (method.equals(PUBLISH) || method.equals(REGISTER)) {
            newResponse.removeHeader("Record-Route");
        }
        return newResponse;
    }

    public Request createCancelRequest() throws SipException {
        MaxForwardsHeader mfHeader;
        RouteList routeList;
        ViaHeader viaHeader;
        CallIdHeader callIdHeader;
        CSeqHeader cseqHeader;
        FromHeader fromHeader;
        Request newRequest = new Request();
        RequestLine cancelRequestLine = (RequestLine)this.getRequestLine().clone();
        cancelRequestLine.setMethod(CANCEL);
        newRequest.setRequestLine(cancelRequestLine);
        newRequest.setMethod(CANCEL);
        ToHeader toHeader = this.getTo();
        if (toHeader != null) {
            newRequest.setHeader(toHeader);
        }
        if ((fromHeader = this.getFromHeader()) != null) {
            newRequest.setHeader(fromHeader);
        }
        if ((cseqHeader = (CSeqHeader)this.getCSeqHeader().clone()) != null) {
            cseqHeader.setMethod(CANCEL);
            newRequest.setHeader(cseqHeader);
        }
        if ((callIdHeader = this.getCallId()) != null) {
            newRequest.setHeader(callIdHeader);
        }
        if ((viaHeader = this.getTopmostVia()) != null) {
            newRequest.setHeader(viaHeader);
        }
        if ((routeList = this.getRouteHeaders()) != null) {
            newRequest.setHeaders(routeList.getHeaders());
        }
        if ((mfHeader = (MaxForwardsHeader)this.getHeader("Max-Forwards")) != null) {
            newRequest.setHeader(mfHeader);
        }
        return newRequest;
    }

    public Request createAckRequest(ToHeader responseToHeader) throws SipException {
        Request newRequest = new Request();
        newRequest.setRequestLine((RequestLine)this.requestLine.clone());
        newRequest.setMethod(ACK);
        Enumeration headerIterator = this.getHeaders();
        while (headerIterator.hasMoreElements()) {
            Header nextHeader = (Header)headerIterator.nextElement();
            if (nextHeader.getHeaderName().equals("Route") || nextHeader.getHeaderName().equals("Proxy-Authorization")) continue;
            if (nextHeader instanceof ContentLengthHeader) {
                nextHeader = (Header)nextHeader.clone();
                ((ContentLengthHeader)nextHeader).setContentLength(0);
            } else {
                if (nextHeader instanceof ContentTypeHeader) continue;
                if (nextHeader instanceof CSeqHeader) {
                    CSeqHeader cseq = (CSeqHeader)nextHeader.clone();
                    cseq.setMethod(ACK);
                    nextHeader = cseq;
                } else {
                    nextHeader = nextHeader instanceof ToHeader ? (responseToHeader != null ? responseToHeader : (Header)nextHeader.clone()) : (Header)nextHeader.clone();
                }
            }
            newRequest.attachHeader(nextHeader, false);
        }
        return newRequest;
    }

    public Request createRequest(RequestLine requestLine, boolean switchHeaders) throws SipException {
        Request newRequest = new Request();
        newRequest.requestLine = requestLine;
        Enumeration headerIterator = this.getHeaders();
        while (headerIterator.hasMoreElements()) {
            Header nextHeader = (Header)headerIterator.nextElement();
            if (nextHeader instanceof CSeqHeader) {
                CSeqHeader newCseq = (CSeqHeader)nextHeader.clone();
                nextHeader = newCseq;
                newCseq.setMethod(requestLine.getMethod());
            } else {
                if (requestLine.getMethod().equals(ACK) && nextHeader instanceof ContactList) continue;
                if (nextHeader instanceof ViaList) {
                    ViaHeader via = (ViaHeader)((ViaList)nextHeader).getFirst().clone();
                    via.removeParameter("branch");
                    nextHeader = via;
                } else {
                    if (nextHeader instanceof RouteList || nextHeader instanceof RecordRouteList || nextHeader instanceof ContactList) continue;
                    if (nextHeader instanceof ToHeader) {
                        ToHeader to = (ToHeader)nextHeader;
                        if (switchHeaders) {
                            nextHeader = new FromHeader(to);
                            ((FromHeader)nextHeader).removeTag();
                        } else {
                            nextHeader = (Header)to.clone();
                            ((ToHeader)nextHeader).removeTag();
                        }
                    } else if (nextHeader instanceof FromHeader) {
                        FromHeader from = (FromHeader)nextHeader;
                        if (switchHeaders) {
                            nextHeader = new ToHeader(from);
                            ((ToHeader)nextHeader).removeTag();
                        } else {
                            nextHeader = (Header)from.clone();
                            ((FromHeader)nextHeader).removeTag();
                        }
                    } else if (nextHeader instanceof ContentLengthHeader) {
                        ContentLengthHeader cl = (ContentLengthHeader)nextHeader.clone();
                        cl.setContentLength(0);
                        nextHeader = cl;
                    } else {
                        if (nextHeader instanceof ContentTypeHeader) continue;
                        if (nextHeader instanceof MaxForwardsHeader) {
                            if (switchHeaders) {
                                MaxForwardsHeader mf = (MaxForwardsHeader)nextHeader.clone();
                                mf.setMaxForwards(70);
                                nextHeader = mf;
                            }
                        } else if (!(nextHeader instanceof CallIdHeader) && !(nextHeader instanceof MaxForwardsHeader)) continue;
                    }
                }
            }
            newRequest.attachHeader(nextHeader, false);
        }
        return newRequest;
    }

    public Request createBYERequest(boolean switchHeaders) throws SipException {
        RequestLine rl = (RequestLine)this.requestLine.clone();
        rl.setMethod(BYE);
        return this.createRequest(rl, switchHeaders);
    }

    public Request createACKRequest() throws SipException {
        RequestLine rl = (RequestLine)this.requestLine.clone();
        rl.setMethod(ACK);
        return this.createRequest(rl, false);
    }

    public String getViaHost() {
        ViaHeader via = (ViaHeader)this.getViaHeaders().getFirst();
        return via.getHost();
    }

    public int getViaPort() {
        ViaHeader via = (ViaHeader)this.getViaHeaders().getFirst();
        if (via.hasPort()) {
            return via.getPort();
        }
        return 5060;
    }

    public String getFirstLine() {
        if (this.requestLine == null) {
            return null;
        }
        return this.requestLine.encode();
    }

    public void setSIPVersion(String sipVersion) throws ParseException {
        if (sipVersion == null || !sipVersion.equals("SIP/2.0")) {
            throw new ParseException("sipVersion", 0);
        }
        this.requestLine.setSIPVersion(sipVersion);
    }

    public String getSIPVersion() {
        return this.requestLine.getSipVersion();
    }

    public Object getTransaction() {
        return this.transactionPointer;
    }

    public void setTransaction(Object transaction) {
        this.transactionPointer = transaction;
    }

    public AcceptContactHeader getAcceptContact() {
        return (AcceptContactHeader)this.getHeader("Accept-Contact");
    }
}

