/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.parser;

import gov.nist.core.ParseException;
import gov.nist.siplite.address.Address;
import gov.nist.siplite.address.URI;
import gov.nist.siplite.parser.Lexer;
import gov.nist.siplite.parser.Parser;
import gov.nist.siplite.parser.URLParser;

public class AddressParser
extends Parser {
    protected AddressParser(Lexer lexer) {
        this.lexer = lexer;
        this.lexer.selectLexer("charLexer");
    }

    public AddressParser(String address) {
        this.lexer = new Lexer("charLexer", address);
    }

    public Address address() throws ParseException {
        Address retval = new Address();
        this.lexer.SPorHT();
        if (!this.lexer.hasMoreChars()) {
            throw this.createParseException("Empty address");
        }
        char next = this.lexer.lookAhead(0);
        String displayName = null;
        if (next == '*') {
            retval.setAddressType(3);
            return retval;
        }
        if (next == '\"') {
            displayName = "\"" + this.lexer.quotedString() + "\"";
            this.lexer.getString('<');
        } else if (this.lexer.getRest().indexOf(60) > -1) {
            displayName = this.lexer.getString('<');
        }
        if (displayName != null) {
            try {
                retval.setDisplayName(displayName.trim());
            }
            catch (IllegalArgumentException exc) {
                throw this.createParseException("Wrong display name " + displayName);
            }
            retval.setAddressType(1);
        } else {
            retval.setAddressType(2);
        }
        this.lexer.SPorHT();
        URLParser uriParser = new URLParser((Lexer)this.lexer);
        URI uri = uriParser.uriReference();
        this.lexer.SPorHT();
        if (displayName != null) {
            this.lexer.match(62);
        }
        retval.setURI(uri);
        return retval;
    }
}

