/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.parser;

import gov.nist.core.ParseException;
import gov.nist.core.StringTokenizer;
import gov.nist.siplite.header.ExtensionHeader;
import gov.nist.siplite.header.Header;
import gov.nist.siplite.parser.Lexer;
import gov.nist.siplite.parser.ParametersParser;
import java.util.Stack;

public class ExtensionParser
extends ParametersParser {
    protected ExtensionParser() {
    }

    public ExtensionParser(String value) {
        super(value);
    }

    protected ExtensionParser(Lexer lexer) {
        super(lexer);
    }

    private int getDelimiterIndex(String buffer, char delimiter) {
        Stack<Character> stack = new Stack<Character>();
        for (int i = 0; i < buffer.length(); ++i) {
            char ch = buffer.charAt(i);
            char top = !stack.empty() ? ((Character)stack.peek()).charValue() : (char)'\u0000';
            if (ch == '<') {
                if (top == '\"') continue;
                stack.push(new Character(ch));
                continue;
            }
            if (ch == '>') {
                if (top != '<') continue;
                stack.pop();
                continue;
            }
            if (ch == '\"') {
                if (top == '\"') {
                    stack.pop();
                    continue;
                }
                stack.push(new Character(ch));
                continue;
            }
            if (!stack.empty() || ch != delimiter) continue;
            return i;
        }
        return -1;
    }

    public Header parse() throws ParseException {
        String name = this.lexer.getNextToken(':');
        this.lexer.consume(1);
        this.lexer.SPorHT();
        String bodyWithParam = StringTokenizer.convertNewLines(this.lexer.getRest().trim());
        char colonDelimiter = ';';
        int index = this.getDelimiterIndex(bodyWithParam, colonDelimiter);
        if (index == -1) {
            ExtensionHeader retval = new ExtensionHeader(name, bodyWithParam, bodyWithParam);
            return retval;
        }
        int currPos = this.lexer.getPtr();
        String body = StringTokenizer.convertNewLines(this.lexer.getBuffer().substring(currPos, currPos + index).trim());
        this.lexer.consume(index + 1);
        this.lexer.SPorHT();
        ExtensionHeader retval = new ExtensionHeader(name, bodyWithParam, body);
        boolean headerEnd = false;
        while (!headerEnd) {
            String paramVal;
            String paramName = this.lexer.peekLine().trim();
            int eqIndex = paramName.indexOf(61);
            int semicolonIndex = paramName.indexOf(colonDelimiter);
            if (eqIndex != -1 && (semicolonIndex > eqIndex || semicolonIndex == -1)) {
                paramName = this.lexer.getString('=');
                paramVal = this.lexer.peekLine().trim();
                if (paramVal.indexOf(colonDelimiter) != -1) {
                    paramVal = this.lexer.getString(colonDelimiter);
                } else {
                    paramVal = this.lexer.getLine().trim();
                    headerEnd = true;
                }
            } else {
                if (semicolonIndex != -1) {
                    paramName = this.lexer.getString(colonDelimiter);
                } else {
                    paramName = this.lexer.getLine().trim();
                    headerEnd = true;
                }
                paramVal = "";
            }
            paramName = paramName.trim();
            paramVal = paramVal.trim();
            paramName = paramName.toLowerCase();
            if (!Lexer.isValidName(paramName)) {
                throw new ParseException("Invalid parameter's name.", 0);
            }
            if (!Lexer.isValidParameterValue(paramVal)) {
                throw new ParseException("Invalid parameter's value.", 0);
            }
            if (retval.getParameter(paramName) != null) {
                throw new ParseException("Duplicated parameter: " + paramName, 0);
            }
            retval.setParameter(paramName, paramVal);
        }
        return retval;
    }
}

