/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.parser;

import gov.nist.core.LexerCore;
import gov.nist.core.StringTokenizer;
import gov.nist.siplite.parser.URLParser;
import java.util.Hashtable;

public class Lexer
extends LexerCore {
    public Lexer(String lexerName, String buffer) {
        super(lexerName, buffer);
        this.selectLexer(lexerName);
    }

    public static String getHeaderName(String line) {
        if (line == null) {
            return null;
        }
        String headerName = null;
        try {
            int begin = line.indexOf(":");
            headerName = null;
            if (begin >= 1) {
                headerName = line.substring(0, begin);
            }
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return headerName;
    }

    public static String getHeaderValue(String line) {
        if (line == null) {
            return null;
        }
        String headerValue = null;
        try {
            int begin = line.indexOf(":");
            headerValue = line.substring(begin + 1);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return headerValue;
    }

    public static boolean isValidName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Lexer.isValidChar(ch)) continue;
            return false;
        }
        return true;
    }

    protected static boolean isValidValue(String value, boolean isParameter) {
        if (value == null) {
            value = "";
        }
        boolean isEscaped = false;
        boolean isQuoteOn = false;
        boolean isBracketOn = false;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (isEscaped) {
                isEscaped = false;
                continue;
            }
            if (ch == '\"') {
                isQuoteOn = !isQuoteOn;
                continue;
            }
            if (isQuoteOn) continue;
            if (ch == '\\') {
                isEscaped = true;
                continue;
            }
            if (isBracketOn) {
                if (ch != '>') continue;
                isBracketOn = false;
                continue;
            }
            if (ch == '<') {
                isBracketOn = true;
                continue;
            }
            if (!(isParameter ? !Lexer.isValidChar(ch) : ch == ';')) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidHeaderValue(String value) {
        return Lexer.isValidValue(value, false);
    }

    public static boolean isValidParameterValue(String value) {
        return Lexer.isValidValue(value, true);
    }

    public static boolean isValidUserName(String name) {
        if (name == null) {
            return true;
        }
        if (name.length() == 0) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (URLParser.isUnreserved(ch) || Lexer.isEscaped(name, i) || URLParser.isUserUnreserved(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidDisplayName(String displayName) {
        if (null == displayName) {
            return false;
        }
        boolean quoted = false;
        displayName = StringTokenizer.convertNewLines(displayName);
        displayName = displayName.trim();
        int i = 0;
        if ('\"' == displayName.charAt(0)) {
            quoted = true;
            ++i;
        }
        while (i < displayName.length()) {
            char ch = displayName.charAt(i);
            if (!quoted) {
                if (!Lexer.isValidChar(ch) && ch != ' ' && ch != '\t') {
                    return false;
                }
            } else {
                if (ch < ' ' || ch == '\"' && i != displayName.length() - 1 || ch > '~' && ch < '\u00c0') {
                    return false;
                }
                if (ch == '\\') {
                    if (Lexer.isQuotedPair(displayName, i)) {
                        ++i;
                    } else {
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidScheme(String scheme) {
        if (null == scheme || 0 == scheme.length() || !Lexer.isAlpha(scheme.charAt(0))) {
            return false;
        }
        for (int i = 1; i < scheme.length(); ++i) {
            char ch = scheme.charAt(i);
            if (Character.isDigit(ch) || Lexer.isAlpha(ch) || ch == '+' || ch == '-' || ch == '.') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidIpv6Address(String address) {
        if (address == null || 0 == address.length()) {
            return false;
        }
        int len = address.length();
        int colonCount = 0;
        int hexdigCount = 0;
        for (int i = 0; i < len; ++i) {
            char ch = address.charAt(i);
            if (ch == ':') {
                ++colonCount;
                continue;
            }
            if (ch == '.') {
                int colonPos = address.lastIndexOf(58, i);
                if (colonPos > 0) {
                    return Lexer.isValidIpv4Address(address.substring(colonPos + 1));
                }
                return false;
            }
            if (hexdigCount > 4 || colonCount > 2) {
                return false;
            }
            colonCount = 0;
            if (Lexer.isHexDigit(ch)) {
                ++hexdigCount;
                continue;
            }
            if (hexdigCount > 0 && i < len - 1 && ch != ':' && ch != '.') {
                return false;
            }
            hexdigCount = 0;
            if (Character.isDigit(ch) || ch == '.') continue;
            return false;
        }
        return hexdigCount <= 4 && colonCount <= 2;
    }

    public static boolean isValidIpv4Address(String address) {
        if (address == null || 0 == address.length()) {
            return false;
        }
        int len = address.length();
        int pointCount = 0;
        int digitCount = 0;
        int totalPoint = 0;
        for (int i = 0; i < len; ++i) {
            char ch = address.charAt(i);
            if (ch == '.') {
                if (i == len - 1) {
                    return false;
                }
                ++pointCount;
                ++totalPoint;
                digitCount = 0;
                continue;
            }
            if (digitCount > 3 || pointCount > 1) {
                return false;
            }
            pointCount = 0;
            if (!Lexer.isDigit(ch)) {
                return false;
            }
            ++digitCount;
        }
        return totalPoint == 3;
    }

    public static boolean isValidHostname(String address) {
        String toplabel;
        if (address == null || 0 == address.length()) {
            return false;
        }
        boolean pCount = false;
        boolean isHostname = false;
        for (int i = 0; i < address.length(); ++i) {
            char c = address.charAt(i);
            if (c == '.' || Lexer.isAlpha(c) || c == '-' || Lexer.isDigit(c)) continue;
            return false;
        }
        int lastPointPos = address.lastIndexOf(46);
        if (lastPointPos == address.length() - 1) {
            if (0 == lastPointPos) {
                return false;
            }
            lastPointPos = address.lastIndexOf(46, lastPointPos - 1);
        }
        return Lexer.isAlpha((toplabel = address.substring(lastPointPos + 1)).charAt(0));
    }

    public void selectLexer(String lexerName) {
        this.currentLexer = (Hashtable)lexerTables.get(lexerName);
        this.currentLexerName = lexerName;
        if (this.currentLexer == null) {
            this.addLexer(lexerName);
            if (lexerName.equals("method_keywordLexer")) {
                this.addKeyword("REGISTER".toUpperCase(), 2052);
                this.addKeyword("ACK".toUpperCase(), 2054);
                this.addKeyword("OPTIONS".toUpperCase(), 2056);
                this.addKeyword("BYE".toUpperCase(), 2055);
                this.addKeyword("INVITE".toUpperCase(), 2053);
                this.addKeyword("SUBSCRIBE".toUpperCase(), 2101);
                this.addKeyword("NOTIFY".toUpperCase(), 2102);
                this.addKeyword("MESSAGE".toUpperCase(), 2116);
                this.addKeyword("PUBLISH".toUpperCase(), 2121);
                this.addKeyword("REFER".toUpperCase(), 2117);
                this.addKeyword("INFO".toUpperCase(), 2119);
                this.addKeyword("UPDATE".toUpperCase(), 2120);
            } else if (lexerName.equals("command_keywordLexer")) {
                this.addKeyword("From".toUpperCase(), 2062);
                this.addKeyword("To".toUpperCase(), 2063);
                this.addKeyword("Via".toUpperCase(), 2064);
                this.addKeyword("Route".toUpperCase(), 2070);
                this.addKeyword("Max-Forwards".toUpperCase(), 2079);
                this.addKeyword("Authorization".toUpperCase(), 2071);
                this.addKeyword("Proxy-Authorization".toUpperCase(), 2072);
                this.addKeyword("Date".toUpperCase(), 2080);
                this.addKeyword("Content-Encoding".toUpperCase(), 2083);
                this.addKeyword("Content-Length".toUpperCase(), 2084);
                this.addKeyword("Content-Type".toUpperCase(), 2086);
                this.addKeyword("Contact".toUpperCase(), 2087);
                this.addKeyword("Call-ID".toUpperCase(), 2088);
                this.addKeyword("Expires".toUpperCase(), 2090);
                this.addKeyword("Record-Route".toUpperCase(), 2092);
                this.addKeyword("CSeq".toUpperCase(), 2094);
                this.addKeyword("WWW-Authenticate".toUpperCase(), 2096);
                this.addKeyword("Proxy-Authenticate".toUpperCase(), 2082);
                this.addKeyword("Event".toUpperCase(), 2111);
                this.addKeyword("Subject".toUpperCase(), 2085);
                this.addKeyword("Supported".toUpperCase(), 2077);
                this.addKeyword("Allow-Events".toUpperCase(), 2113);
                this.addKeyword("Accept-Contact".toUpperCase(), 2122);
                this.addKeyword("C".toUpperCase(), 2086);
                this.addKeyword("F".toUpperCase(), 2062);
                this.addKeyword("I".toUpperCase(), 2088);
                this.addKeyword("M".toUpperCase(), 2087);
                this.addKeyword("E".toUpperCase(), 2083);
                this.addKeyword("L".toUpperCase(), 2084);
                this.addKeyword("C".toUpperCase(), 2086);
                this.addKeyword("T".toUpperCase(), 2063);
                this.addKeyword("V".toUpperCase(), 2064);
                this.addKeyword("O".toUpperCase(), 2111);
                this.addKeyword("S".toUpperCase(), 2085);
                this.addKeyword("K".toUpperCase(), 2077);
                this.addKeyword("U".toUpperCase(), 2113);
                this.addKeyword("A".toUpperCase(), 2122);
            } else if (lexerName.equals("status_lineLexer") || lexerName.equals("request_lineLexer")) {
                this.addKeyword("SIP".toUpperCase(), 2051);
                this.addKeyword("SIPS".toUpperCase(), 2115);
            } else if (lexerName.equals("sip_urlLexer")) {
                this.addKeyword("TEL".toUpperCase(), 2105);
                this.addKeyword("SIP".toUpperCase(), 2051);
                this.addKeyword("SIPS".toUpperCase(), 2115);
            }
        }
    }
}

