/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.parser;

import gov.nist.core.ParseException;
import gov.nist.siplite.header.Header;
import gov.nist.siplite.header.ParameterLessHeader;
import gov.nist.siplite.header.RAckHeader;
import gov.nist.siplite.header.RSeqHeader;
import gov.nist.siplite.parser.HeaderParser;
import gov.nist.siplite.parser.Lexer;

public class ParameterLessParser
extends HeaderParser {
    protected ParameterLessParser() {
    }

    public ParameterLessParser(String value) {
        super(value);
    }

    protected ParameterLessParser(Lexer lexer) {
        super(lexer);
    }

    public Header parse() throws ParseException {
        try {
            ParameterLessHeader retval;
            String name = this.lexer.getNextToken(':');
            this.lexer.consume(1);
            String value = this.lexer.getLine().trim();
            if (name.equalsIgnoreCase("RAck")) {
                retval = new RAckHeader();
                ((Header)retval).setHeaderValue(value);
            } else if (name.equalsIgnoreCase("RSeq")) {
                retval = new RSeqHeader();
                ((Header)retval).setHeaderValue(value);
            } else {
                retval = new ParameterLessHeader(name, value);
            }
            return retval;
        }
        catch (Exception e) {
            throw new ParseException("Error in parse(): " + e.getMessage(), 0);
        }
    }
}

