/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.parser;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.ParseException;
import gov.nist.siplite.header.Header;
import gov.nist.siplite.header.NameMap;
import gov.nist.siplite.parser.AcceptContactParser;
import gov.nist.siplite.parser.AuthorizationParser;
import gov.nist.siplite.parser.CSeqParser;
import gov.nist.siplite.parser.CallIDParser;
import gov.nist.siplite.parser.ContactParser;
import gov.nist.siplite.parser.ContentLengthParser;
import gov.nist.siplite.parser.ContentTypeParser;
import gov.nist.siplite.parser.DateParser;
import gov.nist.siplite.parser.EventParser;
import gov.nist.siplite.parser.ExpiresParser;
import gov.nist.siplite.parser.ExtensionParser;
import gov.nist.siplite.parser.FromParser;
import gov.nist.siplite.parser.HeaderParser;
import gov.nist.siplite.parser.Lexer;
import gov.nist.siplite.parser.MaxForwardsParser;
import gov.nist.siplite.parser.ParameterLessParser;
import gov.nist.siplite.parser.ProxyAuthenticateParser;
import gov.nist.siplite.parser.ProxyAuthorizationParser;
import gov.nist.siplite.parser.RecordRouteParser;
import gov.nist.siplite.parser.RouteParser;
import gov.nist.siplite.parser.SubscriptionStateParser;
import gov.nist.siplite.parser.ToParser;
import gov.nist.siplite.parser.ViaParser;
import gov.nist.siplite.parser.WWWAuthenticateParser;
import java.util.Hashtable;

public class ParserFactory {
    private static Hashtable parserTable = new Hashtable();
    private static Class[] constructorArgs = new Class[1];

    public static HeaderParser createParser(String line) throws ParseException {
        String headerName = Lexer.getHeaderName(line);
        String headerValue = Lexer.getHeaderValue(line);
        if (headerName == null || headerValue == null) {
            throw new ParseException("The header name or value is null", 0);
        }
        Class parserClass = (Class)parserTable.get((headerName = NameMap.expandHeaderName(headerName)).toLowerCase());
        if (parserClass != null) {
            ReflectiveOperationException ex = null;
            try {
                HeaderParser retval = (HeaderParser)parserClass.newInstance();
                retval.setHeaderToParse(line);
                return retval;
            }
            catch (InstantiationException ie) {
                ex = ie;
            }
            catch (IllegalAccessException iae) {
                ex = iae;
            }
            if (ex != null) {
                InternalErrorHandler.handleException(ex);
            }
            return null;
        }
        if (Header.isParameterLess(headerName) || headerName.equalsIgnoreCase("RSeq") || headerName.equalsIgnoreCase("RAck")) {
            ParameterLessParser retval = new ParameterLessParser(line);
            return retval;
        }
        ExtensionParser retval = new ExtensionParser(line);
        return retval;
    }

    static {
        ParserFactory.constructorArgs[0] = new String().getClass();
        parserTable.put("t", new ToParser().getClass());
        parserTable.put("To".toLowerCase(), new ToParser().getClass());
        parserTable.put("From".toLowerCase(), new FromParser().getClass());
        parserTable.put("f", new FromParser().getClass());
        parserTable.put("CSeq".toLowerCase(), new CSeqParser().getClass());
        parserTable.put("Via".toLowerCase(), new ViaParser().getClass());
        parserTable.put("v", new ViaParser().getClass());
        parserTable.put("Contact".toLowerCase(), new ContactParser().getClass());
        parserTable.put("m", new ContactParser().getClass());
        parserTable.put("Content-Type".toLowerCase(), new ContentTypeParser().getClass());
        parserTable.put("c", new ContentTypeParser().getClass());
        parserTable.put("Content-Length".toLowerCase(), new ContentLengthParser().getClass());
        parserTable.put("l", new ContentLengthParser().getClass());
        parserTable.put("Authorization".toLowerCase(), new AuthorizationParser().getClass());
        parserTable.put("WWW-Authenticate".toLowerCase(), new WWWAuthenticateParser().getClass());
        parserTable.put("Call-ID".toLowerCase(), new CallIDParser().getClass());
        parserTable.put("i", new CallIDParser().getClass());
        parserTable.put("Route".toLowerCase(), new RouteParser().getClass());
        parserTable.put("Record-Route".toLowerCase(), new RecordRouteParser().getClass());
        parserTable.put("Date".toLowerCase(), new DateParser().getClass());
        parserTable.put("Proxy-Authorization".toLowerCase(), new ProxyAuthorizationParser().getClass());
        parserTable.put("Proxy-Authenticate".toLowerCase(), new ProxyAuthenticateParser().getClass());
        parserTable.put("Max-Forwards".toLowerCase(), new MaxForwardsParser().getClass());
        parserTable.put("Expires".toLowerCase(), new ExpiresParser().getClass());
        parserTable.put("Event".toLowerCase(), new EventParser().getClass());
        parserTable.put("o", new EventParser().getClass());
        parserTable.put("Subscription-State".toLowerCase(), new SubscriptionStateParser().getClass());
        parserTable.put("a", new AcceptContactParser().getClass());
        parserTable.put("Accept-Contact".toLowerCase(), new AcceptContactParser().getClass());
    }
}

