/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.parser;

import gov.nist.core.ParseException;
import gov.nist.siplite.header.ContentLengthHeader;
import gov.nist.siplite.message.Message;
import gov.nist.siplite.parser.SIPMessageListener;
import gov.nist.siplite.parser.StringMsgParser;
import java.io.IOException;
import java.io.InputStream;

public final class PipelinedMsgParser
implements Runnable {
    protected SIPMessageListener sipMessageListener;
    private Thread mythread;
    private byte[] messageBody;
    private boolean errorFlag;
    private InputStream rawInputStream;

    protected PipelinedMsgParser() {
    }

    public PipelinedMsgParser(SIPMessageListener sipMessageListener, InputStream in, boolean debug) {
        this();
        this.sipMessageListener = sipMessageListener;
        this.rawInputStream = in;
        this.mythread = new Thread(this);
    }

    public PipelinedMsgParser(SIPMessageListener mhandler, InputStream in) {
        this(mhandler, in, false);
    }

    public PipelinedMsgParser(InputStream in) {
        this(null, in, false);
    }

    public void processInput() {
        this.mythread.start();
    }

    protected Object clone() {
        PipelinedMsgParser p = new PipelinedMsgParser();
        p.rawInputStream = this.rawInputStream;
        p.sipMessageListener = this.sipMessageListener;
        return p;
    }

    public void setMessageListener(SIPMessageListener mlistener) {
        this.sipMessageListener = mlistener;
    }

    private String readLine(InputStream inputStream) throws IOException {
        char ch;
        StringBuffer retval = new StringBuffer("");
        do {
            int i;
            if ((i = inputStream.read()) == -1) {
                throw new IOException("End of stream");
            }
            ch = (char)i;
            if (ch == '\r') continue;
            retval.append(ch);
        } while (ch != '\n');
        return retval.toString();
    }

    private String readToBreak(InputStream inputStream) throws IOException {
        int i;
        StringBuffer retval = new StringBuffer("");
        boolean flag = false;
        while ((i = inputStream.read()) != -1) {
            char ch = (char)i;
            if (ch != '\r') {
                retval.append(ch);
            }
            if (ch != '\n') continue;
            if (flag) break;
            flag = true;
        }
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        InputStream inputStream = null;
        inputStream = this.rawInputStream;
        try {
            while (true) {
                String line1;
                StringBuffer inputBuffer = new StringBuffer();
                String line2 = null;
                while ((line1 = this.readLine(inputStream)).equals("\n")) {
                }
                inputBuffer.append(line1);
                do {
                    line2 = this.readLine(inputStream);
                    inputBuffer.append(line2);
                } while (!line2.trim().equals(""));
                inputBuffer.append(line2);
                StringMsgParser smp = new StringMsgParser(this.sipMessageListener);
                smp.readBody = false;
                Message sipMessage = null;
                try {
                    sipMessage = smp.parseSIPMessage(inputBuffer.toString());
                    if (sipMessage == null) {
                    }
                }
                catch (ParseException ex) {}
                continue;
                ContentLengthHeader cl = sipMessage.getContentLengthHeader();
                int contentLength = 0;
                contentLength = cl != null ? cl.getContentLength() : 0;
                if (contentLength == 0) {
                    sipMessage.removeContent();
                } else {
                    int readlength;
                    contentLength = cl.getContentLength();
                    byte[] message_body = new byte[contentLength];
                    for (int nread = 0; nread < contentLength && (readlength = inputStream.read(message_body, nread, contentLength - nread)) > 0; nread += readlength) {
                    }
                    sipMessage.setMessageContent(message_body);
                }
                if (this.sipMessageListener == null) continue;
                this.sipMessageListener.processMessage(sipMessage);
            }
        }
        catch (IOException ex) {
            if (this.sipMessageListener != null) {
                this.sipMessageListener.handleIOException();
            }
        }
    }
}

