/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.parser;

import gov.nist.core.ParseException;
import gov.nist.siplite.header.StatusLine;
import gov.nist.siplite.parser.Lexer;
import gov.nist.siplite.parser.Parser;

public class StatusLineParser
extends Parser {
    public StatusLineParser(String statusLine) {
        this.lexer = new Lexer("status_lineLexer", statusLine);
    }

    public StatusLineParser(Lexer lexer) {
        this.lexer = lexer;
        this.lexer.selectLexer("status_lineLexer");
    }

    protected int statusCode() throws ParseException {
        String scode = this.lexer.number();
        try {
            int retval;
            int n = retval = Integer.parseInt(scode);
            return n;
        }
        catch (NumberFormatException ex) {
            throw new ParseException(this.lexer.getBuffer() + ":" + ex.getMessage(), this.lexer.getPtr());
        }
    }

    protected String reasonPhrase() throws ParseException {
        return this.lexer.getRest().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusLine parse() throws ParseException {
        StatusLine retval = new StatusLine();
        String version = this.sipVersion();
        retval.setSipVersion(version);
        this.lexer.SPorHT();
        int scode = this.statusCode();
        retval.setStatusCode(scode);
        this.lexer.SPorHT();
        String rp = this.reasonPhrase();
        retval.setReasonPhrase(rp);
        this.lexer.SPorHT();
        StatusLine statusLine = retval;
        return statusLine;
    }
}

