/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.parser;

import gov.nist.core.Host;
import gov.nist.core.HostNameParser;
import gov.nist.core.HostPort;
import gov.nist.core.ParseException;
import gov.nist.core.StringTokenizer;
import gov.nist.siplite.address.Address;
import gov.nist.siplite.address.SipURI;
import gov.nist.siplite.address.TelephoneNumber;
import gov.nist.siplite.address.URI;
import gov.nist.siplite.header.ExtensionHeader;
import gov.nist.siplite.header.Header;
import gov.nist.siplite.header.NameMap;
import gov.nist.siplite.header.RequestLine;
import gov.nist.siplite.header.StatusLine;
import gov.nist.siplite.message.Message;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.parser.AddressParser;
import gov.nist.siplite.parser.HeaderParser;
import gov.nist.siplite.parser.Lexer;
import gov.nist.siplite.parser.ParseExceptionListener;
import gov.nist.siplite.parser.ParserFactory;
import gov.nist.siplite.parser.RequestLineParser;
import gov.nist.siplite.parser.StatusLineParser;
import gov.nist.siplite.parser.URLParser;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.microedition.sip.SipException;

public class StringMsgParser {
    protected boolean readBody = true;
    private String rawMessage;
    private String rawMessage1;
    private String currentMessage;
    private ParseExceptionListener parseExceptionListener;
    private Vector messageHeaders = new Vector(10, 10);
    private int bufferPointer = 0;
    private boolean bodyIsString;
    private byte[] currentMessageBytes;
    protected int contentLength;
    private boolean debugFlag;
    private int currentLine = 0;
    private String currentHeader;

    public StringMsgParser() {
    }

    public StringMsgParser(ParseExceptionListener exhandler) {
        this();
        this.parseExceptionListener = exhandler;
    }

    protected String getMessageBody() {
        String body;
        if (this.contentLength == 0) {
            return null;
        }
        int endIndex = this.bufferPointer + this.contentLength;
        if (endIndex > this.currentMessage.length()) {
            endIndex = this.currentMessage.length();
            body = this.currentMessage.substring(this.bufferPointer, endIndex);
            this.bufferPointer = endIndex;
        } else {
            body = this.currentMessage.substring(this.bufferPointer, endIndex);
            this.bufferPointer = endIndex + 1;
        }
        this.contentLength = 0;
        return body;
    }

    protected byte[] getBodyAsBytes() {
        if (this.contentLength == 0) {
            return null;
        }
        int endIndex = this.bufferPointer + this.contentLength;
        if (endIndex > this.currentMessageBytes.length) {
            endIndex = this.currentMessageBytes.length;
        }
        byte[] body = new byte[endIndex - this.bufferPointer];
        System.arraycopy(this.currentMessageBytes, this.bufferPointer, body, 0, body.length);
        this.bufferPointer = endIndex;
        this.contentLength = 0;
        return body;
    }

    protected String readToEnd() {
        String body = this.currentMessage.substring(this.bufferPointer);
        this.bufferPointer += body.length();
        return body;
    }

    protected byte[] readBytesToEnd() {
        byte[] body = new byte[this.currentMessageBytes.length - this.bufferPointer];
        int endIndex = this.currentMessageBytes.length;
        int i = this.bufferPointer;
        int k = 0;
        while (i < endIndex) {
            body[k] = this.currentMessageBytes[i];
            ++i;
            ++k;
        }
        this.bufferPointer = endIndex;
        this.contentLength = 0;
        return body;
    }

    public void setParseExceptionListener(ParseExceptionListener pexhandler) {
        this.parseExceptionListener = pexhandler;
    }

    protected boolean isBodyString() {
        return this.bodyIsString;
    }

    public Message parseSIPMessage(byte[] msgBuffer) throws ParseException {
        int fin;
        char chr;
        int start;
        this.bufferPointer = 0;
        this.bodyIsString = false;
        this.currentMessageBytes = msgBuffer;
        for (start = this.bufferPointer; start < msgBuffer.length && ((chr = (char)msgBuffer[start]) == '\r' || chr == '\n' || chr == '\u0000'); ++start) {
        }
        if (start == msgBuffer.length) {
            return null;
        }
        for (fin = start; fin < msgBuffer.length - 4 && ((char)msgBuffer[fin] != '\r' || (char)msgBuffer[fin + 1] != '\n' || (char)msgBuffer[fin + 2] != '\r' || (char)msgBuffer[fin + 3] != '\n'); ++fin) {
        }
        if (fin < msgBuffer.length) {
            fin += 4;
        } else {
            for (fin = start; fin < msgBuffer.length - 2 && ((char)msgBuffer[fin] != '\n' || (char)msgBuffer[fin + 1] != '\n'); ++fin) {
            }
            if (fin < msgBuffer.length) {
                fin += 2;
            } else {
                throw new ParseException("Message not terminated", 0);
            }
        }
        String messageString = null;
        try {
            messageString = new String(msgBuffer, start, fin - start, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ParseException("Bad message encoding!", 0);
        }
        this.bufferPointer = fin;
        int length = messageString.length();
        StringBuffer message = new StringBuffer(length);
        for (int k = 0; k < length; ++k) {
            char currChar = messageString.charAt(k);
            if (currChar == '\r') continue;
            message.append(currChar);
        }
        length = message.length();
        StringTokenizer tokenizer = new StringTokenizer(message.toString(), '\n');
        StringBuffer cooked_message = new StringBuffer();
        while (tokenizer.hasMoreChars()) {
            String nexttok = tokenizer.nextToken();
            if (nexttok.trim().equals("")) {
                cooked_message.append("\n");
                continue;
            }
            cooked_message.append(nexttok);
        }
        cooked_message = this.normalizeMessage(cooked_message);
        cooked_message.append("\n\n");
        this.currentMessage = cooked_message.toString();
        Message sipmsg = this.parseMessage(this.currentMessage);
        if (this.readBody && sipmsg.getContentLengthHeader() != null && sipmsg.getContentLengthHeader().getContentLength() != 0) {
            this.contentLength = sipmsg.getContentLengthHeader().getContentLength();
            byte[] body = this.getBodyAsBytes();
            sipmsg.setMessageContent(body);
        }
        return sipmsg;
    }

    public Message parseSIPMessage(String sipMessages) throws ParseException {
        int k;
        this.rawMessage = sipMessages;
        Vector retval = new Vector();
        String pmessage = sipMessages;
        this.bodyIsString = true;
        this.contentLength = 0;
        if (pmessage.trim().equals("")) {
            return null;
        }
        pmessage = pmessage + "\n\n";
        StringBuffer message = new StringBuffer(pmessage);
        while (message.charAt(0) == '\r' || message.charAt(0) == '\n') {
            ++this.bufferPointer;
            message.deleteCharAt(0);
        }
        String message1 = message.toString();
        int length = message1.indexOf("\r\n\r\n");
        if (length > 0) {
            length += 4;
        }
        if (length == -1) {
            length = message1.indexOf("\n\n");
            if (length == -1) {
                throw new ParseException("no trailing crlf", 0);
            }
        } else {
            length += 2;
        }
        for (k = 0; k < length; ++k) {
            if (message.charAt(k) != '\r') continue;
            message.deleteCharAt(k);
            --length;
        }
        if (this.debugFlag) {
            for (k = 0; k < length; ++k) {
                this.rawMessage1 = this.rawMessage1 + "[" + message.charAt(k) + "]";
            }
        }
        StringTokenizer tokenizer = new StringTokenizer(message.toString(), '\n');
        StringBuffer cooked_message = new StringBuffer();
        while (tokenizer.hasMoreChars()) {
            String nexttok = tokenizer.nextToken();
            if (nexttok.trim().equals("")) {
                cooked_message.append("\n");
                continue;
            }
            cooked_message.append(nexttok);
        }
        cooked_message = this.normalizeMessage(cooked_message);
        cooked_message.append("\n\n");
        this.currentMessage = cooked_message.toString();
        this.bufferPointer = this.currentMessage.indexOf("\n\n") + 3;
        Message sipmsg = this.parseMessage(this.currentMessage);
        if (this.readBody && sipmsg.getContentLengthHeader() != null && sipmsg.getContentLengthHeader().getContentLength() != 0) {
            this.contentLength = sipmsg.getContentLengthHeader().getContentLength();
            String body = this.getMessageBody();
            sipmsg.setMessageContent(body);
        }
        return sipmsg;
    }

    private StringBuffer normalizeMessage(StringBuffer srcMsg) {
        StringBuffer normalizedMessage = new StringBuffer(srcMsg.length());
        String message1 = srcMsg.toString();
        int length = message1.indexOf("\n\n") + 2;
        int k = 0;
        while (k < length - 1) {
            char thisChar = srcMsg.charAt(k);
            char thatChar = srcMsg.charAt(k + 1);
            if (thisChar == '\n' && (thatChar == '\t' || thatChar == ' ')) {
                char nextChar;
                normalizedMessage.append(' ');
                ++k;
                while (++k != length && ((nextChar = srcMsg.charAt(k)) == ' ' || nextChar == '\t')) {
                }
                continue;
            }
            normalizedMessage.append(thisChar);
            ++k;
        }
        return normalizedMessage;
    }

    private Message parseMessage(String currentMessage) throws ParseException {
        Message sipmsg = null;
        StringTokenizer tokenizer = new StringTokenizer(currentMessage, '\n');
        this.messageHeaders = new Vector();
        while (tokenizer.hasMoreChars()) {
            String nexttok = tokenizer.nextToken();
            if (nexttok.equals("\n")) {
                String nextnexttok = tokenizer.nextToken();
                if (nextnexttok.equals("\n")) break;
                this.messageHeaders.addElement(nextnexttok);
                continue;
            }
            this.messageHeaders.addElement(nexttok);
        }
        this.currentLine = 0;
        this.currentHeader = (String)this.messageHeaders.elementAt(this.currentLine);
        String firstLine = this.currentHeader;
        if (!firstLine.startsWith("SIP/2.0")) {
            sipmsg = new Request();
            try {
                RequestLine rl = new RequestLineParser(firstLine + "\n").parse();
                ((Request)sipmsg).setRequestLine(rl);
            }
            catch (ParseException ex) {
                if (this.parseExceptionListener != null) {
                    this.parseExceptionListener.handleException(ex, sipmsg, new RequestLine().getClass(), firstLine, currentMessage);
                }
                throw ex;
            }
        } else {
            sipmsg = new Response();
            try {
                StatusLine sl = new StatusLineParser(firstLine + "\n").parse();
                ((Response)sipmsg).setStatusLine(sl);
            }
            catch (ParseException ex) {
                if (this.parseExceptionListener != null) {
                    this.parseExceptionListener.handleException(ex, sipmsg, new StatusLine().getClass(), firstLine, currentMessage);
                }
                throw ex;
            }
        }
        for (int i = 1; i < this.messageHeaders.size(); ++i) {
            String hdrstring = (String)this.messageHeaders.elementAt(i);
            if (hdrstring == null || hdrstring.trim().equals("")) continue;
            HeaderParser hdrParser = null;
            try {
                hdrParser = ParserFactory.createParser(hdrstring + "\n");
            }
            catch (ParseException ex) {
                this.parseExceptionListener.handleException(ex, sipmsg, null, hdrstring, currentMessage);
                continue;
            }
            Header sipHeader = null;
            try {
                sipHeader = hdrParser.parse();
                sipmsg.attachHeader(sipHeader, false);
                continue;
            }
            catch (ParseException ex) {
                if (this.parseExceptionListener == null) continue;
                String hdrName = Lexer.getHeaderName(hdrstring);
                Class hdrClass = NameMap.getClassFromName(hdrName);
                if (hdrClass == null) {
                    hdrClass = ExtensionHeader.clazz;
                }
                this.parseExceptionListener.handleException(ex, sipmsg, hdrClass, hdrstring, currentMessage);
                continue;
            }
            catch (SipException ex) {
                throw new ParseException(sipHeader.toString(), 0);
            }
        }
        return sipmsg;
    }

    public Address parseAddress(String address) throws ParseException {
        AddressParser addressParser = new AddressParser(address);
        return addressParser.address();
    }

    public HostPort parseHostPort(String hostport) throws ParseException {
        Lexer lexer = new Lexer("charLexer", hostport);
        return new HostNameParser(lexer).hostPort();
    }

    public Host parseHost(String host) throws ParseException {
        Lexer lexer = new Lexer("charLexer", host);
        HostNameParser hp = new HostNameParser(lexer);
        return new Host(hp.hostName());
    }

    public TelephoneNumber parseTelephoneNumber(String telephone_number) throws ParseException {
        return new URLParser(telephone_number).parseTelephoneNumber();
    }

    public SipURI parseSIPUrl(String url) throws ParseException {
        try {
            URLParser parser = new URLParser(url);
            SipURI uri = (SipURI)parser.parse();
            if (parser.getLexer().hasMoreChars()) {
                throw new ParseException(url + " Not a URL string", parser.getLexer().getPtr());
            }
            return uri;
        }
        catch (ClassCastException ex) {
            throw new ParseException(url + " Not a SIP URL ", 0);
        }
    }

    public URI parseUrl(String url) throws ParseException {
        return new URLParser(url).parse();
    }

    public Header parseHeader(String header) throws ParseException {
        String nmessage = StringTokenizer.convertNewLines(header);
        HeaderParser hp = ParserFactory.createParser(nmessage = nmessage + "\n");
        if (hp == null) {
            throw new ParseException("could not create parser", 0);
        }
        return hp.parse();
    }

    public RequestLine parseRequestLine(String requestLine) throws ParseException {
        requestLine = requestLine + "\n";
        return new RequestLineParser(requestLine).parse();
    }

    public StatusLine parseSIPStatusLine(String statusLine) throws ParseException {
        statusLine = statusLine + "\n";
        return new StatusLineParser(statusLine).parse();
    }

    public String getCurrentHeader() {
        return this.currentHeader;
    }

    public int getCurrentLineNumber() {
        return this.currentLine;
    }
}

