/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.parser;

import gov.nist.core.HostNameParser;
import gov.nist.core.HostPort;
import gov.nist.core.LexerCore;
import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.core.ParseException;
import gov.nist.core.StringTokenizer;
import gov.nist.core.Token;
import gov.nist.siplite.address.SipURI;
import gov.nist.siplite.address.TelURL;
import gov.nist.siplite.address.TelephoneNumber;
import gov.nist.siplite.address.URI;
import gov.nist.siplite.parser.Lexer;
import gov.nist.siplite.parser.Parser;
import java.util.Vector;

public class URLParser
extends Parser {
    private static final String PHONE_DIGIT = "01234567890-.()";
    private static final String DTMF_DIGIT = "*#ABCD";
    private static final String PAUSE_CHAR = "pw";

    public URLParser(String url) {
        this.lexer = new Lexer("sip_urlLexer", url);
    }

    URLParser(Lexer lexer) {
        this.lexer = lexer;
        this.lexer.selectLexer("sip_urlLexer");
    }

    protected static boolean isMark(char next) {
        return next == '-' || next == '_' || next == '.' || next == '!' || next == '~' || next == '*' || next == '\'' || next == '(' || next == ')';
    }

    protected static boolean isUnreserved(char next) {
        return Lexer.isAlpha(next) || Lexer.isDigit(next) || URLParser.isMark(next);
    }

    protected static boolean isReservedNoSlash(char next) {
        return next == ';' || next == '?' || next == ':' || next == '@' || next == '&' || next == '+' || next == '$' || next == ',';
    }

    protected static boolean isUserUnreserved(char la) {
        return la == '&' || la == '?' || la == '+' || la == '$' || la == '#' || la == '/' || la == ',' || la == ';' || la == '=';
    }

    protected String unreserved() throws ParseException {
        char next = this.lexer.lookAhead(0);
        if (URLParser.isUnreserved(next)) {
            this.lexer.consume(1);
            return "" + next;
        }
        throw this.createParseException("unreserved");
    }

    protected String paramNameOrValue() throws ParseException {
        StringBuffer retval = new StringBuffer();
        while (this.lexer.hasMoreChars()) {
            char next = this.lexer.lookAhead(0);
            if (next == '[' || next == '[' || next == '/' || next == ':' || next == '&' || next == '+' || next == '$' || next == '#' || URLParser.isUnreserved(next)) {
                retval.append(next);
                this.lexer.consume(1);
                continue;
            }
            if (!this.isEscaped()) break;
            String esc = this.lexer.charAsString(3);
            this.lexer.consume(3);
            retval.append(esc);
        }
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NameValue uriParam() throws ParseException {
        String pvalue = null;
        String pname = this.paramNameOrValue();
        char next = this.lexer.lookAhead(0);
        if (next == '=') {
            this.lexer.consume(1);
            next = this.lexer.lookAhead(0);
            pvalue = next == '\"' ? "\"" + this.lexer.quotedString() + "\"" : this.paramNameOrValue();
        }
        NameValue nameValue = new NameValue(pname, pvalue == null ? "" : pvalue);
        return nameValue;
    }

    protected static boolean isReserved(char next) {
        return next == ';' || next == '/' || next == '?' || next == ':' || next == '@' || next == '&' || next == '+' || next == '$' || next == '=' || next == ',';
    }

    protected String reserved() throws ParseException {
        char next = this.lexer.lookAhead(0);
        if (URLParser.isReserved(next)) {
            this.lexer.consume(1);
            return "" + next;
        }
        throw this.createParseException("reserved");
    }

    protected boolean isEscaped() {
        try {
            char next = this.lexer.lookAhead(0);
            char next1 = this.lexer.lookAhead(1);
            char next2 = this.lexer.lookAhead(2);
            return next == '%' && Lexer.isHexDigit(next1) && Lexer.isHexDigit(next2);
        }
        catch (ParseException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String escaped() throws ParseException {
        StringBuffer retval = new StringBuffer();
        char next = this.lexer.lookAhead(0);
        char next1 = this.lexer.lookAhead(1);
        char next2 = this.lexer.lookAhead(2);
        if (next != '%' || !Lexer.isHexDigit(next1) || !Lexer.isHexDigit(next2)) {
            throw this.createParseException("escaped");
        }
        this.lexer.consume(3);
        retval.append(next);
        retval.append(next1);
        retval.append(next2);
        String string = retval.toString();
        return string;
    }

    protected String mark() throws ParseException {
        block3: {
            char next = this.lexer.lookAhead(0);
            if (!URLParser.isMark(next)) break block3;
            this.lexer.consume(1);
            String string = "" + next;
            return string;
        }
        throw this.createParseException("mark");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String uric() {
        block9: {
            block8: {
                char la;
                block7: {
                    la = this.lexer.lookAhead(0);
                    if (!URLParser.isUnreserved(la)) break block7;
                    this.lexer.consume(1);
                    String string = Lexer.charAsString(la);
                    return string;
                }
                if (!URLParser.isReserved(la)) break block8;
                this.lexer.consume(1);
                String string = Lexer.charAsString(la);
                return string;
            }
            if (!this.isEscaped()) break block9;
            String retval = this.lexer.charAsString(3);
            this.lexer.consume(3);
            String string = retval;
            return string;
        }
        try {
            String string = null;
            return string;
        }
        catch (ParseException ex) {
            String string = null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String uricNoSlash() {
        block9: {
            char la;
            block8: {
                block7: {
                    la = this.lexer.lookAhead(0);
                    if (!this.isEscaped()) break block7;
                    String retval = this.lexer.charAsString(3);
                    this.lexer.consume(3);
                    String string = retval;
                    return string;
                }
                if (!URLParser.isUnreserved(la)) break block8;
                this.lexer.consume(1);
                String string = Lexer.charAsString(la);
                return string;
            }
            if (!URLParser.isReservedNoSlash(la)) break block9;
            this.lexer.consume(1);
            String string = Lexer.charAsString(la);
            return string;
        }
        try {
            String string = null;
            return string;
        }
        catch (ParseException ex) {
            String string = null;
            return string;
        }
    }

    protected String uricString() {
        String next;
        StringBuffer retval = new StringBuffer();
        while ((next = this.uric()) != null) {
            retval.append(next);
        }
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI uriReference() throws ParseException {
        URI retval;
        block7: {
            retval = null;
            Vector vect = this.lexer.peekNextToken(2);
            Token t1 = (Token)vect.elementAt(0);
            Token t2 = (Token)vect.elementAt(1);
            int type1 = t1.getTokenType();
            if (t2.getTokenType() == 58) {
                if (type1 == 2051 || type1 == 2115) {
                    retval = this.sipURL(t1);
                } else if (type1 == 2105) {
                    retval = this.telURL();
                } else {
                    retval = new URI(this.lexer.getString('>'));
                    int pos = this.lexer.markInputPosition();
                    this.lexer.rewindInputPosition(pos - 1);
                }
                break block7;
            }
            throw this.createParseException("Expecting ':'");
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String base_phone_number() throws ParseException {
        StringBuffer s = new StringBuffer();
        int lc = 0;
        while (this.lexer.hasMoreChars()) {
            char w = this.lexer.lookAhead(0);
            if (LexerCore.isDigit(w) || w == '-' || w == '.' || w == '(' || w == ')') {
                this.lexer.consume(1);
                s.append(w);
                ++lc;
                continue;
            }
            if (lc > 0) break;
            throw this.createParseException("unexpected " + w);
        }
        String string = s.toString();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String local_number() throws ParseException {
        StringBuffer s = new StringBuffer();
        int lc = 0;
        while (this.lexer.hasMoreChars()) {
            char la = this.lexer.lookAhead(0);
            if (la == '*' || la == '#' || la == '-' || la == '.' || la == '(' || la == ')' || LexerCore.isDigit(la)) {
                this.lexer.consume(1);
                s.append(la);
                ++lc;
                continue;
            }
            if (lc > 0) break;
            throw this.createParseException("unexepcted " + la);
        }
        String string = s.toString();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TelephoneNumber parseTelephoneNumber() throws ParseException {
        TelephoneNumber tn;
        this.lexer.selectLexer("charLexer");
        char c = this.lexer.lookAhead(0);
        if (c == '+') {
            tn = this.global_phone_number();
        } else if (LexerCore.isAlpha(c) || LexerCore.isDigit(c) || c == '-' || c == '*' || c == '.' || c == '(' || c == ')' || c == '#') {
            tn = this.local_phone_number();
        } else {
            throw this.createParseException("unexpected char " + c);
        }
        TelephoneNumber telephoneNumber = tn;
        return telephoneNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TelephoneNumber global_phone_number() throws ParseException {
        char tok;
        TelephoneNumber tn = new TelephoneNumber();
        tn.setGlobal(true);
        NameValueList nv = null;
        this.lexer.match(43);
        String b = this.base_phone_number();
        tn.setPhoneNumber(b);
        if (this.lexer.hasMoreChars() && (tok = this.lexer.lookAhead(0)) == ';') {
            nv = this.tel_parameters();
            tn.setParameters(nv);
        }
        TelephoneNumber telephoneNumber = tn;
        return telephoneNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TelephoneNumber local_phone_number() throws ParseException {
        TelephoneNumber tn = new TelephoneNumber();
        tn.setGlobal(false);
        NameValueList nv = null;
        String b = null;
        b = this.local_number();
        tn.setPhoneNumber(b);
        if (this.lexer.hasMoreChars()) {
            Token tok = this.lexer.peekNextToken();
            switch (tok.getTokenType()) {
                case 59: {
                    nv = this.tel_parameters();
                    tn.setParameters(nv);
                    break;
                }
            }
        }
        return tn;
    }

    private NameValueList tel_parameters() throws ParseException {
        NameValueList nvList = new NameValueList();
        while (this.lexer.hasMoreChars()) {
            int i;
            this.lexer.consume(1);
            NameValue nv = this.uriParam();
            String nameParam = nv.getName();
            String valueParam = (String)nv.getValue();
            if (nameParam.equalsIgnoreCase("isub")) {
                byte[] valueBytes = valueParam.getBytes();
                for (i = 0; i < valueBytes.length; ++i) {
                    if (this.isPhoneDigit(valueBytes[i])) continue;
                    throw new IllegalArgumentException("Wrong isdn-subaddress");
                }
            } else if (nameParam.equalsIgnoreCase("postd")) {
                byte[] valueBytes = valueParam.getBytes();
                for (i = 0; i < valueBytes.length; ++i) {
                    byte ch = valueBytes[i];
                    if (this.isPhoneDigit(ch) || this.isDtmf_digit(ch) || this.isPauseChar(ch)) continue;
                    throw new IllegalArgumentException("Wrong post-dial");
                }
            }
            nvList.add(nv);
            char tok = this.lexer.lookAhead(0);
            if (tok == ';') continue;
        }
        return nvList;
    }

    private boolean isPhoneDigit(int ch) {
        return this.isCharFromString(ch, PHONE_DIGIT);
    }

    private boolean isDtmf_digit(int ch) {
        return this.isCharFromString(ch, DTMF_DIGIT);
    }

    private boolean isPauseChar(int ch) {
        return this.isCharFromString(ch, PAUSE_CHAR);
    }

    private boolean isCharFromString(int ch, String str) {
        return str.indexOf(ch) != -1;
    }

    public TelURL telURL() throws ParseException {
        this.lexer.match(2105);
        this.lexer.match(58);
        TelephoneNumber tn = this.parseTelephoneNumber();
        TelURL telUrl = new TelURL();
        telUrl.setTelephoneNumber(tn);
        return telUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SipURI sipURL(Token token) throws ParseException {
        NameValue parms;
        char la;
        SipURI retval;
        block22: {
            retval = new SipURI();
            this.lexer.match(token.getTokenType());
            this.lexer.match(58);
            retval.setScheme(token.getTokenValue());
            if (this.lexer.hasMoreChars()) break block22;
            retval.setServer();
            return retval;
        }
        int m = this.lexer.markInputPosition();
        String user = this.user();
        if (!this.lexer.hasMoreChars()) {
            this.lexer.rewindInputPosition(m);
        } else {
            la = this.lexer.lookAhead(0);
            if (la == ':' || la == '@') {
                if (user.length() == 0) {
                    throw new IllegalArgumentException("User field is missed");
                }
                if (la == ':') {
                    this.lexer.consume(1);
                    String password = this.password();
                    if (!this.lexer.hasMoreChars() || this.lexer.lookAhead(0) != '@') {
                        if (!StringTokenizer.isDigitString(password)) throw new IllegalArgumentException("Expecting \"@\"");
                        this.lexer.rewindInputPosition(m);
                    } else {
                        retval.setUser(user);
                        retval.setUserPassword(password);
                        this.lexer.consume(1);
                    }
                } else {
                    retval.setUser(user);
                    this.lexer.consume(1);
                }
            } else {
                this.lexer.rewindInputPosition(m);
            }
        }
        la = this.lexer.lookAhead(0);
        if (la == '*') {
            this.lexer.consume(1);
            retval.setServer();
            retval.setShared();
        } else if (la == ';') {
            retval.setServer();
        } else {
            HostNameParser hnp = new HostNameParser(this.getLexer());
            HostPort hp = hnp.hostPort();
            String host = hp.getHost().getHostname();
            if (host == null) {
                if (!hp.hasPort()) throw new IllegalArgumentException("Illegal URI format");
                retval.setServer();
            }
            retval.setHostPort(hp);
        }
        this.lexer.selectLexer("charLexer");
        while (this.lexer.hasMoreChars() && this.lexer.lookAhead(0) == ';') {
            this.lexer.consume(1);
            parms = this.uriParam();
            if (retval.hasParameter(parms.getName())) {
                throw new IllegalArgumentException("Found duplicate of parameter ");
            }
            if (parms.isValueQuoted() && !retval.isServer()) {
                throw new IllegalArgumentException("Client URI cannot contain quoted parameter ");
            }
            retval.setUriParameter(parms);
        }
        if (!this.lexer.hasMoreChars()) return retval;
        if (this.lexer.lookAhead(0) != '?') return retval;
        if (retval.isServer()) {
            throw new IllegalArgumentException("Server URI cannot contain headers");
        }
        this.lexer.consume(1);
        while (this.lexer.hasMoreChars()) {
            parms = this.qheader();
            retval.setQHeader(parms);
            if (this.lexer.hasMoreChars() && this.lexer.lookAhead(0) != '&') return retval;
            this.lexer.consume(1);
        }
        return retval;
    }

    public String peekScheme() throws ParseException {
        Vector tokens = this.lexer.peekNextToken(1);
        if (tokens.size() == 0) {
            return null;
        }
        String scheme = ((Token)tokens.elementAt(0)).getTokenValue();
        return scheme;
    }

    protected NameValue qheader() throws ParseException {
        String name = this.lexer.getNextToken('=');
        this.lexer.consume(1);
        String value = this.hvalue();
        return new NameValue(name, value);
    }

    protected String hvalue() throws ParseException {
        StringBuffer retval = new StringBuffer();
        while (this.lexer.hasMoreChars()) {
            char la = this.lexer.lookAhead(0);
            if (la == '+' || la == '?' || la == ':' || la == '@' || la == '[' || la == ']' || la == '/' || la == '$' || la == '_' || la == '-' || la == '\"' || la == '!' || la == '~' || la == '*' || la == '.' || la == '(' || la == ')' || LexerCore.isAlpha(la) || LexerCore.isDigit(la)) {
                this.lexer.consume(1);
                retval.append(la);
                continue;
            }
            if (la != '%') break;
            retval.append(this.escaped());
        }
        return retval.toString();
    }

    protected String urlString() throws ParseException {
        char la;
        StringBuffer retval = new StringBuffer();
        this.lexer.selectLexer("charLexer");
        while (this.lexer.hasMoreChars() && (la = this.lexer.lookAhead(0)) != ' ' && la != '\t' && la != '\n' && la != '>' && la != '<') {
            this.lexer.consume(0);
            retval.append(la);
        }
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String user() throws ParseException {
        StringBuffer retval = new StringBuffer();
        while (this.lexer.hasMoreChars()) {
            char la = this.lexer.lookAhead(0);
            if (URLParser.isUnreserved(la) || URLParser.isUserUnreserved(la)) {
                retval.append(la);
                this.lexer.consume(1);
                continue;
            }
            if (!this.isEscaped()) break;
            String esc = this.lexer.charAsString(3);
            this.lexer.consume(3);
            retval.append(esc);
        }
        String string = retval.toString();
        return string;
    }

    protected String password() throws ParseException {
        StringBuffer retval = new StringBuffer();
        while (true) {
            char la;
            if (URLParser.isUnreserved(la = this.lexer.lookAhead(0)) || la == '&' || la == '=' || la == '+' || la == '$' || la == ',') {
                retval.append(la);
                this.lexer.consume(1);
                continue;
            }
            if (!this.isEscaped()) break;
            String esc = this.lexer.charAsString(3);
            retval.append(esc);
            this.lexer.consume(3);
        }
        return retval.toString();
    }

    public URI parse() throws ParseException {
        return this.uriReference();
    }

    public URI parseWholeString() throws ParseException {
        URI retValue = this.uriReference();
        if (this.lexer.hasMoreChars()) {
            throw this.createParseException("redundant symbols");
        }
        return retValue;
    }
}

