/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.siplite.SIPUtils;
import gov.nist.siplite.header.ViaHeader;
import gov.nist.siplite.header.ViaList;
import gov.nist.siplite.message.Message;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.stack.Dialog;
import gov.nist.siplite.stack.MessageChannel;
import gov.nist.siplite.stack.MessageProcessor;
import gov.nist.siplite.stack.SIPServerException;
import gov.nist.siplite.stack.SIPServerResponseInterface;
import gov.nist.siplite.stack.SIPTransactionStack;
import gov.nist.siplite.stack.ServerLog;
import gov.nist.siplite.stack.Transaction;
import java.io.IOException;
import javax.microedition.sip.SipException;

public class ClientTransaction
extends Transaction
implements SIPServerResponseInterface {
    private Request lastRequest;
    private boolean eventPending;
    private int viaPort;
    private String viaHost;
    private SIPServerResponseInterface respondTo;

    protected ClientTransaction(SIPTransactionStack newSIPMessageStack, MessageChannel newChannelToHeaderUse) {
        super(newSIPMessageStack, newChannelToHeaderUse);
        this.setBranch(SIPUtils.generateBranchId());
    }

    public void setResponseInterface(SIPServerResponseInterface newRespondToHeader) {
        this.respondTo = newRespondToHeader;
    }

    public String getProcessingInfo() {
        return this.respondTo.getProcessingInfo();
    }

    public MessageChannel getRequestChannel() {
        return this;
    }

    public boolean isMessagePartOfTransaction(Message messageToHeaderTest) {
        return this.isMessageTransOrMult(messageToHeaderTest, false);
    }

    public boolean isMessageTransOrMult(Message messageToHeaderTest) {
        return this.isMessageTransOrMult(messageToHeaderTest, true);
    }

    private boolean isMessageTransOrMult(Message messageToHeaderTest, boolean checkMultResponse) {
        ViaList viaHeaders = messageToHeaderTest.getViaHeaders();
        String messageBranch = ((ViaHeader)viaHeaders.getFirst()).getBranch();
        boolean rfc3261Compliant = this.getBranch() != null && messageBranch != null && this.getBranch().startsWith("z9hG4bK") && messageBranch.startsWith("z9hG4bK");
        boolean transactionMatches = false;
        boolean isResponse = messageToHeaderTest instanceof Response;
        if (!this.isTerminated() || checkMultResponse && this.isTerminated() && isResponse && this.isInviteTransaction() && ((Response)messageToHeaderTest).getStatusCode() / 100 == 2) {
            if (rfc3261Compliant) {
                if (viaHeaders != null && this.getBranch().equals(((ViaHeader)viaHeaders.getFirst()).getBranch())) {
                    transactionMatches = this.getOriginalRequest().getCSeqHeader().getMethod().equals(messageToHeaderTest.getCSeqHeader().getMethod());
                }
            } else {
                transactionMatches = this.getOriginalRequest().getTransactionId().equals(messageToHeaderTest.getTransactionId());
            }
        }
        return transactionMatches;
    }

    public boolean isMultipleResponse(Response response) {
        Response lastResponse;
        boolean returnValue = false;
        if (response.getStatusCode() / 100 == 2 && this.isTerminated() && (lastResponse = this.getLastResponse()) != null) {
            String newTag = response.getToTag();
            returnValue = !newTag.equals(lastResponse.getToTag());
        }
        return returnValue;
    }

    public void sendMessage(Message messageToHeaderSend) throws IOException {
        Request transactionRequest = (Request)messageToHeaderSend;
        ViaHeader topVia = (ViaHeader)transactionRequest.getViaHeaders().getFirst();
        topVia.setBranch(this.getBranch());
        if (this.getState() == -1) {
            this.setOriginalRequest(transactionRequest);
            if (transactionRequest.getMethod().equals("INVITE")) {
                this.setState(2);
            } else if (transactionRequest.getMethod().equals("ACK")) {
                this.setState(6);
            } else {
                this.setState(1);
            }
            if (!this.isReliable()) {
                this.enableRetransmissionTimer();
            }
            if (this.isInviteTransaction()) {
                this.enableTimeoutTimer(64);
            } else {
                this.enableTimeoutTimer(64);
            }
        } else if ((this.getState() == 3 || this.getState() == 2) && transactionRequest.getMethod().equals("ACK")) {
            this.setState(6);
            this.getMessageChannel().sendMessage(transactionRequest);
            return;
        }
        try {
            this.lastRequest = transactionRequest;
            this.getMessageChannel().sendMessage(transactionRequest);
        }
        catch (IOException e) {
            this.setState(6);
            throw e;
        }
    }

    public synchronized void processResponse(Response transactionResponse, MessageChannel sourceChannel) throws SIPServerException {
        if (ServerLog.needsLogging(ServerLog.TRACE_MESSAGES)) {
            this.logResponse(transactionResponse, System.currentTimeMillis(), "normal processing");
        }
        int statusGroup = transactionResponse.getStatusCode() / 100;
        if (this.getState() == 4 && statusGroup == 1) {
            return;
        }
        while (this.eventPending) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        this.lastResponse = transactionResponse;
        if (this.dialog != null && statusGroup < 3) {
            this.dialog.addRoute(transactionResponse);
        }
        String method = transactionResponse.getCSeqHeader().getMethod();
        if (this.dialog != null) {
            boolean added = false;
            SIPTransactionStack sipStackImpl = (SIPTransactionStack)this.getSIPStack();
            if (this.dialog.getRemoteTag() == null && transactionResponse.getTo().getTag() != null) {
                if (transactionResponse.getStatusCode() != 100) {
                    this.dialog.setRemoteTag(transactionResponse.getToTag());
                }
                String dialogId = transactionResponse.getDialogId(false);
                this.dialog.setDialogId(dialogId);
                if (sipStackImpl.isDialogCreated(method) && transactionResponse.getStatusCode() != 100) {
                    sipStackImpl.putDialog(this.dialog);
                    if (statusGroup == 1) {
                        this.dialog.setState(1);
                    } else if (statusGroup == 2) {
                        this.dialog.setState(2);
                    }
                    added = true;
                }
            } else if (this.dialog.getRemoteTag() != null && transactionResponse.getToTag() != null && !this.dialog.getRemoteTag().equals(transactionResponse.getToTag())) {
                this.dialog.setRemoteTag(transactionResponse.getToTag());
                String dialogId = transactionResponse.getDialogId(false);
                this.dialog.setDialogId(dialogId);
                if (sipStackImpl.isDialogCreated(method)) {
                    sipStackImpl.putDialog(this.dialog);
                    added = true;
                }
            }
            if (sipStackImpl.isDialogCreated(method)) {
                if (transactionResponse.getToTag() != null && statusGroup == 2) {
                    this.dialog.setRemoteTag(transactionResponse.getToTag());
                    this.dialog.setState(2);
                } else if (!(transactionResponse.getStatusCode() != 487 && statusGroup != 5 && statusGroup != 6 || this.dialog.getState() != -1 && this.dialog.getState() != 1)) {
                    this.dialog.setState(4);
                }
            }
            if (transactionResponse.getCSeqHeader().getMethod().equals("BYE") && transactionResponse.getStatusCode() == 200) {
                this.dialog.setState(4);
            }
        }
        try {
            if (this.isInviteTransaction()) {
                this.inviteClientTransaction(transactionResponse, sourceChannel);
            } else {
                this.nonInviteClientTransaction(transactionResponse, sourceChannel);
            }
        }
        catch (IOException ex) {
            this.setState(6);
            this.raiseErrorEvent(2);
        }
    }

    private void nonInviteClientTransaction(Response transactionResponse, MessageChannel sourceChannel) throws IOException, SIPServerException {
        int currentState = this.getState();
        int statusCode = transactionResponse.getStatusCode();
        if (currentState == 1) {
            if (statusCode / 100 == 1) {
                this.respondTo.processResponse(transactionResponse, this);
                this.setState(3);
                this.enableRetransmissionTimer(8);
                this.enableTimeoutTimer(64);
            } else if (200 <= statusCode && statusCode <= 699) {
                this.respondTo.processResponse(transactionResponse, this);
                if (!this.isReliable()) {
                    this.setState(4);
                    this.enableTimeoutTimer(10);
                } else {
                    this.setState(6);
                }
            }
        } else if (currentState == 3 && 200 <= statusCode && statusCode <= 699) {
            this.respondTo.processResponse(transactionResponse, this);
            this.disableRetransmissionTimer();
            this.disableTimeoutTimer();
            if (!this.isReliable()) {
                this.setState(4);
                this.enableTimeoutTimer(10);
            } else {
                this.setState(6);
            }
        } else if (currentState == 3 && statusCode / 100 == 1) {
            this.respondTo.processResponse(transactionResponse, this);
        }
    }

    private void inviteClientTransaction(Response transactionResponse, MessageChannel sourceChannel) throws IOException, SIPServerException {
        int statusCode = transactionResponse.getStatusCode();
        int currentState = this.getState();
        if (currentState == 6) {
            return;
        }
        if (currentState == 2) {
            if (statusCode / 100 == 2) {
                this.respondTo.processResponse(transactionResponse, this);
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                this.setState(6);
            } else if (statusCode / 100 == 1) {
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                this.respondTo.processResponse(transactionResponse, this);
                this.setState(3);
            } else if (300 <= statusCode && statusCode <= 699) {
                this.respondTo.processResponse(transactionResponse, this);
                try {
                    this.sendMessage(this.createAck());
                }
                catch (SipException ex) {
                    InternalErrorHandler.handleException((Exception)((Object)ex));
                }
                if (!this.isReliable()) {
                    this.setState(4);
                    this.enableTimeoutTimer(64);
                } else {
                    this.setState(6);
                }
            }
        } else if (currentState == 3) {
            if (statusCode / 100 == 1) {
                this.respondTo.processResponse(transactionResponse, this);
            } else if (statusCode / 100 == 2) {
                this.setState(6);
                this.respondTo.processResponse(transactionResponse, this);
            } else if (300 <= statusCode && statusCode <= 699) {
                this.respondTo.processResponse(transactionResponse, this);
                try {
                    this.sendMessage(this.createAck());
                }
                catch (SipException ex) {
                    InternalErrorHandler.handleException((Exception)((Object)ex));
                }
                if (!this.isReliable()) {
                    this.setState(4);
                    this.enableTimeoutTimer(64);
                } else {
                    this.setState(6);
                }
            }
        } else if (currentState == 4 && 300 <= statusCode && statusCode <= 699) {
            try {
                this.sendMessage(this.createAck());
            }
            catch (SipException ex) {
                InternalErrorHandler.handleException((Exception)((Object)ex));
            }
        }
    }

    public void sendRequest() throws IOException, SipException {
        Request sipRequest = this.getOriginalRequest();
        this.sendMessage(sipRequest);
    }

    protected void fireRetransmissionTimer() {
        boolean noSend = false;
        try {
            if (this.getState() == -1) {
                noSend = true;
            } else {
                MessageProcessor mp = this.getMessageProcessor();
                if (mp == null) {
                    noSend = true;
                } else if (mp.toExit()) {
                    noSend = true;
                }
            }
            int currentState = this.getState();
            if (!(noSend || currentState != 2 && currentState != 1)) {
                this.getMessageChannel().sendMessage(this.lastRequest);
            }
        }
        catch (IOException e) {
            this.raiseErrorEvent(2);
        }
    }

    protected void fireTimeoutTimer() {
        Dialog dialogImpl = this.getDialog();
        if ((this.getState() == 2 || this.getState() == 1 || this.getState() == 3) && dialogImpl != null) {
            if (((SIPTransactionStack)this.getSIPStack()).isDialogCreated(this.getOriginalRequest().getMethod())) {
                dialogImpl.setState(4);
            } else if (this.getOriginalRequest().getMethod().equals("BYE")) {
                dialogImpl.setState(4);
            }
        }
        if (this.getState() != 4) {
            this.raiseErrorEvent(1);
        } else {
            this.setState(6);
        }
    }

    public Request createCancel() throws SipException {
        Request originalRequest = this.getOriginalRequest();
        return originalRequest.createCancelRequest();
    }

    public Request createAck() throws SipException {
        Request originalRequest = this.getOriginalRequest();
        int statusCode = 0;
        if (originalRequest.getMethod().equals("ACK")) {
            throw new SipException("Cannot ACK an ACK!", 6);
        }
        if (this.lastResponse == null) {
            throw new SipException("bad Transaction state", 5);
        }
        statusCode = this.lastResponse.getStatusCode();
        if (statusCode < 200) {
            throw new SipException("Cannot ACK a provisional response!", 6);
        }
        Request ackRequest = originalRequest.createAckRequest(this.lastResponse.getTo());
        if (300 <= statusCode && statusCode <= 699) {
            ViaHeader topmostVia = originalRequest.getTopmostVia();
            if (topmostVia != null) {
                ackRequest.setHeader(topmostVia);
            }
            return ackRequest;
        }
        this.buildRouteSet(ackRequest);
        return ackRequest;
    }

    protected void setViaPort(int port) {
        this.viaPort = port;
    }

    protected void setViaHost(String host) {
        this.viaHost = host;
    }

    public int getViaPort() {
        return this.viaPort;
    }

    public String getViaHost() {
        return this.viaHost;
    }

    public ViaHeader getOutgoingViaHeader() {
        return this.getMessageProcessor().getViaHeader();
    }

    public boolean isSecure() {
        return this.encapsulatedChannel.isSecure();
    }

    public synchronized void clearEventPending() {
        this.eventPending = false;
        this.notify();
    }

    public synchronized void setEventPending() {
        this.eventPending = true;
    }

    public ClientTransaction cloneWithNewLastResponse(Response lastResponse) {
        ClientTransaction clientTransaction = new ClientTransaction((SIPTransactionStack)this.getSIPStack(), this.getMessageChannel());
        clientTransaction.lastResponse = lastResponse;
        clientTransaction.setOriginalRequest(this.getOriginalRequest());
        return clientTransaction;
    }
}

