/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.stack;

import gov.nist.siplite.SipStack;
import gov.nist.siplite.address.Hop;
import gov.nist.siplite.address.Router;
import gov.nist.siplite.address.SipURI;
import gov.nist.siplite.address.URI;
import gov.nist.siplite.header.RouteHeader;
import gov.nist.siplite.header.RouteList;
import gov.nist.siplite.header.ViaHeader;
import gov.nist.siplite.message.Request;
import java.util.Enumeration;
import java.util.Vector;

public class DefaultRouter
implements Router {
    protected Hop defaultRoute;
    protected SipStack sipStack;

    public void setNextHop(String hopString) throws IllegalArgumentException {
        this.defaultRoute = new Hop(hopString);
        this.defaultRoute.setDefaultRouteFlag();
    }

    public Enumeration getNextHops(Request sipRequest, boolean isDialog) throws IllegalArgumentException {
        Vector<Hop> hopList = new Vector<Hop>();
        if (this.defaultRoute != null) {
            hopList.addElement(this.defaultRoute);
        } else {
            URI requestUri = null;
            String transport = null;
            RouteList rl = sipRequest.getRouteHeaders();
            if (rl == null || rl.isEmpty()) {
                isDialog = false;
            }
            if (!isDialog) {
                requestUri = sipRequest.getRequestURI();
                ViaHeader requestViaHeader = (ViaHeader)sipRequest.getViaHeaders().getFirst();
                transport = requestViaHeader.getTransport();
                Hop hop = this.createHop(requestUri, transport);
                hopList.addElement(hop);
            } else {
                Enumeration el = rl.getElements();
                while (el.hasMoreElements()) {
                    RouteHeader route = (RouteHeader)el.nextElement();
                    requestUri = route.getAddress().getURI();
                    transport = route.getAddress().getParameter("transport");
                    Hop hop = this.createHop(requestUri, transport);
                    hopList.addElement(hop);
                }
            }
        }
        return hopList.elements();
    }

    private Hop createHop(URI requestUri, String transport) {
        Hop hop = null;
        if (requestUri.isSipURI()) {
            SipURI sipUri = (SipURI)requestUri;
            int port = sipUri.getPort();
            if (port == -1) {
                port = 5060;
            }
            hop = new Hop(sipUri.getHost(), port, transport);
        }
        return hop;
    }

    public Hop getOutboundProxy() {
        return this.defaultRoute;
    }

    public void setOutboundProxy(String outboundProxy) {
        this.defaultRoute = new Hop(outboundProxy);
    }

    public void setSipStack(SipStack sipStack) {
        this.sipStack = sipStack;
    }
}

