/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.stack;

import gov.nist.core.NameValueList;
import gov.nist.core.Utils;
import gov.nist.siplite.address.Address;
import gov.nist.siplite.address.Hop;
import gov.nist.siplite.address.SipURI;
import gov.nist.siplite.header.CSeqHeader;
import gov.nist.siplite.header.CallIdHeader;
import gov.nist.siplite.header.ContactHeader;
import gov.nist.siplite.header.ContactList;
import gov.nist.siplite.header.FromHeader;
import gov.nist.siplite.header.RecordRouteHeader;
import gov.nist.siplite.header.RecordRouteList;
import gov.nist.siplite.header.RequestLine;
import gov.nist.siplite.header.RouteHeader;
import gov.nist.siplite.header.RouteList;
import gov.nist.siplite.header.ToHeader;
import gov.nist.siplite.header.ViaHeader;
import gov.nist.siplite.message.Message;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.stack.ClientTransaction;
import gov.nist.siplite.stack.MessageChannel;
import gov.nist.siplite.stack.MessageProcessor;
import gov.nist.siplite.stack.SIPTransactionStack;
import gov.nist.siplite.stack.ServerTransaction;
import gov.nist.siplite.stack.SubscriptionList;
import gov.nist.siplite.stack.Transaction;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.sip.SipException;

public class Dialog {
    private Object applicationData;
    private Transaction firstTransaction;
    private Transaction lastTransaction;
    private String dialogId;
    private int localSequenceNumber = 0;
    private int remoteSequenceNumber = -1;
    private String myTag;
    private String hisTag;
    private RouteList routeList;
    private RouteHeader contactRoute;
    private String user;
    private RouteHeader defaultRoute;
    private SIPTransactionStack sipStack;
    private int dialogState = -1;
    protected boolean ackSeen;
    protected Request lastAck;
    public SubscriptionList subscriptionList = new SubscriptionList();
    private int retransmissionTicksLeft;
    private int prevRetransmissionTicks;
    public static final int INITIAL_STATE = -1;
    public static final int EARLY_STATE = 1;
    public static final int CONFIRMED_STATE = 2;
    public static final int COMPLETED_STATE = 3;
    public static final int TERMINATED_STATE = 4;

    public void setApplicationData(Object applicationData) {
        this.applicationData = applicationData;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    private void printRouteList() {
    }

    public Hop getNextHop() throws SipException {
        String transport;
        RouteList rl = this.getRouteList();
        SipURI sipUri = null;
        if (rl != null && !rl.isEmpty()) {
            RouteHeader route = (RouteHeader)rl.getFirst();
            sipUri = (SipURI)route.getAddress().getURI();
            transport = route.getAddress().getParameter("transport");
        } else if (this.contactRoute != null) {
            sipUri = (SipURI)this.contactRoute.getAddress().getURI();
            transport = this.contactRoute.getAddress().getParameter("transport");
        } else {
            throw new SipException("No route found!", 0);
        }
        String host = sipUri.getHost();
        int port = sipUri.getPort();
        if (port == -1) {
            port = 5060;
        }
        if (transport == null) {
            transport = "UDP";
        }
        return new Hop(host, port, transport);
    }

    public boolean isClientDialog() {
        Transaction transaction = this.getFirstTransaction();
        return transaction instanceof ClientTransaction;
    }

    public void setState(int state) {
        this.dialogState = state;
    }

    public void printTags() {
    }

    public void ackReceived(Request sipRequest) {
        if (this.isServer()) {
            ServerTransaction st = (ServerTransaction)this.getFirstTransaction();
            if (st == null) {
                return;
            }
            if (st.getOriginalRequest().getCSeqHeader().getSequenceNumber() == sipRequest.getCSeqHeader().getSequenceNumber()) {
                st.setState(6);
                this.ackSeen = true;
                this.lastAck = sipRequest;
            }
        }
    }

    public boolean isAckSeen() {
        return this.ackSeen;
    }

    public Request getLastAck() {
        return this.lastAck;
    }

    public Transaction getFirstTransaction() {
        return this.firstTransaction;
    }

    public Enumeration getRouteSet() {
        if (this.routeList == null) {
            return null;
        }
        return this.getRouteList().getElements();
    }

    private RouteList getRouteList() {
        Vector li = this.routeList.getHeaders();
        RouteList retval = new RouteList();
        retval = new RouteList();
        for (int i = 0; i < li.size(); ++i) {
            RouteHeader route = (RouteHeader)li.elementAt(i);
            retval.add(route.clone());
        }
        return retval;
    }

    public void setStack(SIPTransactionStack sipStack) {
        this.sipStack = sipStack;
    }

    public void setDefaultRoute(RouteHeader defaultRoute) {
        this.defaultRoute = (RouteHeader)defaultRoute.clone();
    }

    public void setUser(String user) {
        this.user = user;
    }

    private void addRoute(RecordRouteList recordRouteList, String transport) {
        if (this.isClientDialog()) {
            this.routeList = new RouteList();
            Vector li = recordRouteList.getHeaders();
            for (int i = li.size() - 1; i >= 0; --i) {
                RecordRouteHeader rr = (RecordRouteHeader)li.elementAt(i);
                Address addr = rr.getAddress();
                RouteHeader route = new RouteHeader();
                route.setAddress((Address)rr.getAddress().clone());
                route.setParameters((NameValueList)rr.getParameters().clone());
                this.setRouteTransport(route, transport);
                this.routeList.add(route);
            }
        } else {
            this.routeList = new RouteList();
            Vector li = recordRouteList.getHeaders();
            for (int i = 0; i < li.size(); ++i) {
                RecordRouteHeader rr = (RecordRouteHeader)li.elementAt(i);
                RouteHeader route = new RouteHeader();
                route.setAddress((Address)rr.getAddress().clone());
                route.setParameters((NameValueList)rr.getParameters().clone());
                this.setRouteTransport(route, transport);
                this.routeList.add(route);
            }
        }
    }

    private void setRouteTransport(RouteHeader route, String transport) {
        if (route.getAddress().getParameter("transport") == null) {
            route.getAddress().setParameter("transport", transport);
        }
    }

    private void addRoute(ContactList contactList, String transport) {
        if (contactList.size() == 0) {
            return;
        }
        ContactHeader contact = (ContactHeader)contactList.getFirst();
        RouteHeader route = new RouteHeader();
        route.setAddress((Address)contact.getAddress().clone());
        this.setRouteTransport(route, transport);
        this.contactRoute = route;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addRoute(Message sipMessage) {
        String transport = ((ViaHeader)sipMessage.getViaHeaders().getFirst()).getTransport();
        if (sipMessage.getCSeqHeader().getMethod().equals("UPDATE") && (this.dialogState == 1 || this.dialogState == 2)) {
            ContactList contactList = sipMessage.getContactHeaders();
            if (contactList != null) {
                this.addRoute(contactList, transport);
            }
            return;
        }
        if (this.dialogState == 2 || this.dialogState == 3 || this.dialogState == 4) {
            return;
        }
        if (!this.isServer()) {
            if (sipMessage instanceof Response) {
                Response sipResponse = (Response)sipMessage;
                if (sipResponse.getStatusCode() == 100) {
                    return;
                }
                RecordRouteList rrlist = sipMessage.getRecordRouteHeaders();
                if (rrlist != null) {
                    this.addRoute(rrlist, transport);
                } else {
                    this.routeList = new RouteList();
                }
                ContactList contactList = sipMessage.getContactHeaders();
                if (contactList != null) {
                    this.addRoute(contactList, transport);
                }
            }
        } else if (sipMessage instanceof Request) {
            RecordRouteList rrlist = sipMessage.getRecordRouteHeaders();
            if (rrlist != null) {
                this.addRoute(rrlist, transport);
            } else {
                this.routeList = new RouteList();
            }
            ContactList contactList = sipMessage.getContactHeaders();
            if (contactList != null) {
                this.addRoute(contactList, transport);
            }
        }
    }

    private Dialog() {
        this.routeList = new RouteList();
    }

    public void setDialogId(String newDialogId) {
        this.dialogId = newDialogId;
    }

    protected Dialog(Transaction transaction) {
        this();
        this.addTransaction(transaction);
    }

    private void buildRouteSet(Request request) throws SipException {
        this.getLastTransaction().buildRouteSet(request);
    }

    public boolean isServer() {
        return this.getFirstTransaction() instanceof ServerTransaction;
    }

    public String getDialogId() {
        if (this.firstTransaction instanceof ServerTransaction) {
            Request sipRequest = ((ServerTransaction)this.firstTransaction).getOriginalRequest();
            this.dialogId = sipRequest.getDialogId(true, this.myTag);
        } else if (this.firstTransaction != null && ((ClientTransaction)this.getFirstTransaction()).getLastResponse() != null) {
            this.dialogId = ((ClientTransaction)this.getFirstTransaction()).getLastResponse().getDialogId(false, this.hisTag);
        }
        return this.dialogId;
    }

    public void addTransaction(Transaction transaction) {
        Request sipRequest = transaction.getOriginalRequest();
        if (sipRequest.getMethod().equals("BYE")) {
            this.setState(3);
        }
        if (this.firstTransaction == null) {
            this.firstTransaction = transaction;
            if (transaction instanceof ServerTransaction) {
                this.hisTag = sipRequest.getFromHeader().getTag();
            } else {
                this.setLocalSequenceNumber(sipRequest.getCSeqHeader().getSequenceNumber());
                this.myTag = sipRequest.getFromHeader().getTag();
                if (this.myTag == null) {
                    throw new RuntimeException("bad message tag missing!");
                }
            }
        } else if (transaction.getOriginalRequest().getMethod().equals(this.firstTransaction.getOriginalRequest().getMethod()) && (this.firstTransaction instanceof ServerTransaction && transaction instanceof ClientTransaction || this.firstTransaction instanceof ClientTransaction && transaction instanceof ServerTransaction)) {
            this.firstTransaction = transaction;
        }
        if (transaction instanceof ServerTransaction) {
            this.setRemoteSequenceNumber(sipRequest.getCSeqHeader().getSequenceNumber());
        }
        this.lastTransaction = transaction;
        transaction.setDialog(this);
    }

    public void setRemoteTag(String hisTag) {
        this.hisTag = hisTag;
    }

    public Transaction getLastTransaction() {
        return this.lastTransaction;
    }

    protected void setLocalSequenceNumber(int lCseq) {
        this.localSequenceNumber = lCseq;
    }

    protected void setRemoteSequenceNumber(int rCseq) {
        this.remoteSequenceNumber = rCseq;
    }

    public int incrementLocalSequenceNumber() {
        return ++this.localSequenceNumber;
    }

    public int getRemoteSequenceNumber() {
        return this.remoteSequenceNumber;
    }

    public int getLocalSequenceNumber() {
        return this.localSequenceNumber;
    }

    public String getLocalTag() {
        return this.myTag;
    }

    public String getRemoteTag() {
        return this.hisTag;
    }

    public void setLocalTag(String mytag) {
        this.myTag = mytag;
    }

    protected void deleteTransactions() {
        this.firstTransaction = null;
        this.lastTransaction = null;
    }

    public void delete() {
        this.setState(4);
    }

    public CallIdHeader getCallId() {
        Request sipRequest = this.getFirstTransaction().getOriginalRequest();
        return sipRequest.getCallId();
    }

    public Address getLocalParty() {
        Request sipRequest = this.getFirstTransaction().getOriginalRequest();
        if (!this.isServer()) {
            return sipRequest.getFromHeader().getAddress();
        }
        return sipRequest.getTo().getAddress();
    }

    public Address getRemoteParty() {
        Request sipRequest = this.getFirstTransaction().getOriginalRequest();
        if (!this.isServer()) {
            return sipRequest.getTo().getAddress();
        }
        return sipRequest.getFromHeader().getAddress();
    }

    public Address getRemoteTarget() {
        if (this.contactRoute == null) {
            return null;
        }
        return this.contactRoute.getAddress();
    }

    public int getState() {
        return this.dialogState;
    }

    public boolean isSecure() {
        return Utils.equalsIgnoreCase(this.getFirstTransaction().getRequest().getRequestURI().getScheme(), "SIPS");
    }

    public void sendAck(Request request) throws SipException {
        Request ackRequest = request;
        if (this.isServer()) {
            throw new SipException("Cannot sendAck from Server side of Dialog", 2);
        }
        if (!ackRequest.getMethod().equals("ACK")) {
            throw new SipException("Bad request method -- should be ACK", 8);
        }
        if (this.getState() == -1 || this.getState() == 1) {
            throw new SipException("Bad dialog state " + this.getState(), 5);
        }
        if (!this.getFirstTransaction().getOriginalRequest().getCallId().getCallId().equals(request.getCallId().getCallId())) {
            throw new SipException("Bad call ID in request", 8);
        }
        if (this.getLocalTag() != null) {
            ackRequest.getFromHeader().setTag(this.getLocalTag());
        }
        if (this.getRemoteTag() != null) {
            ackRequest.getTo().setTag(this.getRemoteTag());
        }
        this.buildRouteSet(ackRequest);
        Hop hop = this.getNextHop();
        try {
            MessageChannel messageChannel = this.sipStack.createRawMessageChannel(hop);
            if (messageChannel == null) {
                Hop outboundProxy = this.sipStack.getRouter().getOutboundProxy();
                if (outboundProxy == null) {
                    throw new SipException("No route found!", 0);
                }
                messageChannel = this.sipStack.createRawMessageChannel(outboundProxy);
            }
            ClientTransaction clientTransaction = (ClientTransaction)this.sipStack.createMessageChannel(messageChannel);
            clientTransaction.setOriginalRequest(ackRequest);
            clientTransaction.sendMessage(ackRequest);
            this.lastAck = ackRequest;
            clientTransaction.setState(6);
        }
        catch (IOException ex) {
            throw new SipException("Cold not create message channel", 0);
        }
    }

    public Request createRequest(String method) throws SipException {
        if (method == null) {
            throw new NullPointerException("null method");
        }
        if (this.getState() == -1 || !method.equals("BYE") && this.getState() == 4 || method.equals("BYE") && this.getState() == 1) {
            throw new SipException("Dialog not yet established or terminated", 2);
        }
        Request originalRequest = this.getFirstTransaction().getRequest();
        RequestLine requestLine = new RequestLine();
        requestLine.setUri(this.getRemoteParty().getURI());
        requestLine.setMethod(method);
        Request sipRequest = originalRequest.createRequest(requestLine, this.isServer());
        if (!method.equals("ACK")) {
            CSeqHeader cseq = sipRequest.getCSeqHeader();
            cseq.setSequenceNumber(this.localSequenceNumber + 1);
        }
        if (this.isServer()) {
            sipRequest.removeHeader("Via");
            MessageProcessor messageProcessor = this.firstTransaction.encapsulatedChannel.getMessageProcessor();
            ViaHeader via = messageProcessor.getViaHeader();
            sipRequest.addHeader(via);
        }
        FromHeader from = sipRequest.getFromHeader();
        ToHeader to = sipRequest.getTo();
        from.setTag(this.getLocalTag());
        to.setTag(this.getRemoteTag());
        ContactList cl = originalRequest.getContactHeaders();
        if (cl != null) {
            sipRequest.addHeader((ContactList)cl.clone());
        }
        this.buildRouteSet(sipRequest);
        return sipRequest;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendRequest(ClientTransaction clientTransactionId) throws SipException {
        Request dialogRequest = clientTransactionId.getOriginalRequest();
        if (clientTransactionId == null) {
            throw new NullPointerException("null parameter");
        }
        String method = dialogRequest.getMethod();
        if (method.equals("ACK") || method.equals("CANCEL")) {
            throw new SipException("Bad Request Method: " + dialogRequest.getMethod(), 8);
        }
        if (this.getState() == -1) {
            throw new SipException("Bad dialog state (-1).", 2);
        }
        if (Utils.equalsIgnoreCase(dialogRequest.getMethod(), "BYE") && this.getState() == 1) {
            throw new SipException("Bad dialog state ", 2);
        }
        if (dialogRequest.getTopmostVia() == null) {
            ViaHeader via = clientTransactionId.getOutgoingViaHeader();
            dialogRequest.addHeader(via);
        }
        if (!this.getFirstTransaction().getOriginalRequest().getCallId().getCallId().equals(dialogRequest.getCallId().getCallId())) {
            throw new SipException("Bad call ID in request", 8);
        }
        clientTransactionId.setDialog(this);
        FromHeader from = dialogRequest.getFromHeader();
        ToHeader to = dialogRequest.getTo();
        from.setTag(this.getLocalTag());
        to.setTag(this.getRemoteTag());
        this.buildRouteSet(dialogRequest);
        Hop hop = this.getNextHop();
        try {
            MessageChannel messageChannel;
            clientTransactionId.encapsulatedChannel = messageChannel = this.sipStack.createRawMessageChannel(hop);
            if (messageChannel == null) {
                Hop outboundProxy = this.sipStack.getRouter().getOutboundProxy();
                if (outboundProxy == null) {
                    throw new SipException("No route found!", 0);
                }
                messageChannel = this.sipStack.createRawMessageChannel(outboundProxy);
            }
            clientTransactionId.encapsulatedChannel = messageChannel;
        }
        catch (IOException ex) {
            throw new SipException("Could not create message channel.", 0);
        }
        ++this.localSequenceNumber;
        dialogRequest.getCSeqHeader().setSequenceNumber(this.getLocalSequenceNumber());
        if (this.isServer()) {
            ServerTransaction serverTransaction = (ServerTransaction)this.getFirstTransaction();
            from.setTag(this.myTag);
            to.setTag(this.hisTag);
            try {
                clientTransactionId.sendMessage(dialogRequest);
                if (!dialogRequest.getMethod().equals("BYE")) return;
                this.setState(3);
                return;
            }
            catch (IOException ex) {
                throw new SipException("Error sending message.", 0);
            }
        }
        ClientTransaction clientTransaction = (ClientTransaction)this.getFirstTransaction();
        from.setTag(this.myTag);
        to.setTag(this.hisTag);
        try {
            clientTransactionId.sendMessage(dialogRequest);
            if (!dialogRequest.getMethod().equals("BYE")) return;
            this.setState(3);
            return;
        }
        catch (IOException ex) {
            throw new SipException("Error sending message.", 0);
        }
    }

    protected boolean toRetransmitFinalResponse() {
        if (--this.retransmissionTicksLeft == 0) {
            this.prevRetransmissionTicks = this.retransmissionTicksLeft = 2 * this.prevRetransmissionTicks;
            return true;
        }
        return false;
    }

    protected void setRetransmissionTicks() {
        this.retransmissionTicksLeft = 1;
        this.prevRetransmissionTicks = 1;
    }

    public void resendAck() {
        try {
            if (this.lastAck != null) {
                this.sendAck(this.lastAck);
            }
        }
        catch (SipException sipException) {
            // empty catch block
        }
    }

    public boolean isInviteDialog() {
        return this.getFirstTransaction().getRequest().getMethod().equals("INVITE");
    }

    public boolean isSubscribeDialog() {
        String method = this.getFirstTransaction().getRequest().getMethod();
        return method.equals("SUBSCRIBE") || method.equals("REFER");
    }
}

