/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.stack;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.siplite.header.CSeqHeader;
import gov.nist.siplite.header.CallIdHeader;
import gov.nist.siplite.header.ContactHeader;
import gov.nist.siplite.header.Header;
import gov.nist.siplite.header.ViaHeader;
import gov.nist.siplite.message.Message;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.stack.MessageProcessor;
import gov.nist.siplite.stack.SIPMessageStack;
import gov.nist.siplite.stack.SIPServerException;
import gov.nist.siplite.stack.ServerLog;
import java.io.IOException;
import java.util.Enumeration;

public abstract class MessageChannel {
    protected MessageProcessor messageProcessor;

    public abstract void close();

    public abstract SIPMessageStack getSIPStack();

    public abstract String getTransport();

    public abstract boolean isReliable();

    public abstract boolean isSecure();

    public abstract void sendMessage(Message var1) throws IOException;

    public abstract String getPeerAddress();

    public abstract int getPeerPort();

    public abstract String getKey();

    public abstract String getViaHost();

    public abstract int getViaPort();

    protected abstract void sendMessage(byte[] var1, String var2, int var3) throws IOException;

    public String getHost() {
        return this.getSIPStack().getHostAddress();
    }

    public int getPort() {
        if (this.messageProcessor != null) {
            return this.messageProcessor.getPort();
        }
        return -1;
    }

    public abstract void handleException(SIPServerException var1);

    public void sendMessage(Message sipMessage, String receiverAddress, int receiverPort) throws IOException {
        long time = System.currentTimeMillis();
        byte[] bytes = sipMessage.encodeAsBytes();
        this.sendMessage(bytes, receiverAddress, receiverPort);
        this.logMessage(sipMessage, receiverAddress, receiverPort, time);
    }

    public static String getKey(String inetAddr, int port, String transport) {
        return transport + ":" + inetAddr + ":" + port;
    }

    public HostPort getHostPort() {
        HostPort retval = new HostPort();
        retval.setHost(new Host(this.getHost()));
        retval.setPort(this.getPort());
        return retval;
    }

    public HostPort getPeerHostPort() {
        HostPort retval = new HostPort();
        retval.setHost(new Host(this.getPeerAddress()));
        retval.setPort(this.getPeerPort());
        return retval;
    }

    public ViaHeader getViaHeader() {
        ViaHeader channelViaHeader = new ViaHeader();
        channelViaHeader.setTransport(this.getTransport());
        channelViaHeader.setSentBy(this.getHostPort());
        return channelViaHeader;
    }

    public HostPort getViaHostPort() {
        HostPort retval = new HostPort();
        retval.setHost(new Host(this.getViaHost()));
        retval.setPort(this.getViaPort());
        return retval;
    }

    protected void logMessage(Message sipMessage, String address, int port, long time) {
        String firstLine = sipMessage.getFirstLine();
        CSeqHeader cseq = sipMessage.getCSeqHeader();
        CallIdHeader callid = sipMessage.getCallId();
        String cseqBody = cseq.encodeBody();
        String callidBody = callid.encodeBody();
        if (port == -1) {
            port = 5060;
        }
        if (ServerLog.needsLogging(ServerLog.TRACE_MESSAGES)) {
            Enumeration extList = sipMessage.getHeaders("NISTExtension");
            String status = null;
            if (extList != null && extList.hasMoreElements()) {
                Header exthdr = null;
                exthdr = (Header)extList.nextElement();
                status = exthdr.getHeaderValue();
            }
            ServerLog.logMessage(sipMessage.encode(), this.getHost() + ":" + this.getPort(), address + ":" + port, true, callidBody, firstLine, status, sipMessage.getTransactionId(), time);
        }
    }

    public void logResponse(Response sipResponse, long receptionTime, String status) {
        try {
            int peerport = this.getPeerPort();
            if (peerport == 0 && sipResponse.getContactHeaders() != null) {
                ContactHeader contact = (ContactHeader)sipResponse.getContactHeaders().getFirst();
                peerport = contact.getAddress().getPort();
            }
            String from = this.getPeerAddress() + ":" + peerport;
            String to = this.getHost() + ":" + this.getPort();
            ServerLog.logMessage((Message)sipResponse, from, to, status, false, receptionTime);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public MessageProcessor getMessageProcessor() {
        return this.messageProcessor;
    }
}

