/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.stack;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.siplite.ListeningPoint;
import gov.nist.siplite.header.ViaHeader;
import gov.nist.siplite.stack.MessageChannel;
import gov.nist.siplite.stack.SIPMessageStack;
import java.io.IOException;

public abstract class MessageProcessor {
    private ListeningPoint listeningPoint;
    boolean exitFlag;
    private int useCount;

    public abstract String getTransport();

    public abstract int getPort();

    public abstract SIPMessageStack getSIPStack();

    public abstract MessageChannel createMessageChannel(HostPort var1) throws IOException;

    public abstract void start() throws IOException;

    public abstract void stop();

    public abstract boolean isSecure();

    public synchronized boolean inUse() {
        return this.useCount != 0;
    }

    public ViaHeader getViaHeader() {
        ViaHeader via = new ViaHeader();
        Host host = new Host();
        host.setHostname(this.getSIPStack().getHostAddress());
        via.setHost(host);
        via.setPort(this.getPort());
        via.setTransport(this.getTransport());
        return via;
    }

    public boolean toExit() {
        return this.exitFlag;
    }

    public void setListeningPoint(ListeningPoint lp) {
        this.listeningPoint = lp;
    }

    public ListeningPoint getListeningPoint() {
        return this.listeningPoint;
    }

    synchronized void incrementUseCount() {
        ++this.useCount;
    }

    synchronized void clearUseCount() {
        this.useCount = 0;
    }

    synchronized void decrementUseCount() {
        if (0 != this.useCount) {
            --this.useCount;
        }
    }
}

