/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.stack;

import com.sun.midp.security.SecurityToken;
import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.ParseException;
import gov.nist.core.Utils;
import gov.nist.siplite.address.Address;
import gov.nist.siplite.address.Hop;
import gov.nist.siplite.address.Router;
import gov.nist.siplite.address.SipURI;
import gov.nist.siplite.header.RouteHeader;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.stack.MessageChannel;
import gov.nist.siplite.stack.MessageProcessor;
import gov.nist.siplite.stack.SIPServerRequestInterface;
import gov.nist.siplite.stack.SIPServerResponseInterface;
import gov.nist.siplite.stack.SIPStackMessageFactory;
import gov.nist.siplite.stack.ServerLog;
import gov.nist.siplite.stack.TCPMessageProcessor;
import gov.nist.siplite.stack.UDPMessageProcessor;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class SIPMessageStack {
    protected SecurityToken securityToken;
    protected boolean tcpFlag;
    protected boolean udpFlag;
    protected String outboundProxy;
    protected int outboundPort = -1;
    protected boolean toExit = false;
    protected String badMessageLog;
    protected boolean debugFlag;
    protected String stackName;
    protected String stackAddress;
    protected SIPStackMessageFactory sipMessageFactory;
    protected Router router;
    protected int threadPoolSize = -1;
    protected int maxConnections = -1;
    private Vector messageProcessors = new Vector();

    public void logBadMessage(String message) {
        if (this.badMessageLog != null) {
            // empty if block
        }
    }

    public String getBadMessageLog() {
        return this.badMessageLog;
    }

    public void setSingleThreaded() {
        this.threadPoolSize = 1;
    }

    public void setThreadPoolSize(int size) {
        this.threadPoolSize = size;
    }

    public void setMaxConnections(int nconnections) {
        this.maxConnections = nconnections;
    }

    public SIPMessageStack(SIPStackMessageFactory messageFactory, String stackAddress, String stackName) throws IllegalArgumentException {
        this();
        this.sipMessageFactory = messageFactory;
        if (stackAddress == null) {
            throw new IllegalArgumentException("stack Address not set");
        }
        ServerLog.description = stackName;
        ServerLog.stackIpAddress = stackAddress;
    }

    public void setStackMessageFactory(SIPStackMessageFactory messageFactory) {
        this.sipMessageFactory = messageFactory;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
        ServerLog.setDescription(stackName);
        ServerLog.stackIpAddress = this.stackAddress;
    }

    public String getStackName() {
        return this.stackName;
    }

    public void setHostAddress(String stackAddress) {
        this.stackAddress = stackAddress.indexOf(58) != stackAddress.lastIndexOf(58) && stackAddress.trim().charAt(0) != '[' ? '[' + stackAddress + ']' : stackAddress;
    }

    public String getHostAddress() {
        return this.stackAddress;
    }

    public Hop getNextHop() {
        return this.router.getOutboundProxy();
    }

    public int getPort(String transport) throws IllegalArgumentException {
        Vector vector = this.messageProcessors;
        synchronized (vector) {
            Enumeration it = this.messageProcessors.elements();
            while (it.hasMoreElements()) {
                MessageProcessor mp = (MessageProcessor)it.nextElement();
                if (!Utils.equalsIgnoreCase(mp.getTransport(), transport)) continue;
                return mp.getPort();
            }
            throw new IllegalArgumentException("Transport not supported " + transport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTransportEnabled(String transport) {
        Vector vector = this.messageProcessors;
        synchronized (vector) {
            Enumeration it = this.messageProcessors.elements();
            while (it.hasMoreElements()) {
                MessageProcessor mp = (MessageProcessor)it.nextElement();
                if (!Utils.equalsIgnoreCase(mp.getTransport(), transport)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTransportEnabled(String transport, int port) {
        Vector vector = this.messageProcessors;
        synchronized (vector) {
            Enumeration it = this.messageProcessors.elements();
            while (it.hasMoreElements()) {
                MessageProcessor mp = (MessageProcessor)it.nextElement();
                if (!Utils.equalsIgnoreCase(mp.getTransport(), transport) || mp.getPort() != port) continue;
                return true;
            }
            return false;
        }
    }

    public SIPMessageStack() {
    }

    protected SIPServerRequestInterface newSIPServerRequest(Request siprequest, MessageChannel msgchan) {
        return this.sipMessageFactory.newSIPServerRequest(siprequest, msgchan);
    }

    SIPServerResponseInterface newSIPServerResponse(Response sipresponse, MessageChannel msgchan) {
        return this.sipMessageFactory.newSIPServerResponse(sipresponse, msgchan);
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public Router getRouter() {
        return this.router;
    }

    public Hop getDefaultRoute() {
        return this.router.getOutboundProxy();
    }

    public RouteHeader getRouteHeader(Hop hop) {
        HostPort hostPort = new HostPort();
        Host h = new Host(hop.getHost());
        hostPort.setHost(h);
        hostPort.setPort(hop.getPort());
        SipURI uri = new SipURI();
        uri.setHostPort(hostPort);
        uri.setScheme("SIP");
        try {
            uri.setTransportParam(hop.getTransport());
        }
        catch (ParseException ex) {
            InternalErrorHandler.handleException(ex);
        }
        Address address = new Address();
        address.setURI(uri);
        RouteHeader route = new RouteHeader();
        route.setAddress(address);
        return route;
    }

    public RouteHeader getDefaultRouteHeader() {
        if (this.router.getOutboundProxy() != null) {
            Hop hop = this.router.getOutboundProxy();
            return this.getRouteHeader(hop);
        }
        return null;
    }

    public synchronized boolean isAlive() {
        return !this.toExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopStack() {
        Vector vector = this.messageProcessors;
        synchronized (vector) {
            this.toExit = true;
            Vector processorList = this.getMessageProcessors();
            for (int i = 0; i < processorList.size(); ++i) {
                MessageProcessor mp = (MessageProcessor)processorList.elementAt(i);
                if (mp.toExit()) continue;
                mp.stop();
            }
            processorList.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageProcessor(MessageProcessor newMessageProcessor) throws IOException {
        Vector vector = this.messageProcessors;
        synchronized (vector) {
            this.messageProcessors.addElement(newMessageProcessor);
            newMessageProcessor.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageProcessor(MessageProcessor oldMessageProcessor) {
        Vector vector = this.messageProcessors;
        synchronized (vector) {
            if (this.messageProcessors.removeElement(oldMessageProcessor)) {
                oldMessageProcessor.stop();
            }
        }
    }

    public Vector getMessageProcessors() {
        return this.messageProcessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProcessor getMessageProcessor(String transport) {
        Vector vector = this.messageProcessors;
        synchronized (vector) {
            Enumeration it = this.messageProcessors.elements();
            while (it.hasMoreElements()) {
                MessageProcessor mp = (MessageProcessor)it.nextElement();
                if (!Utils.equalsIgnoreCase(mp.getTransport(), transport)) continue;
                return mp;
            }
            return null;
        }
    }

    public MessageProcessor createMessageProcessor(int port, String transport) throws IOException, IllegalArgumentException {
        if (Utils.equalsIgnoreCase(transport, "UDP")) {
            UDPMessageProcessor udpMessageProcessor = new UDPMessageProcessor(this, port);
            this.addMessageProcessor(udpMessageProcessor);
            this.udpFlag = true;
            return udpMessageProcessor;
        }
        if (Utils.equalsIgnoreCase(transport, "TCP")) {
            TCPMessageProcessor tcpMessageProcessor = new TCPMessageProcessor(this, port);
            this.addMessageProcessor(tcpMessageProcessor);
            this.tcpFlag = true;
            return tcpMessageProcessor;
        }
        throw new IllegalArgumentException("bad transport");
    }

    protected void setMessageFactory(SIPStackMessageFactory messageFactory) {
        this.sipMessageFactory = messageFactory;
    }

    public MessageChannel createMessageChannel(Hop nextHop) {
        Host targetHost = new Host();
        targetHost.setHostname(nextHop.getHost());
        HostPort targetHostPort = new HostPort();
        targetHostPort.setHost(targetHost);
        targetHostPort.setPort(nextHop.getPort());
        MessageChannel newChannel = null;
        Enumeration processorIterator = this.messageProcessors.elements();
        while (processorIterator.hasMoreElements() && newChannel == null) {
            MessageProcessor nextProcessor = (MessageProcessor)processorIterator.nextElement();
            if (!Utils.equalsIgnoreCase(nextHop.getTransport(), nextProcessor.getTransport())) continue;
            try {
                newChannel = nextProcessor.createMessageChannel(targetHostPort);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return newChannel;
    }

    protected SecurityToken getSecurityToken() {
        return this.securityToken;
    }

    protected void setSecurityToken(SecurityToken token) {
        this.securityToken = token;
    }
}

