/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.stack;

import gov.nist.core.Utils;
import gov.nist.microedition.sip.SipClientConnectionImpl;
import gov.nist.siplite.address.Hop;
import gov.nist.siplite.header.CallIdHeader;
import gov.nist.siplite.header.EventHeader;
import gov.nist.siplite.header.SubscriptionStateHeader;
import gov.nist.siplite.message.Message;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.stack.ClientTransaction;
import gov.nist.siplite.stack.Dialog;
import gov.nist.siplite.stack.MessageChannel;
import gov.nist.siplite.stack.SIPMessageStack;
import gov.nist.siplite.stack.SIPServerRequestInterface;
import gov.nist.siplite.stack.SIPServerResponseInterface;
import gov.nist.siplite.stack.SIPStackMessageFactory;
import gov.nist.siplite.stack.SIPTransactionEventListener;
import gov.nist.siplite.stack.ServerTransaction;
import gov.nist.siplite.stack.Subscription;
import gov.nist.siplite.stack.Transaction;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class SIPTransactionStack
extends SIPMessageStack
implements SIPTransactionEventListener {
    public static final int BASE_TIMER_INTERVAL = 500;
    private Vector clientTransactions;
    private Vector serverTransactions;
    private Hashtable dialogTable;
    protected int transactionTableSize = -1;
    protected boolean retransmissionFilter;
    protected Hashtable dialogCreatingMethods = new Hashtable();

    protected SIPTransactionStack() {
        this.dialogCreatingMethods.put("REFER", "");
        this.dialogCreatingMethods.put("INVITE", "");
        this.dialogCreatingMethods.put("SUBSCRIBE", "");
        this.clientTransactions = new Vector();
        this.serverTransactions = new Vector();
        this.dialogTable = new Hashtable();
        new Thread(new TransactionScanner()).start();
    }

    private void printDialogCreatingMethods() {
        System.out.println("PRINTING DIALOGCREATINGMETHODS HASHTABLE");
        Enumeration e = this.dialogCreatingMethods.keys();
        while (e.hasMoreElements()) {
            System.out.println(e.nextElement());
        }
        System.out.println("DIALOGCREATINGMETHODS HASHTABLE PRINTED");
    }

    public boolean isDialogCreated(String method) {
        return this.dialogCreatingMethods.containsKey(method.toUpperCase());
    }

    public boolean allowDialogStateChange(String method) {
        return this.dialogCreatingMethods.containsKey(method.toUpperCase()) || method.equalsIgnoreCase("BYE") || method.equalsIgnoreCase("NOTIFY");
    }

    public void addExtensionMethod(String extensionMethod) {
        if (extensionMethod.equals("NOTIFY")) {
            this.dialogCreatingMethods.put(extensionMethod, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDialog(Dialog dialog) {
        String dialogId = dialog.getDialogId();
        dialog.setStack(this);
        Hashtable hashtable = this.dialogTable;
        synchronized (hashtable) {
            this.dialogTable.put(dialogId, dialog);
        }
    }

    public synchronized Dialog createDialog(Transaction transaction) {
        Request sipRequest = transaction.getOriginalRequest();
        Dialog retval = new Dialog(transaction);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dialog getDialog(String dialogId) {
        Hashtable hashtable = this.dialogTable;
        synchronized (hashtable) {
            return (Dialog)this.dialogTable.get(dialogId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientTransaction findSubscribeTransaction(Request notifyMessage) {
        Vector vector = this.clientTransactions;
        synchronized (vector) {
            Enumeration it = this.clientTransactions.elements();
            String thisToHeaderTag = notifyMessage.getTo().getTag();
            if (thisToHeaderTag == null) {
                return null;
            }
            EventHeader eventHdr = (EventHeader)notifyMessage.getHeader("Event");
            if (eventHdr == null) {
                return null;
            }
            while (it.hasMoreElements()) {
                ClientTransaction ct = (ClientTransaction)it.nextElement();
                Request sipRequest = ct.getOriginalRequest();
                String fromTag = sipRequest.getFromHeader().getTag();
                EventHeader hisEvent = (EventHeader)sipRequest.getHeader("Event");
                if (hisEvent == null || !sipRequest.getMethod().equals("SUBSCRIBE") || !Utils.equalsIgnoreCase(fromTag, thisToHeaderTag) || hisEvent == null || !eventHdr.match(hisEvent) || !Utils.equalsIgnoreCase(notifyMessage.getCallId().getCallId(), sipRequest.getCallId().getCallId())) continue;
                return ct;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction findTransaction(Message sipMessage, boolean isServer) {
        if (isServer) {
            Vector vector = this.serverTransactions;
            synchronized (vector) {
                Enumeration it = this.serverTransactions.elements();
                while (it.hasMoreElements()) {
                    ServerTransaction sipServerTransaction = (ServerTransaction)it.nextElement();
                    if (!sipServerTransaction.isMessagePartOfTransaction(sipMessage)) continue;
                    return sipServerTransaction;
                }
            }
        }
        Vector vector = this.clientTransactions;
        synchronized (vector) {
            Enumeration it = this.clientTransactions.elements();
            while (it.hasMoreElements()) {
                ClientTransaction clientTransaction = (ClientTransaction)it.nextElement();
                if (!clientTransaction.isMessagePartOfTransaction(sipMessage)) continue;
                return clientTransaction;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction findCancelTransaction(Request cancelRequest, boolean isServer) {
        if (isServer) {
            Vector vector = this.serverTransactions;
            synchronized (vector) {
                Enumeration li = this.serverTransactions.elements();
                while (li.hasMoreElements()) {
                    Transaction transaction = (Transaction)li.nextElement();
                    Request sipRequest = transaction.getRequest();
                    ServerTransaction sipServerTransaction = (ServerTransaction)transaction;
                    if (!sipServerTransaction.doesCancelMatchTransaction(cancelRequest)) continue;
                    return sipServerTransaction;
                }
            }
        }
        Vector vector = this.clientTransactions;
        synchronized (vector) {
            Enumeration li = this.clientTransactions.elements();
            while (li.hasMoreElements()) {
                Transaction transaction = (Transaction)li.nextElement();
                Request sipRequest = transaction.getRequest();
                ClientTransaction sipClientTransaction = (ClientTransaction)transaction;
                if (!sipClientTransaction.doesCancelMatchTransaction(cancelRequest)) continue;
                return sipClientTransaction;
            }
        }
        return null;
    }

    protected SIPTransactionStack(SIPStackMessageFactory messageFactory) {
        this();
        this.sipMessageFactory = messageFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrTerminateDialog(Request requestReceived) {
        Hashtable hashtable = this.dialogTable;
        synchronized (hashtable) {
            Enumeration e = this.dialogTable.elements();
            while (e.hasMoreElements()) {
                Dialog nextDialog = (Dialog)e.nextElement();
                Subscription s = nextDialog.subscriptionList.getMatchingSubscription(requestReceived);
                if (s == null) continue;
                SubscriptionStateHeader ssh = (SubscriptionStateHeader)requestReceived.getHeader("Subscription-State");
                if (ssh != null && ssh.isTerminated()) {
                    nextDialog.subscriptionList.removeSubscription(s);
                } else {
                    nextDialog.setState(2);
                }
                return;
            }
        }
        ClientTransaction currClientTransaction = null;
        Vector vector = this.clientTransactions;
        synchronized (vector) {
            Enumeration transactionIterator = this.clientTransactions.elements();
            currClientTransaction = null;
            String receivedToTag = requestReceived.getToTag();
            CallIdHeader receivedCid = requestReceived.getCallId();
            EventHeader receivedEvent = (EventHeader)requestReceived.getHeader("Event");
            while (transactionIterator.hasMoreElements()) {
                boolean isSameEvent;
                currClientTransaction = (ClientTransaction)transactionIterator.nextElement();
                Request request = currClientTransaction.getRequest();
                String method = request.getMethod();
                String fromTag = request.getFromHeaderTag();
                CallIdHeader cid = request.getCallId();
                EventHeader hEvent = (EventHeader)request.getHeader("Event");
                boolean bl = isSameEvent = hEvent != null && hEvent.match(receivedEvent);
                if ((!method.equals("SUBSCRIBE") || !isSameEvent) && !method.equals("REFER") || fromTag == null || !fromTag.equals(receivedToTag) || cid == null || !cid.equals(receivedCid)) continue;
                SipClientConnectionImpl sipClientConnection = (SipClientConnectionImpl)currClientTransaction.getApplicationData();
                if (sipClientConnection == null) break;
                sipClientConnection.handleMatchingNotify(requestReceived);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SIPServerRequestInterface newSIPServerRequest(Request requestReceived, MessageChannel requestMessageChannel) {
        try {
            ServerTransaction currentTransaction = null;
            if (requestReceived.getMethod().equals("NOTIFY")) {
                this.createOrTerminateDialog(requestReceived);
            }
            Vector vector = this.serverTransactions;
            synchronized (vector) {
                Enumeration transactionIterator = this.serverTransactions.elements();
                currentTransaction = null;
                while (transactionIterator.hasMoreElements() && currentTransaction == null) {
                    ServerTransaction nextTransaction = (ServerTransaction)transactionIterator.nextElement();
                    if (!nextTransaction.isMessagePartOfTransaction(requestReceived)) continue;
                    currentTransaction = nextTransaction;
                }
                if (currentTransaction == null) {
                    currentTransaction = this.createServerTransaction(requestMessageChannel);
                    currentTransaction.setOriginalRequest(requestReceived);
                    if (!this.isDialogCreated(requestReceived.getMethod())) {
                        this.serverTransactions.addElement(currentTransaction);
                        currentTransaction.isMapped = true;
                    } else {
                        String dialogId = requestReceived.getDialogId(true);
                        Dialog dialog = this.getDialog(dialogId);
                        if (dialog != null && requestReceived.getCSeqHeader().getSequenceNumber() > dialog.getRemoteSequenceNumber()) {
                            try {
                                currentTransaction.map();
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                        }
                        this.serverTransactions.addElement(currentTransaction);
                        currentTransaction.toListener = true;
                    }
                }
                requestReceived.setTransaction(currentTransaction);
                currentTransaction.setRequestInterface(super.newSIPServerRequest(requestReceived, currentTransaction));
                return currentTransaction;
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SIPServerResponseInterface newSIPServerResponse(Response responseReceived, MessageChannel responseMessageChannel) {
        ClientTransaction currentTransaction;
        Vector vector = this.clientTransactions;
        synchronized (vector) {
            Enumeration transactionIterator = this.clientTransactions.elements();
            currentTransaction = null;
            int i = -1;
            while (transactionIterator.hasMoreElements() && currentTransaction == null) {
                ++i;
                ClientTransaction nextTransaction = (ClientTransaction)transactionIterator.nextElement();
                if (!nextTransaction.isMessageTransOrMult(responseReceived)) continue;
                if (nextTransaction.isMultipleResponse(responseReceived)) {
                    currentTransaction = nextTransaction.cloneWithNewLastResponse(responseReceived);
                    currentTransaction.setState(3);
                    currentTransaction.setApplicationData(nextTransaction.getApplicationData());
                    Dialog dialog = new Dialog(currentTransaction);
                    dialog.setDialogId(responseReceived.getDialogId(false));
                    dialog.setRemoteTag(responseReceived.getToTag());
                    dialog.setStack(this);
                    this.putDialog(dialog);
                    currentTransaction.setDialog(dialog);
                    this.clientTransactions.setElementAt(currentTransaction, i);
                    continue;
                }
                currentTransaction = nextTransaction;
            }
        }
        if (currentTransaction == null) {
            return super.newSIPServerResponse(responseReceived, responseMessageChannel);
        }
        currentTransaction.setResponseInterface(super.newSIPServerResponse(responseReceived, currentTransaction));
        return currentTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel createMessageChannel(Hop nextHop) {
        Vector vector = this.clientTransactions;
        synchronized (vector) {
            MessageChannel mc = super.createMessageChannel(nextHop);
            if (mc == null) {
                return null;
            }
            ClientTransaction returnChannel = this.createClientTransaction(mc);
            this.clientTransactions.addElement(returnChannel);
            returnChannel.setViaPort(nextHop.getPort());
            returnChannel.setViaHost(nextHop.getHost());
            return returnChannel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel createMessageChannel(MessageChannel rawChannel) {
        Vector vector = this.clientTransactions;
        synchronized (vector) {
            ClientTransaction returnChannel = this.createClientTransaction(rawChannel);
            this.clientTransactions.addElement(returnChannel);
            returnChannel.setViaPort(rawChannel.getViaPort());
            returnChannel.setViaHost(rawChannel.getHost());
            return returnChannel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel createMessageChannel(Transaction transaction) {
        Vector vector = this.clientTransactions;
        synchronized (vector) {
            ClientTransaction returnChannel = this.createClientTransaction(transaction.getMessageChannel());
            this.clientTransactions.addElement(returnChannel);
            returnChannel.setViaPort(transaction.getViaPort());
            returnChannel.setViaHost(transaction.getViaHost());
            return returnChannel;
        }
    }

    public ClientTransaction createClientTransaction(MessageChannel encapsulatedMessageChannel) {
        return new ClientTransaction(this, encapsulatedMessageChannel);
    }

    public ServerTransaction createServerTransaction(MessageChannel encapsulatedMessageChannel) {
        return new ServerTransaction(this, encapsulatedMessageChannel);
    }

    public MessageChannel createRawMessageChannel(Hop hop) {
        return super.createMessageChannel(hop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransaction(ClientTransaction clientTransaction) {
        Vector vector = this.clientTransactions;
        synchronized (vector) {
            this.clientTransactions.addElement(clientTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransaction(ServerTransaction serverTransaction) throws IOException {
        Vector vector = this.serverTransactions;
        synchronized (vector) {
            this.serverTransactions.addElement(serverTransaction);
        }
    }

    class TransactionScanner
    implements Runnable {
        TransactionScanner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (SIPTransactionStack.this.isAlive()) {
                try {
                    int j;
                    Transaction nextTransaction;
                    Enumeration transactionIterator;
                    Thread.sleep(500L);
                    Vector<Transaction> fireList = new Vector<Transaction>();
                    Vector<Object> removeList = new Vector<Object>();
                    Cloneable cloneable = SIPTransactionStack.this.serverTransactions;
                    synchronized (cloneable) {
                        transactionIterator = SIPTransactionStack.this.serverTransactions.elements();
                        while (transactionIterator.hasMoreElements()) {
                            nextTransaction = (Transaction)transactionIterator.nextElement();
                            if (nextTransaction.isTerminated()) {
                                if (((ServerTransaction)nextTransaction).collectionTime == 0) {
                                    removeList.addElement(nextTransaction);
                                    continue;
                                }
                                --((ServerTransaction)nextTransaction).collectionTime;
                                continue;
                            }
                            fireList.addElement(nextTransaction);
                        }
                        for (j = 0; j < removeList.size(); ++j) {
                            SIPTransactionStack.this.serverTransactions.removeElement(removeList.elementAt(j));
                        }
                    }
                    removeList = new Vector();
                    cloneable = SIPTransactionStack.this.clientTransactions;
                    synchronized (cloneable) {
                        transactionIterator = SIPTransactionStack.this.clientTransactions.elements();
                        while (transactionIterator.hasMoreElements()) {
                            nextTransaction = (Transaction)transactionIterator.nextElement();
                            boolean removeTransaction = false;
                            if (nextTransaction.isTerminated()) {
                                SipClientConnectionImpl conn = (SipClientConnectionImpl)nextTransaction.getApplicationData();
                                if (conn == null) {
                                    removeTransaction = true;
                                } else if (conn.getState() == 0) {
                                    removeTransaction = true;
                                }
                            }
                            if (removeTransaction) {
                                removeList.addElement(nextTransaction);
                                continue;
                            }
                            fireList.addElement(nextTransaction);
                        }
                        for (j = 0; j < removeList.size(); ++j) {
                            SIPTransactionStack.this.clientTransactions.removeElement(removeList.elementAt(j));
                        }
                    }
                    removeList = new Vector();
                    cloneable = SIPTransactionStack.this.dialogTable;
                    synchronized (cloneable) {
                        Enumeration values = SIPTransactionStack.this.dialogTable.elements();
                        while (values.hasMoreElements()) {
                            Response response;
                            Transaction transaction;
                            Dialog d = (Dialog)values.nextElement();
                            if (d.getState() == 4) {
                                removeList.addElement(d);
                            }
                            if (!d.isServer() || d.ackSeen || !d.isInviteDialog() || (transaction = d.getLastTransaction()).getState() != 6 || !(transaction instanceof ServerTransaction) || !((ServerTransaction)transaction).isMapped || (response = transaction.getLastResponse()).getStatusCode() != 200) continue;
                            try {
                                if (!d.toRetransmitFinalResponse()) continue;
                                transaction.sendMessage(response);
                            }
                            catch (IOException ex) {
                                d.setState(4);
                            }
                            finally {
                                fireList.addElement(transaction);
                            }
                        }
                        for (int j2 = 0; j2 < removeList.size(); ++j2) {
                            Dialog d = (Dialog)removeList.elementAt(j2);
                            SIPTransactionStack.this.dialogTable.remove(d.getDialogId());
                        }
                    }
                    for (int i = 0; i < fireList.size(); ++i) {
                        nextTransaction = (Transaction)fireList.elementAt(i);
                        nextTransaction.fireTimer();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

