/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.stack;

import gov.nist.siplite.header.CallIdHeader;
import gov.nist.siplite.header.Header;
import gov.nist.siplite.message.Message;
import gov.nist.siplite.stack.MessageLog;
import java.io.PrintStream;
import java.util.Enumeration;

public class ServerLog {
    public static int TRACE_NONE = 0;
    public static int TRACE_MESSAGES = 16;
    public static int TRACE_EXCEPTION = 17;
    public static int TRACE_DEBUG = 32;
    protected static PrintStream printWriter = null;
    protected static PrintStream traceWriter = null;
    protected static String auxInfo;
    protected static String description;
    protected static String stackIpAddress;
    protected static int traceLevel;

    public static void checkLogFile() {
        if (printWriter == null && (printWriter = traceWriter) == null) {
            printWriter = System.out;
        }
    }

    private static String getStatusHeader(Message message) {
        Enumeration statusHeaders = message.getHeaders("NISTExtension");
        String status = null;
        if (statusHeaders.hasMoreElements()) {
            Header statusHdr = (Header)statusHeaders.nextElement();
            status = statusHdr.getHeaderValue();
        }
        return status;
    }

    public static boolean needsLogging(int logLevel) {
        return traceLevel >= logLevel;
    }

    public static boolean needsLogging() {
        return traceLevel >= 16;
    }

    public static void setLogFileName(String loggerURL) {
    }

    public static void logMessage(String message) {
        ServerLog.checkLogFile();
        String logInfo = message;
    }

    public static synchronized void logMessage(String message, String from, String to, boolean sender, String callId, String firstLine, String status, String tid, String time) {
        MessageLog log = new MessageLog(message, from, to, time, sender, firstLine, status, tid, callId);
        ServerLog.logMessage(log.flush());
    }

    public static synchronized void logMessage(String message, String from, String to, boolean sender, String callId, String firstLine, String status, String tid, long time) {
        MessageLog log = new MessageLog(message, from, to, time, sender, firstLine, status, tid, callId);
        ServerLog.logMessage(log.flush());
    }

    public static void logMessage(String message, String from, String to, boolean sender, String callId, String firstLine, String status, String tid) {
        String time = new Long(System.currentTimeMillis()).toString();
        ServerLog.logMessage(message, from, to, sender, callId, firstLine, status, tid, time);
    }

    public static void logMessage(Message message, String from, String to, boolean sender, String time) {
        ServerLog.checkLogFile();
        CallIdHeader cid = message.getCallId();
        String callId = null;
        if (cid != null) {
            callId = message.getCallId().getCallId();
        }
        String firstLine = message.getFirstLine();
        String inputText = message.encode();
        String status = ServerLog.getStatusHeader(message);
        String tid = message.getTransactionId();
        ServerLog.logMessage(inputText, from, to, sender, callId, firstLine, status, tid, time);
    }

    public static void logMessage(Message message, String from, String to, boolean sender, long time) {
        ServerLog.checkLogFile();
        CallIdHeader cid = message.getCallId();
        String callId = null;
        if (cid != null) {
            callId = cid.getCallId();
        }
        String firstLine = message.getFirstLine().trim();
        String inputText = message.encode();
        String status = ServerLog.getStatusHeader(message);
        String tid = message.getTransactionId();
        ServerLog.logMessage(inputText, from, to, sender, callId, firstLine, status, tid, time);
    }

    public static void logMessage(Message message, String from, String to, boolean sender) {
        ServerLog.logMessage(message, from, to, sender, new Long(System.currentTimeMillis()).toString());
    }

    public static void logMessage(Message message, String from, String to, String status, boolean sender, String time) {
        ServerLog.checkLogFile();
        CallIdHeader cid = message.getCallId();
        String callId = null;
        if (cid != null) {
            callId = cid.getCallId();
        }
        String firstLine = message.getFirstLine().trim();
        String encoded = message.encode();
        String tid = message.getTransactionId();
        String shdr = ServerLog.getStatusHeader(message);
        if (shdr != null) {
            status = shdr + "/" + status;
        }
        ServerLog.logMessage(encoded, from, to, sender, callId, firstLine, status, tid, time);
    }

    public static void logMessage(Message message, String from, String to, String status, boolean sender, long time) {
        ServerLog.checkLogFile();
        CallIdHeader cid = message.getCallId();
        String callId = null;
        if (cid != null) {
            callId = cid.getCallId();
        }
        String firstLine = message.getFirstLine().trim();
        String encoded = message.encode();
        String tid = message.getTransactionId();
        String shdr = ServerLog.getStatusHeader(message);
        if (shdr != null) {
            status = shdr + "/" + status;
        }
        ServerLog.logMessage(encoded, from, to, sender, callId, firstLine, status, tid, time);
    }

    public static void logMessage(Message message, String from, String to, String status, boolean sender) {
        ServerLog.logMessage(message, from, to, status, sender, System.currentTimeMillis());
    }

    public static void logException(Exception ex) {
        if (traceLevel >= TRACE_EXCEPTION) {
            ServerLog.checkLogFile();
            if (printWriter != null) {
                ex.printStackTrace();
            }
        }
    }

    public static void setTraceLevel(int level) {
        traceLevel = level;
    }

    public static int getTraceLevel() {
        return traceLevel;
    }

    public static void setAuxInfo(String auxInfo) {
        ServerLog.auxInfo = auxInfo;
    }

    public static void setDescription(String desc) {
        description = desc;
    }

    static {
        traceLevel = TRACE_MESSAGES;
    }
}

