/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.stack;

import gov.nist.core.Utils;
import gov.nist.siplite.address.Hop;
import gov.nist.siplite.header.ViaHeader;
import gov.nist.siplite.header.ViaList;
import gov.nist.siplite.message.Message;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.stack.Dialog;
import gov.nist.siplite.stack.MessageChannel;
import gov.nist.siplite.stack.SIPServerException;
import gov.nist.siplite.stack.SIPServerRequestInterface;
import gov.nist.siplite.stack.SIPTransactionStack;
import gov.nist.siplite.stack.Transaction;
import java.io.IOException;
import javax.microedition.sip.SipException;

public class ServerTransaction
extends Transaction
implements SIPServerRequestInterface {
    protected int collectionTime;
    private SIPServerRequestInterface requestOf;
    protected boolean isMapped;

    private void sendSIPResponse(Response transactionResponse) throws IOException {
        if (transactionResponse.getTopmostVia().getParameter("received") == null) {
            this.getMessageChannel().sendMessage(transactionResponse);
        } else {
            ViaHeader via = transactionResponse.getTopmostVia();
            String host = via.getParameter("received");
            int port = via.getPort();
            if (port == -1) {
                port = 5060;
            }
            String transport = via.getTransport();
            Hop hop = new Hop(host + ":" + port + "/" + transport);
            MessageChannel messageChannel = ((SIPTransactionStack)this.getSIPStack()).createRawMessageChannel(hop);
            messageChannel.sendMessage(transactionResponse);
        }
        this.lastResponse = transactionResponse;
    }

    protected ServerTransaction(SIPTransactionStack newSIPMessageStack, MessageChannel newChannelToHeaderUse) {
        super(newSIPMessageStack, newChannelToHeaderUse);
    }

    public void setRequestInterface(SIPServerRequestInterface newRequestOf) {
        this.requestOf = newRequestOf;
    }

    public String getProcessingInfo() {
        return this.requestOf.getProcessingInfo();
    }

    public boolean isMessagePartOfTransaction(Message messageToHeaderTest) {
        ViaList viaHeaders;
        boolean transactionMatches = false;
        if ((((SIPTransactionStack)this.getSIPStack()).isDialogCreated(((Request)messageToHeaderTest).getMethod()) || !this.isTerminated()) && (viaHeaders = messageToHeaderTest.getViaHeaders()) != null) {
            ViaHeader topViaHeader = (ViaHeader)viaHeaders.getFirst();
            String messageBranch = topViaHeader.getBranch();
            if (messageBranch != null && !messageBranch.toUpperCase().startsWith("z9hG4bK".toUpperCase())) {
                messageBranch = null;
            }
            if (messageBranch != null && this.getBranch() != null) {
                if (this.getBranch().equals(messageBranch) && topViaHeader.getSentBy().equals(((ViaHeader)this.getOriginalRequest().getViaHeaders().getFirst()).getSentBy())) {
                    transactionMatches = true;
                }
            } else {
                boolean skipToHeader;
                String originalFromHeaderTag = this.getOriginalRequest().getFromHeader().getTag();
                String thisFromHeaderTag = messageToHeaderTest.getFromHeader().getTag();
                boolean skipFromHeader = originalFromHeaderTag == null || thisFromHeaderTag == null;
                String originalToHeaderTag = this.getOriginalRequest().getTo().getTag();
                String thisToHeaderTag = messageToHeaderTest.getTo().getTag();
                boolean bl = skipToHeader = originalToHeaderTag == null || thisToHeaderTag == null;
                if (this.getOriginalRequest().getRequestURI().equals(((Request)messageToHeaderTest).getRequestURI()) && (skipFromHeader || originalFromHeaderTag.equals(thisFromHeaderTag)) && (skipToHeader || originalToHeaderTag.equals(thisToHeaderTag)) && this.getOriginalRequest().getCallId().getCallId().equals(messageToHeaderTest.getCallId().getCallId()) && this.getOriginalRequest().getCSeqHeader().getSequenceNumber() == messageToHeaderTest.getCSeqHeader().getSequenceNumber() && topViaHeader.equals(this.getOriginalRequest().getViaHeaders().getFirst())) {
                    transactionMatches = true;
                }
            }
        }
        return transactionMatches;
    }

    protected void map() throws IOException {
        if (this.getState() == -1 || this.getState() == 1) {
            if (this.isInviteTransaction() && !this.isMapped) {
                this.isMapped = true;
                new SendTrying(this);
            } else {
                this.isMapped = true;
            }
        }
    }

    public boolean isTransactionMapped() {
        return this.isMapped;
    }

    public void processRequest(Request transactionRequest, MessageChannel sourceChannel) throws SIPServerException {
        boolean toTu = false;
        try {
            if (this.getState() == -1) {
                this.setOriginalRequest(transactionRequest);
                this.setState(1);
                toTu = true;
                if (this.isInviteTransaction() && this.isMapped) {
                    this.sendMessage(transactionRequest.createResponse(100, "Trying"));
                }
            } else {
                if (this.isInviteTransaction() && 4 == this.getState() && transactionRequest.getMethod().equals("ACK")) {
                    this.setState(5);
                    this.disableRetransmissionTimer();
                    if (!this.isReliable()) {
                        if (this.lastResponse != null && this.lastResponse.getStatusCode() == 487) {
                            this.setState(6);
                        } else {
                            this.enableTimeoutTimer(10);
                        }
                    } else {
                        this.setState(6);
                    }
                    return;
                }
                if (transactionRequest.getMethod().equals(this.getOriginalRequest().getMethod())) {
                    if (this.getState() == 3 || this.getState() == 4) {
                        if (this.lastResponse != null) {
                            try {
                                this.getMessageChannel().sendMessage(this.lastResponse);
                            }
                            catch (IOException e) {
                                this.setState(6);
                                throw e;
                            }
                        }
                    } else if (transactionRequest.getMethod().equals("ACK")) {
                        this.requestOf.processRequest(transactionRequest, this);
                    }
                    return;
                }
            }
            if (4 != this.getState() && 6 != this.getState() && this.requestOf != null) {
                if (this.getOriginalRequest().getMethod().equals(transactionRequest.getMethod())) {
                    if (toTu) {
                        this.requestOf.processRequest(transactionRequest, this);
                    }
                } else {
                    this.requestOf.processRequest(transactionRequest, this);
                }
            } else {
                if (((SIPTransactionStack)this.getSIPStack()).isDialogCreated(this.getOriginalRequest().getMethod()) && this.getState() == 6 && transactionRequest.getMethod().equals("ACK") && this.requestOf != null) {
                    if (!this.getDialog().ackSeen) {
                        this.getDialog().ackReceived(transactionRequest);
                        this.requestOf.processRequest(transactionRequest, this);
                    }
                } else if (transactionRequest.getMethod().equals("CANCEL")) {
                    // empty if block
                }
                try {
                    this.sendMessage(transactionRequest.createResponse(200));
                }
                catch (IOException ex) {}
            }
        }
        catch (IOException e) {
            this.raiseErrorEvent(2);
        }
    }

    public void sendMessage(Message messageToSend) throws IOException {
        Response transactionResponse = (Response)messageToSend;
        int statusCode = transactionResponse.getStatusCode();
        Dialog dialog = this.dialog;
        if (this.getBranch() != null) {
            transactionResponse.getTopmostVia().setBranch(this.getBranch());
        } else {
            transactionResponse.getTopmostVia().removeParameter("branch");
        }
        if (!transactionResponse.getCSeqHeader().getMethod().equals(this.getOriginalRequest().getMethod())) {
            this.sendSIPResponse(transactionResponse);
            return;
        }
        if (this.dialog != null) {
            if (this.dialog.getRemoteTag() == null && transactionResponse.getTo().getTag() != null && ((SIPTransactionStack)this.getSIPStack()).isDialogCreated(transactionResponse.getCSeqHeader().getMethod())) {
                this.dialog.setRemoteTag(transactionResponse.getTo().getTag());
                ((SIPTransactionStack)this.getSIPStack()).putDialog(this.dialog);
                if (statusCode / 100 == 1) {
                    this.dialog.setState(1);
                }
            } else if (((SIPTransactionStack)this.getSIPStack()).isDialogCreated(transactionResponse.getCSeqHeader().getMethod())) {
                if (statusCode / 100 == 2) {
                    if (!this.isInviteTransaction()) {
                        this.dialog.setState(2);
                    } else if (this.dialog.getState() == -1) {
                        this.dialog.setState(1);
                    }
                } else if (statusCode >= 300 && statusCode <= 699 && (this.dialog.getState() == -1 || this.dialog.getState() == 1)) {
                    this.dialog.setState(4);
                }
            } else if (transactionResponse.getCSeqHeader().getMethod().equals("BYE") && statusCode / 100 == 2) {
                if (!this.isReliable()) {
                    this.dialog.setState(3);
                } else {
                    this.dialog.setState(4);
                }
            }
        }
        if (this.getState() == 1) {
            if (statusCode / 100 == 1) {
                this.setState(3);
            } else if (200 <= statusCode && statusCode <= 699) {
                if (!this.isInviteTransaction()) {
                    this.setState(4);
                } else if (statusCode / 100 == 2) {
                    this.collectionTime = 64;
                    this.setState(6);
                } else {
                    this.setState(4);
                }
                if (!this.isReliable()) {
                    this.enableRetransmissionTimer();
                }
                this.enableTimeoutTimer(64);
            }
        } else if (this.getState() == 3) {
            if (this.isInviteTransaction()) {
                if (statusCode / 100 == 2) {
                    if (!transactionResponse.getCSeqHeader().getMethod().equals("CANCEL")) {
                        this.setState(6);
                        if (!this.isReliable()) {
                            this.getDialog().setRetransmissionTicks();
                            this.enableRetransmissionTimer();
                        }
                        this.collectionTime = 64;
                        this.enableTimeoutTimer(64);
                    }
                } else if (300 <= statusCode && statusCode <= 699) {
                    this.setState(4);
                    if (!this.isReliable()) {
                        this.enableRetransmissionTimer();
                    }
                    this.enableTimeoutTimer(64);
                } else if (statusCode / 100 == 2) {
                    this.setState(6);
                    this.disableRetransmissionTimer();
                    this.disableTimeoutTimer();
                }
            } else if (200 <= statusCode && statusCode <= 699) {
                this.setState(4);
                if (!this.isReliable()) {
                    this.disableRetransmissionTimer();
                    this.enableTimeoutTimer(64);
                } else {
                    this.setState(6);
                }
            }
        } else if (this.getState() == 4) {
            return;
        }
        try {
            this.lastResponse = transactionResponse;
            this.sendSIPResponse(transactionResponse);
        }
        catch (IOException e) {
            this.setState(6);
            throw e;
        }
    }

    public String getViaHost() {
        return this.encapsulatedChannel.getViaHost();
    }

    public int getViaPort() {
        return this.encapsulatedChannel.getViaPort();
    }

    protected void fireRetransmissionTimer() {
        try {
            if (this.isInviteTransaction() && ((SIPTransactionStack)this.getSIPStack()).retransmissionFilter) {
                this.getMessageChannel().sendMessage(this.lastResponse);
            }
        }
        catch (IOException e) {
            this.raiseErrorEvent(2);
        }
    }

    protected void fireTimeoutTimer() {
        Dialog dialog = this.getDialog();
        int mystate = this.getState();
        if (((SIPTransactionStack)this.getSIPStack()).isDialogCreated(this.getOriginalRequest().getMethod()) && (mystate == 2 || mystate == 1)) {
            dialog.setState(4);
        } else if (this.getOriginalRequest().getMethod().equals("BYE") && dialog != null) {
            dialog.setState(4);
        }
        if ((this.getState() == 5 || this.getState() == 4) && this.isInviteTransaction()) {
            this.raiseErrorEvent(1);
            this.setState(6);
        } else if (!(this.isInviteTransaction() || this.getState() != 4 && this.getState() != 5)) {
            this.setState(6);
        } else if (this.isInviteTransaction() && this.getState() == 6) {
            this.raiseErrorEvent(1);
            if (dialog != null) {
                dialog.setState(4);
            }
        }
    }

    public Response getLastResponse() {
        return this.lastResponse;
    }

    public void setOriginalRequest(Request originalRequest) {
        super.setOriginalRequest(originalRequest);
        if (originalRequest.getMethod().equals("ACK")) {
            this.setState(6);
        }
    }

    public void sendResponse(Response response) throws IOException, SipException {
        try {
            String fromTag;
            Dialog dialog = this.getDialog();
            Response responseImpl = response;
            int statusCode = responseImpl.getStatusCode();
            int statusGroup = statusCode / 100;
            if (statusGroup == 2 && this.parentStack.isDialogCreated(responseImpl.getCSeqHeader().getMethod()) && dialog != null && dialog.getLocalTag() == null && responseImpl.getTo().getTag() == null) {
                throw new SipException("ToHeader tag must be set for OK", 8);
            }
            if (statusGroup == 2 && responseImpl.getCSeqHeader().getMethod().equals("INVITE") && responseImpl.getHeader("Contact") == null) {
                throw new SipException("Contact Header is mandatory for the OK", 8);
            }
            if (dialog != null && dialog.getLocalTag() != null) {
                responseImpl.getTo().setTag(dialog.getLocalTag());
            }
            if ((fromTag = this.getRequest().getFromHeader().getTag()) != null) {
                responseImpl.getFromHeader().setTag(fromTag);
            }
            this.sendMessage(response);
            if (Utils.equalsIgnoreCase(responseImpl.getCSeqHeader().getMethod(), "CANCEL") && statusGroup == 2 && this.parentStack.isDialogCreated(this.getOriginalRequest().getMethod()) && (dialog.getState() == -1 || dialog.getState() == 1)) {
                dialog.setState(4);
            }
            if (dialog != null) {
                dialog.printTags();
                if (Utils.equalsIgnoreCase(responseImpl.getCSeqHeader().getMethod(), "BYE")) {
                    dialog.setState(4);
                } else if (Utils.equalsIgnoreCase(responseImpl.getCSeqHeader().getMethod(), "CANCEL")) {
                    if (dialog.getState() == -1 || dialog.getState() == 1) {
                        dialog.setState(4);
                    }
                } else {
                    if (dialog.getLocalTag() == null && responseImpl.getTo().getTag() != null && statusCode != 100) {
                        dialog.setLocalTag(responseImpl.getTo().getTag());
                    }
                    if (this.parentStack.isDialogCreated(responseImpl.getCSeqHeader().getMethod())) {
                        if (statusGroup == 1 && statusCode != 100) {
                            dialog.setState(1);
                        } else if (statusGroup == 2) {
                            dialog.setState(2);
                        }
                        if (statusCode != 100) {
                            this.parentStack.putDialog(dialog);
                        }
                    }
                }
            }
        }
        catch (NullPointerException npe) {
            throw new SipException("NPE occured: " + npe.getMessage(), 0);
        }
    }

    public MessageChannel getResponseChannel() {
        return this;
    }

    class SendTrying
    extends Thread {
        ServerTransaction myTransaction;

        public SendTrying(ServerTransaction transaction) {
            this.myTransaction = transaction;
            Thread myThread = new Thread(this);
            myThread.start();
        }

        public void run() {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (this.myTransaction.getState() == 1) {
                try {
                    this.myTransaction.sendMessage(this.myTransaction.getOriginalRequest().createResponse(100, "Trying"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

