/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.stack;

import gov.nist.core.ParseException;
import gov.nist.siplite.header.CallIdHeader;
import gov.nist.siplite.header.EventHeader;
import gov.nist.siplite.message.Message;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.stack.Dialog;

public class Subscription {
    private Dialog dialog = null;
    private EventHeader eventHeader = null;

    public Subscription(Dialog subscriptionDialog, Request request) {
        this.dialog = subscriptionDialog;
        if (request.getMethod().equalsIgnoreCase("REFER")) {
            this.eventHeader = new EventHeader();
            try {
                this.eventHeader.setEventType("REFER");
            }
            catch (ParseException pe) {}
        } else {
            EventHeader eh = (EventHeader)request.getHeader("Event");
            if (eh != null) {
                this.eventHeader = (EventHeader)eh.clone();
            }
        }
    }

    public boolean containsSubscription(Message message) {
        String toTag;
        String fromTag;
        CallIdHeader hCallId = (CallIdHeader)message.getHeader("Call-ID");
        if (hCallId == null) {
            return false;
        }
        CallIdHeader callId = this.dialog.getCallId();
        if (callId == null) {
            return false;
        }
        String string = fromTag = this.dialog.isServer() ? this.dialog.getRemoteTag() : this.dialog.getLocalTag();
        if (fromTag == null) {
            return false;
        }
        if (message instanceof Response) {
            String fTag = message.getFromHeaderTag();
            if (fTag == null) {
                return false;
            }
            return hCallId.equals(callId) && fTag.equalsIgnoreCase(fromTag);
        }
        EventHeader hEvent = (EventHeader)message.getHeader("Event");
        if (hEvent == null) {
            String reqMethod = ((Request)message).getMethod();
            if (reqMethod.equalsIgnoreCase("REFER")) {
                hEvent = this.eventHeader;
            } else {
                return false;
            }
        }
        if ((toTag = message.getToTag()) == null) {
            return false;
        }
        return hEvent.match(this.eventHeader) && toTag.equalsIgnoreCase(fromTag) && hCallId.equals(callId);
    }
}

