/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.stack;

import com.sun.midp.io.j2me.socket.Protocol;
import gov.nist.core.HostPort;
import gov.nist.core.ParseException;
import gov.nist.siplite.header.CSeqHeader;
import gov.nist.siplite.header.CallIdHeader;
import gov.nist.siplite.header.FromHeader;
import gov.nist.siplite.header.RequestLine;
import gov.nist.siplite.header.StatusLine;
import gov.nist.siplite.header.ToHeader;
import gov.nist.siplite.header.ViaHeader;
import gov.nist.siplite.header.ViaList;
import gov.nist.siplite.message.Message;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.parser.PipelinedMsgParser;
import gov.nist.siplite.parser.SIPMessageListener;
import gov.nist.siplite.stack.MessageChannel;
import gov.nist.siplite.stack.SIPMessageStack;
import gov.nist.siplite.stack.SIPServerException;
import gov.nist.siplite.stack.SIPServerRequestInterface;
import gov.nist.siplite.stack.SIPServerResponseInterface;
import gov.nist.siplite.stack.ServerLog;
import gov.nist.siplite.stack.TCPMessageProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.SocketConnection;

public class TCPMessageChannel
extends MessageChannel
implements SIPMessageListener {
    private SocketConnection mySock;
    private PipelinedMsgParser myParser;
    private InputStream myClientInputStream;
    private OutputStream myClientOutputStream;
    private SIPMessageStack stack;
    private String myAddress;
    private int myPort;
    private String peerAddress;
    private int peerPort;
    private String peerProtocol;
    private boolean exitFlag;
    private int useCounter;

    protected TCPMessageChannel(SocketConnection sock, SIPMessageStack sipStack, TCPMessageProcessor msgProcessor) throws IOException {
        this.mySock = sock;
        this.myClientInputStream = sock.openInputStream();
        this.myClientOutputStream = sock.openOutputStream();
        this.stack = sipStack;
        this.messageProcessor = msgProcessor;
        this.peerAddress = sock.getAddress();
        this.peerPort = sock.getPort();
        this.myAddress = sock.getLocalAddress();
        this.myPort = sock.getLocalPort();
        this.start();
        this.incrementUseCounter();
    }

    protected TCPMessageChannel(HostPort targetHostPort, SIPMessageStack sipStack, TCPMessageProcessor msgProcessor) throws IOException {
        this.stack = sipStack;
        this.messageProcessor = msgProcessor;
        this.myAddress = sipStack.getHostAddress();
        this.peerAddress = targetHostPort.getHost().getHostname();
        this.peerPort = targetHostPort.getPort();
        this.makeSocket(this.peerAddress, this.peerPort);
        this.start();
        this.incrementUseCounter();
    }

    private void makeSocket(String host, int port) throws IOException {
        if (host == null || host.length() == 0 || port < 0) {
            throw new IOException("Invalid hostname or port number");
        }
        String name = "//" + host + ":" + port;
        Protocol conn = new Protocol();
        try {
            this.mySock = (SocketConnection)conn.openPrim(this.stack.getSecurityToken(), name);
        }
        catch (ConnectionNotFoundException ex) {
            throw new IOException("Can't connect to " + name);
        }
        this.myClientInputStream = this.mySock.openInputStream();
        this.myClientOutputStream = this.mySock.openOutputStream();
    }

    public boolean isReliable() {
        return true;
    }

    public synchronized void close() {
        if (0 != this.useCounter) {
            --this.useCounter;
        }
        if (0 == this.useCounter) {
            this.exit();
            if (null != this.messageProcessor) {
                ((TCPMessageProcessor)this.messageProcessor).notifyClose(this);
            }
        }
    }

    protected synchronized void exit() {
        this.useCounter = 0;
        this.exitFlag = true;
        this.shutDownConnection();
        this.messageProcessor = null;
    }

    public SIPMessageStack getSIPStack() {
        return this.stack;
    }

    public String getTransport() {
        return "TCP";
    }

    public String getPeerAddress() {
        return this.peerAddress;
    }

    private synchronized void sendMessage(byte[] msg) throws IOException {
        if (this.exitFlag) {
            return;
        }
        if (this.mySock == null) {
            this.reConnect();
        }
        this.myClientOutputStream.write(msg);
    }

    public void sendMessage(Message sipMessage) throws IOException {
        if (sipMessage == null) {
            throw new NullPointerException("null arg!");
        }
        byte[] msg = sipMessage.encodeAsBytes();
        long time = System.currentTimeMillis();
        this.sendMessage(msg);
        if (ServerLog.needsLogging(ServerLog.TRACE_MESSAGES)) {
            this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
        }
    }

    public void sendMessage(byte[] message, String receiverAddress, int receiverPort) throws IOException, IllegalArgumentException {
        if (message == null || receiverAddress == null) {
            throw new IllegalArgumentException("Null argument");
        }
        if (!receiverAddress.equals(this.peerAddress) || this.peerPort != receiverPort) {
            throw new IOException("This channel is bound to different peer");
        }
        this.sendMessage(message);
    }

    public void handleException(SIPServerException ex) {
        int rc = ex.getRC();
        String msgString = ex.getMessage();
        if (rc != 0) {
            Request request = (Request)ex.getSIPMessage();
            Response response = request.createResponse(rc);
            try {
                this.sendMessage(response);
            }
            catch (IOException ioex) {}
        } else {
            try {
                this.sendMessage(msgString.getBytes());
            }
            catch (IOException ioex) {
                // empty catch block
            }
        }
    }

    public void handleException(ParseException ex, Message sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (hdrClass.equals(FromHeader.clazz) || hdrClass.equals(ToHeader.clazz) || hdrClass.equals(CSeqHeader.clazz) || hdrClass.equals(ViaHeader.clazz) || hdrClass.equals(CallIdHeader.clazz) || hdrClass.equals(RequestLine.clazz) || hdrClass.equals(StatusLine.clazz)) {
            this.stack.logBadMessage(message);
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    public void processMessage(Message sipMessage) {
        if (sipMessage.getFromHeader() == null || sipMessage.getTo() == null || sipMessage.getCallId() == null || sipMessage.getCSeqHeader() == null || sipMessage.getViaHeaders() == null) {
            String badmsg = sipMessage.encode();
            this.stack.logBadMessage(badmsg);
            return;
        }
        ViaList viaList = sipMessage.getViaHeaders();
        if (sipMessage instanceof Request) {
            ViaHeader v = (ViaHeader)viaList.first();
            this.peerPort = v.hasPort() ? v.getPort() : 5060;
            this.peerProtocol = v.getTransport();
        }
        long receptionTime = System.currentTimeMillis();
        if (sipMessage instanceof Request) {
            Request sipRequest = (Request)sipMessage;
            SIPServerRequestInterface sipServerRequest = this.stack.newSIPServerRequest(sipRequest, this);
            try {
                sipServerRequest.processRequest(sipRequest, this);
                ServerLog.logMessage(sipMessage, sipRequest.getViaHost() + ":" + sipRequest.getViaPort(), this.stack.getHostAddress() + ":" + this.stack.getPort(this.getTransport()), false, receptionTime);
            }
            catch (SIPServerException ex) {
                ServerLog.logMessage(sipMessage, sipRequest.getViaHost() + ":" + sipRequest.getViaPort(), this.stack.getHostAddress() + ":" + this.stack.getPort(this.getTransport()), ex.getMessage(), false, receptionTime);
                this.handleException(ex);
            }
        } else {
            Response sipResponse = (Response)sipMessage;
            SIPServerResponseInterface sipServerResponse = this.stack.newSIPServerResponse(sipResponse, this);
            try {
                sipServerResponse.processResponse(sipResponse, this);
            }
            catch (SIPServerException ex) {
                ServerLog.logMessage(sipMessage, this.getPeerAddress().toString() + ":" + this.getPeerPort(), this.stack.getHostAddress() + ":" + this.stack.getPort(this.getTransport()), ex.getMessage(), false, receptionTime);
            }
        }
    }

    private void start() {
        this.myParser = new PipelinedMsgParser(this, this.myClientInputStream);
        this.myParser.processInput();
    }

    protected synchronized void incrementUseCounter() {
        if (!this.exitFlag) {
            ++this.useCounter;
        }
    }

    public void handleIOException() {
        if (!this.exitFlag) {
            this.shutDownConnection();
        }
    }

    private synchronized void shutDownConnection() {
        try {
            if (null != this.myClientInputStream) {
                this.myClientInputStream.close();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            if (null != this.myClientOutputStream) {
                this.myClientOutputStream.close();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            if (null != this.mySock) {
                this.mySock.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mySock = null;
    }

    private void reConnect() throws IOException {
        this.shutDownConnection();
        this.makeSocket(this.peerAddress, this.peerPort);
        this.myParser = new PipelinedMsgParser(this, this.myClientInputStream);
        this.myParser.processInput();
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        TCPMessageChannel that = (TCPMessageChannel)other;
        return this.mySock == that.mySock;
    }

    public String getKey() {
        return TCPMessageChannel.getKey(this.peerAddress, this.peerPort, "TCP");
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public boolean isSecure() {
        return false;
    }
}

