/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.stack;

import com.sun.midp.io.j2me.socket.Protocol;
import gov.nist.core.HostPort;
import gov.nist.siplite.stack.MessageChannel;
import gov.nist.siplite.stack.MessageProcessor;
import gov.nist.siplite.stack.SIPMessageStack;
import gov.nist.siplite.stack.TCPMessageChannel;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.SocketConnection;

public class TCPMessageProcessor
extends MessageProcessor
implements Runnable {
    private int localPort = 5060;
    private ServerSocketConnection serverSocket;
    public boolean ERROR_SOCKET = false;
    private static final int MAX_LENGTH = 1000;
    private SIPMessageStack sipStack;
    private Thread incomingHandler;
    private Vector tcpMsgChannels = new Vector();

    public void run() {
        try {
            while (!this.exitFlag) {
                SocketConnection sock = (SocketConnection)this.serverSocket.acceptAndOpen();
                if (sock == null) continue;
                TCPMessageChannel tmc = new TCPMessageChannel(sock, this.sipStack, this);
                this.tcpMsgChannels.addElement(tmc);
            }
        }
        catch (IOException ex) {
            if (!this.exitFlag) {
                // empty if block
            }
        }
    }

    public SIPMessageStack getSIPStack() {
        return this.sipStack;
    }

    public TCPMessageProcessor(SIPMessageStack ss, int lp) {
        this.sipStack = ss;
        this.localPort = lp;
    }

    public String getTransport() {
        return "TCP";
    }

    public int getPort() {
        return this.localPort;
    }

    public SIPMessageStack getSipStack() {
        return this.sipStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel createMessageChannel(HostPort targetHostPort) throws IOException {
        TCPMessageChannel tmc;
        Vector vector = this.tcpMsgChannels;
        synchronized (vector) {
            for (int i = 0; i < this.tcpMsgChannels.size(); ++i) {
                tmc = (TCPMessageChannel)this.tcpMsgChannels.elementAt(i);
                if (!tmc.getPeerHostPort().equals(targetHostPort)) continue;
                tmc.incrementUseCounter();
                return tmc;
            }
        }
        tmc = new TCPMessageChannel(targetHostPort, this.sipStack, this);
        this.tcpMsgChannels.addElement(tmc);
        return tmc;
    }

    public boolean isSecure() {
        return false;
    }

    public synchronized void start() throws IOException {
        Protocol conn = new Protocol();
        this.serverSocket = (ServerSocketConnection)conn.openPrim(this.sipStack.getSecurityToken(), "//:" + this.localPort);
        this.incomingHandler = new Thread(this);
        this.incomingHandler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        try {
            Object[] arr;
            this.exitFlag = true;
            if (this.serverSocket != null) {
                this.serverSocket.close();
                try {
                    this.incomingHandler.join();
                }
                catch (InterruptedException exc) {
                    // empty catch block
                }
                this.serverSocket = null;
            }
            Vector vector = this.tcpMsgChannels;
            synchronized (vector) {
                arr = new Object[this.tcpMsgChannels.size()];
                this.tcpMsgChannels.copyInto(arr);
            }
            for (int i = 0; i < arr.length; ++i) {
                TCPMessageChannel tmc = (TCPMessageChannel)arr[i];
                tmc.exit();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void notifyClose(TCPMessageChannel tmc) {
        this.tcpMsgChannels.removeElement(tmc);
    }
}

