/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.stack;

import gov.nist.core.NameValueList;
import gov.nist.core.ParseException;
import gov.nist.siplite.address.Address;
import gov.nist.siplite.address.SipURI;
import gov.nist.siplite.address.URI;
import gov.nist.siplite.header.ContactHeader;
import gov.nist.siplite.header.ContactList;
import gov.nist.siplite.header.RecordRouteHeader;
import gov.nist.siplite.header.RecordRouteList;
import gov.nist.siplite.header.RouteHeader;
import gov.nist.siplite.header.RouteList;
import gov.nist.siplite.header.ViaHeader;
import gov.nist.siplite.header.ViaList;
import gov.nist.siplite.message.Message;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.parser.StringMsgParser;
import gov.nist.siplite.stack.Dialog;
import gov.nist.siplite.stack.MessageChannel;
import gov.nist.siplite.stack.MessageProcessor;
import gov.nist.siplite.stack.SIPMessageStack;
import gov.nist.siplite.stack.SIPServerException;
import gov.nist.siplite.stack.SIPTransactionErrorEvent;
import gov.nist.siplite.stack.SIPTransactionEventListener;
import gov.nist.siplite.stack.SIPTransactionStack;
import gov.nist.siplite.stack.ServerTransaction;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.sip.SipException;

public abstract class Transaction
extends MessageChannel {
    protected static final int BASE_TIMER_INTERVAL = 500;
    protected static final int T1 = 1;
    protected static final int T4 = 10;
    protected static final int T2 = 8;
    protected static final int TIMER_A = 1;
    protected static final int TIMER_B = 64;
    protected static final int TIMER_J = 64;
    protected static final int TIMER_F = 64;
    protected static final int TIMER_H = 64;
    protected static final int TIMER_I = 10;
    protected static final int TIMER_K = 10;
    protected static final int TIMER_D = 64;
    protected static final int TIMER_C = 360;
    protected Response lastResponse;
    protected Dialog dialog;
    protected boolean ackSeenFlag;
    protected boolean toListener;
    public static final int INITIAL_STATE = -1;
    public static final int TRYING_STATE = 1;
    public static final int CALLING_STATE = 2;
    public static final int PROCEEDING_STATE = 3;
    public static final int COMPLETED_STATE = 4;
    public static final int CONFIRMED_STATE = 5;
    public static final int TERMINATED_STATE = 6;
    protected static final int MAXIMUM_RETRANSMISSION_TICK_COUNT = 8;
    protected SIPTransactionStack parentStack;
    private Request originalRequest;
    protected MessageChannel encapsulatedChannel;
    private String branch;
    private int currentState;
    private int retransmissionTimerLastTickCount;
    private int retransmissionTimerTicksLeft;
    private int timeoutTimerTicksLeft;
    private Vector eventListeners;
    protected boolean isCancelled;
    protected Object applicationData;

    public Object getApplicationData() {
        return this.applicationData;
    }

    public void setApplicationData(Object newApplicationData) {
        this.applicationData = newApplicationData;
    }

    public String getBranchId() {
        return this.branch;
    }

    protected Transaction(SIPTransactionStack newParentStack, MessageChannel newEncapsulatedChannel) {
        this.parentStack = newParentStack;
        this.encapsulatedChannel = newEncapsulatedChannel;
        this.currentState = -1;
        this.disableRetransmissionTimer();
        this.disableTimeoutTimer();
        this.eventListeners = new Vector();
        this.addEventListener(newParentStack);
    }

    public void setOriginalRequest(Request newOriginalRequest) {
        this.originalRequest = newOriginalRequest;
        this.originalRequest.setTransaction(this);
        String newBranch = ((ViaHeader)newOriginalRequest.getViaHeaders().getFirst()).getBranch();
        if (newBranch != null) {
            this.setBranch(newBranch);
        }
    }

    public Request getOriginalRequest() {
        return this.originalRequest;
    }

    public Request getRequest() {
        return this.originalRequest;
    }

    protected final boolean isInviteTransaction() {
        return this.originalRequest.getMethod().equals("INVITE");
    }

    protected final boolean isCancelTransaction() {
        return this.originalRequest.getMethod().equals("CANCEL");
    }

    protected final boolean isByeTransaction() {
        return this.originalRequest.getMethod().equals("BYE");
    }

    public MessageChannel getMessageChannel() {
        return this.encapsulatedChannel;
    }

    public final void setBranch(String newBranch) {
        this.branch = newBranch;
    }

    public final String getBranch() {
        if (this.branch == null) {
            this.branch = this.getOriginalRequest().getTopmostVia().getBranch();
        }
        return this.branch;
    }

    public void setState(int newState) {
        this.currentState = newState;
        if (newState == 6) {
            // empty if block
        }
    }

    public final int getState() {
        return this.currentState;
    }

    protected final void enableRetransmissionTimer() {
        this.enableRetransmissionTimer(1);
    }

    protected final void enableRetransmissionTimer(int tickCount) {
        this.retransmissionTimerLastTickCount = this.retransmissionTimerTicksLeft = Math.min(tickCount, 8);
    }

    protected final void disableRetransmissionTimer() {
        this.retransmissionTimerTicksLeft = -1;
    }

    protected final void enableTimeoutTimer(int tickCount) {
        this.timeoutTimerTicksLeft = tickCount;
    }

    protected final void disableTimeoutTimer() {
        this.timeoutTimerTicksLeft = -1;
    }

    final synchronized void fireTimer() {
        if (this.timeoutTimerTicksLeft != -1 && --this.timeoutTimerTicksLeft == 0) {
            this.fireTimeoutTimer();
        }
        if (this.retransmissionTimerTicksLeft != -1 && --this.retransmissionTimerTicksLeft == 0) {
            this.enableRetransmissionTimer(this.retransmissionTimerLastTickCount * 2);
            this.fireRetransmissionTimer();
        }
    }

    public abstract boolean isMessagePartOfTransaction(Message var1);

    protected abstract void fireRetransmissionTimer();

    protected abstract void fireTimeoutTimer();

    protected final boolean isTerminated() {
        return this.getState() == 6;
    }

    public String getHost() {
        return this.encapsulatedChannel.getHost();
    }

    public String getKey() {
        return this.encapsulatedChannel.getKey();
    }

    public int getPort() {
        return this.encapsulatedChannel.getPort();
    }

    public SIPMessageStack getSIPStack() {
        return this.parentStack;
    }

    public String getPeerAddress() {
        return this.encapsulatedChannel.getPeerAddress();
    }

    public int getPeerPort() {
        return this.encapsulatedChannel.getPeerPort();
    }

    public String getTransport() {
        return this.encapsulatedChannel.getTransport();
    }

    public boolean isReliable() {
        return this.encapsulatedChannel.isReliable();
    }

    public ViaHeader getViaHeader() {
        ViaHeader channelViaHeader = super.getViaHeader();
        channelViaHeader.setBranch(this.branch);
        return channelViaHeader;
    }

    public void handleException(SIPServerException ex) {
        this.encapsulatedChannel.handleException(ex);
    }

    public abstract void sendMessage(Message var1) throws IOException;

    protected void sendMessage(byte[] messageBytes, String receiverAddress, int receiverPort) throws IOException {
        try {
            StringMsgParser messageParser = new StringMsgParser();
            Message messageToHeaderSend = messageParser.parseSIPMessage(messageBytes);
            this.sendMessage(messageToHeaderSend);
        }
        catch (ParseException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void addEventListener(SIPTransactionEventListener newListener) {
        this.eventListeners.addElement(newListener);
    }

    public void removeEventListener(SIPTransactionEventListener oldListener) {
        this.eventListeners.removeElement(oldListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void raiseErrorEvent(int errorEventID) {
        SIPTransactionErrorEvent newErrorEvent = new SIPTransactionErrorEvent(this, errorEventID);
        Vector vector = this.eventListeners;
        synchronized (vector) {
            Enumeration listenerIterator = this.eventListeners.elements();
            while (listenerIterator.hasMoreElements()) {
                SIPTransactionEventListener nextListener = (SIPTransactionEventListener)listenerIterator.nextElement();
                nextListener.transactionErrorEvent(newErrorEvent);
            }
        }
        this.eventListeners.removeAllElements();
        this.setState(6);
        if (this instanceof ServerTransaction && this.isByeTransaction() && this.dialog != null) {
            this.dialog.setState(4);
        }
    }

    protected boolean IsServerTransaction() {
        return this instanceof ServerTransaction;
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public void setDialog(Dialog newDialog) {
        this.dialog = newDialog;
    }

    public int getRetransmitTimer() {
        return 500;
    }

    public String getViaHost() {
        return this.getViaHeader().getHost();
    }

    public Response getLastResponse() {
        return this.lastResponse;
    }

    public String getTransactionId() {
        return this.getOriginalRequest().getTransactionId();
    }

    public int getViaPort() {
        return this.getViaHeader().getPort();
    }

    public boolean doesCancelMatchTransaction(Request requestToHeaderTest) {
        boolean transactionMatches = false;
        if (this.getOriginalRequest() == null || this.getOriginalRequest().getMethod().equals("CANCEL")) {
            return false;
        }
        ViaList viaHeaders = requestToHeaderTest.getViaHeaders();
        if (viaHeaders != null) {
            ViaHeader topViaHeader = (ViaHeader)viaHeaders.getFirst();
            String messageBranch = topViaHeader.getBranch();
            if (messageBranch != null && !messageBranch.toUpperCase().startsWith("z9hG4bK".toUpperCase())) {
                messageBranch = null;
            }
            if (messageBranch != null && this.getBranch() != null) {
                if (this.getBranch().equals(messageBranch) && topViaHeader.getSentBy().equals(((ViaHeader)this.getOriginalRequest().getViaHeaders().getFirst()).getSentBy())) {
                    transactionMatches = true;
                }
            } else if (this.getOriginalRequest().getRequestURI().equals(requestToHeaderTest.getRequestURI()) && this.getOriginalRequest().getTo().equals(requestToHeaderTest.getTo()) && this.getOriginalRequest().getFromHeader().equals(requestToHeaderTest.getFromHeader()) && this.getOriginalRequest().getCallId().getCallId().equals(requestToHeaderTest.getCallId().getCallId()) && this.getOriginalRequest().getCSeqHeader().getSequenceNumber() == requestToHeaderTest.getCSeqHeader().getSequenceNumber() && topViaHeader.equals(this.getOriginalRequest().getViaHeaders().getFirst())) {
                transactionMatches = true;
            }
        }
        return transactionMatches;
    }

    public boolean passToListener() {
        return this.toListener;
    }

    public void close() {
        this.encapsulatedChannel.close();
    }

    public boolean isSecure() {
        return this.encapsulatedChannel.isSecure();
    }

    public MessageProcessor getMessageProcessor() {
        return this.encapsulatedChannel.getMessageProcessor();
    }

    public void setAckSeen() {
        this.ackSeenFlag = true;
    }

    public boolean isAckSeen() {
        return this.ackSeenFlag;
    }

    protected void buildRouteSet(Request request) throws SipException {
        Message origMsg = this.lastResponse;
        boolean isServer = false;
        Dialog dlg = this.getDialog();
        if (dlg != null) {
            Transaction firstTransaction = dlg.getFirstTransaction();
            if (dlg.isServer()) {
                origMsg = firstTransaction.getOriginalRequest();
                isServer = true;
            } else {
                origMsg = firstTransaction.getLastResponse();
            }
        } else if (this instanceof ServerTransaction) {
            origMsg = this.getOriginalRequest();
            isServer = true;
        }
        RecordRouteList recordRouteList = origMsg.getRecordRouteHeaders();
        ContactList cl = origMsg.getContactHeaders();
        if (cl == null) {
            return;
        }
        ContactHeader contact = (ContactHeader)cl.getFirst();
        if (recordRouteList == null) {
            URI remoteTarget = contact.getAddress().getURI();
            request.setRequestURI(remoteTarget);
        } else {
            request.removeHeader("Route");
            RouteList routeList = new RouteList();
            Vector li = recordRouteList.getHeaders();
            int recSize = li.size();
            for (int i = 0; i < recSize; ++i) {
                int j = i;
                if (!isServer) {
                    j = recSize - i - 1;
                }
                RecordRouteHeader rr = (RecordRouteHeader)li.elementAt(j);
                Address addr = rr.getAddress();
                RouteHeader route = new RouteHeader();
                route.setAddress((Address)rr.getAddress().clone());
                route.setParameters((NameValueList)rr.getParameters().clone());
                routeList.add(route);
            }
            RouteHeader firstRoute = (RouteHeader)routeList.getFirst();
            if (!((SipURI)firstRoute.getAddress().getURI()).hasLrParam()) {
                RouteHeader route = new RouteHeader();
                route.setAddress((Address)contact.getAddress().clone());
                routeList.removeFirst();
                URI uri = firstRoute.getAddress().getURI();
                request.setRequestURI(uri);
                routeList.add(route);
                request.addHeader(routeList);
            } else {
                URI uri = (URI)contact.getAddress().getURI().clone();
                request.setRequestURI(uri);
                request.addHeader(routeList);
            }
        }
    }
}

