/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.stack;

import com.sun.midp.io.j2me.datagram.Protocol;
import gov.nist.core.ParseException;
import gov.nist.core.Utils;
import gov.nist.siplite.header.CSeqHeader;
import gov.nist.siplite.header.CallIdHeader;
import gov.nist.siplite.header.FromHeader;
import gov.nist.siplite.header.RequestLine;
import gov.nist.siplite.header.StatusLine;
import gov.nist.siplite.header.ToHeader;
import gov.nist.siplite.header.ViaHeader;
import gov.nist.siplite.header.ViaList;
import gov.nist.siplite.message.Message;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.parser.ParseExceptionListener;
import gov.nist.siplite.parser.StringMsgParser;
import gov.nist.siplite.stack.MessageChannel;
import gov.nist.siplite.stack.MessageProcessor;
import gov.nist.siplite.stack.SIPMessageStack;
import gov.nist.siplite.stack.SIPServerException;
import gov.nist.siplite.stack.SIPServerRequestInterface;
import gov.nist.siplite.stack.SIPServerResponseInterface;
import gov.nist.siplite.stack.ServerLog;
import gov.nist.siplite.stack.UDPMessageProcessor;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;

public class UDPMessageChannel
extends MessageChannel
implements ParseExceptionListener,
Runnable {
    protected SIPMessageStack stack;
    private String myAddress;
    private int myPort;
    private String peerAddress;
    private int peerPort;
    private String peerProtocol;
    private String receiverProtocol;
    private byte[] msgBytes;
    private int packetLength;
    private DatagramConnection datagramConnection;
    private Datagram incomingPacket;
    protected static Hashtable duplicates;
    private Message sipMessage;
    private long receptionTime;

    public UDPMessageChannel(Datagram packet, SIPMessageStack sipStack, MessageProcessor messageProcessor) {
        this.incomingPacket = packet;
        this.stack = sipStack;
        String address = packet.getAddress();
        try {
            int firstColon = address.indexOf("://");
            int secondColon = address.indexOf(":", firstColon + 1);
            this.peerAddress = address.substring(firstColon + 3, secondColon);
            String portString = address.substring(secondColon + 1);
            this.peerPort = Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            this.peerPort = -1;
        }
        this.packetLength = packet.getLength();
        byte[] bytes = packet.getData();
        this.msgBytes = new byte[this.packetLength];
        for (int i = 0; i < this.packetLength; ++i) {
            this.msgBytes[i] = bytes[i];
        }
        String msgString = new String(this.msgBytes, 0, this.packetLength);
        this.messageProcessor = messageProcessor;
        this.run();
    }

    public UDPMessageChannel(String targetAddr, int port, SIPMessageStack sipStack, UDPMessageProcessor processor) {
        this.peerPort = port;
        this.peerAddress = targetAddr;
        this.myPort = port;
        this.myAddress = processor.getSIPStack().getHostAddress();
        this.messageProcessor = processor;
        this.peerProtocol = "UDP";
        this.stack = sipStack;
    }

    public void run() {
        block19: {
            Message sipMessage = null;
            StringMsgParser myParser = new StringMsgParser();
            try {
                this.receptionTime = System.currentTimeMillis();
                sipMessage = myParser.parseSIPMessage(this.msgBytes);
            }
            catch (ParseException ex) {
                return;
            }
            if (sipMessage == null) {
                return;
            }
            ViaList viaList = sipMessage.getViaHeaders();
            String address = this.incomingPacket.getAddress();
            try {
                int firstColon = address.indexOf("://");
                int secondColon = address.indexOf(":", firstColon + 1);
                this.peerAddress = address.substring(firstColon + 3, secondColon);
                String senderPortString = address.substring(secondColon + 1);
                this.peerPort = Integer.parseInt(senderPortString);
            }
            catch (NumberFormatException e) {
                this.peerPort = -1;
            }
            if (sipMessage.getFromHeader() == null || sipMessage.getTo() == null || sipMessage.getCallId() == null || sipMessage.getCSeqHeader() == null || sipMessage.getViaHeaders() == null) {
                String badmsg = new String(this.msgBytes);
                this.stack.logBadMessage(badmsg);
                return;
            }
            if (sipMessage instanceof Request) {
                ViaHeader v = (ViaHeader)viaList.first();
                if (v.hasPort()) {
                    if (sipMessage instanceof Request) {
                        this.peerPort = v.getPort();
                    }
                } else {
                    this.peerPort = 5060;
                }
                this.peerProtocol = v.getTransport();
                Request sipRequest = (Request)sipMessage;
                SIPServerRequestInterface sipServerRequest = this.stack.newSIPServerRequest(sipRequest, this);
                if (sipServerRequest == null) {
                    return;
                }
                int stPort = -1;
                try {
                    stPort = this.stack.getPort(this.getTransport());
                    sipServerRequest.processRequest(sipRequest, this);
                    if (!ServerLog.needsLogging(ServerLog.TRACE_MESSAGES)) break block19;
                    if (sipServerRequest.getProcessingInfo() == null) {
                        ServerLog.logMessage(sipMessage, sipRequest.getViaHost() + ":" + sipRequest.getViaPort(), this.stack.getHostAddress() + ":" + stPort, false, new Long(this.receptionTime).toString());
                        break block19;
                    }
                    ServerLog.logMessage(sipMessage, sipRequest.getViaHost() + ":" + sipRequest.getViaPort(), this.stack.getHostAddress() + ":" + stPort, sipServerRequest.getProcessingInfo(), false, new Long(this.receptionTime).toString());
                }
                catch (Exception ex) {
                    if (ex instanceof SIPServerException) {
                        this.handleException((SIPServerException)ex);
                    }
                    break block19;
                }
            }
            Response sipResponse = (Response)sipMessage;
            SIPServerResponseInterface sipServerResponse = this.stack.newSIPServerResponse(sipResponse, this);
            try {
                if (sipServerResponse != null) {
                    sipServerResponse.processResponse(sipResponse, this);
                }
            }
            catch (Exception ex) {
                if (ServerLog.needsLogging(ServerLog.TRACE_MESSAGES)) {
                    this.logResponse(sipResponse, this.receptionTime, ex.getMessage() + "-- Dropped!");
                }
                ServerLog.logException(ex);
            }
        }
    }

    public void sendMessage(Message sipMessage) throws IOException {
        byte[] msg = sipMessage.encodeAsBytes();
        this.sendMessage(msg, this.peerAddress, this.peerPort, this.peerProtocol);
    }

    protected void sendMessage(byte[] msg, String receiverAddress, int receiverPort) throws IOException {
        if (receiverPort == -1) {
            throw new IOException("Receiver port not set ");
        }
        try {
            String url = "//" + this.peerAddress + ":" + this.peerPort;
            Protocol conn = new Protocol();
            this.datagramConnection = (DatagramConnection)conn.openPrim(this.stack.getSecurityToken(), url, 2, true);
            Datagram reply = this.datagramConnection.newDatagram(msg, msg.length);
            this.datagramConnection.send(reply);
            String msgString = new String(msg, 0, msg.length);
            this.datagramConnection.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    protected void sendMessage(byte[] msg, String receiverAddress, int receiverPort, String receiverProtocol) throws IOException {
        if (receiverPort == -1) {
            throw new IOException("Receiver port not set ");
        }
        if (Utils.compareToIgnoreCase(receiverProtocol, "UDP") == 0) {
            try {
                String url = "//" + receiverAddress + ":" + receiverPort;
                Protocol conn = new Protocol();
                this.datagramConnection = (DatagramConnection)conn.openPrim(this.stack.getSecurityToken(), url, 2, true);
                Datagram datagram = this.datagramConnection.newDatagram(msg, msg.length);
                this.datagramConnection.send(datagram);
                String msgString = new String(msg, 0, msg.length);
                this.datagramConnection.close();
            }
            catch (IOException ex) {}
        } else {
            throw new IOException("Unsupported protocol");
        }
    }

    public SIPMessageStack getSIPStack() {
        return this.stack;
    }

    public String getTransport() {
        return "udp";
    }

    public String getHost() {
        return this.stack.stackAddress;
    }

    public int getPort() {
        return this.myPort;
    }

    public void handleException(SIPServerException ex) {
        int rc = ex.getRC();
        Request request = (Request)ex.getSIPMessage();
        String msgString = ex.getMessage();
        if (rc != 0) {
            Response response = request.createResponse(rc, msgString);
            try {
                this.sendMessage(response);
            }
            catch (IOException ioex) {
                ServerLog.logException(ioex);
            }
        } else {
            try {
                this.sendMessage(msgString);
            }
            catch (IOException ioex) {
                ServerLog.logException(ioex);
            }
        }
    }

    public boolean equals(Object other) {
        boolean retval;
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            retval = false;
        } else {
            UDPMessageChannel that = (UDPMessageChannel)other;
            retval = this.peerAddress.equals(that.peerAddress);
        }
        return retval;
    }

    public String getKey() {
        return this.myAddress + ":" + this.myPort + "/UDP";
    }

    private void sendMessage(String msg) throws IOException {
        this.sendMessage(msg.getBytes(), this.peerAddress, this.peerPort, this.peerProtocol);
    }

    private void sendMessage(byte[] msg) throws IOException {
        this.sendMessage(msg, this.peerAddress, this.peerPort, this.peerProtocol);
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public boolean isReliable() {
        return false;
    }

    public void close() {
    }

    public String getPeerAddress() {
        return this.peerAddress;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public boolean isSecure() {
        return false;
    }

    public void handleException(ParseException ex, Message sipMessage, Class hdrClass, String headerText, String messageText) throws ParseException {
        if (hdrClass.equals(FromHeader.clazz) || hdrClass.equals(ToHeader.clazz) || hdrClass.equals(CSeqHeader.clazz) || hdrClass.equals(ViaHeader.clazz) || hdrClass.equals(CallIdHeader.clazz) || hdrClass.equals(RequestLine.clazz) || hdrClass.equals(StatusLine.clazz)) {
            this.stack.logBadMessage(messageText);
            throw ex;
        }
        sipMessage.addUnparsed(headerText);
    }
}

