/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.stack;

import com.sun.midp.io.j2me.datagram.Protocol;
import gov.nist.core.HostPort;
import gov.nist.siplite.stack.MessageChannel;
import gov.nist.siplite.stack.MessageProcessor;
import gov.nist.siplite.stack.SIPMessageStack;
import gov.nist.siplite.stack.UDPMessageChannel;
import java.io.IOException;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;

public class UDPMessageProcessor
extends MessageProcessor
implements Runnable {
    private boolean running;
    protected static final int MAX_DATAGRAM_SIZE = 1500;
    private SIPMessageStack sipStack;
    private DatagramConnection dc = null;
    int port;
    private Thread thread;

    protected UDPMessageProcessor(SIPMessageStack sipStack, int port) {
        this.sipStack = sipStack;
        this.port = port;
    }

    public synchronized void start() {
        if (this.dc != null) {
            return;
        }
        Protocol conn = new Protocol();
        try {
            this.dc = (DatagramConnection)conn.openPrim(this.sipStack.getSecurityToken(), "//:" + this.port, 3, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.dc != null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public synchronized void stop() {
        block5: {
            try {
                if (this.dc == null) break block5;
                this.dc.close();
                if (this.thread != null && this.thread.isAlive()) {
                    try {
                        this.thread.join();
                    }
                    catch (InterruptedException exc) {
                        // empty catch block
                    }
                    this.thread = null;
                }
                this.dc = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void run() {
        try {
            while (true) {
                Datagram datagram = this.dc.newDatagram(1500);
                this.dc.receive(datagram);
                UDPMessageChannel uDPMessageChannel = new UDPMessageChannel(datagram, this.sipStack, this);
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    public String getTransport() {
        return "udp";
    }

    public int getPort() {
        return this.port;
    }

    public SIPMessageStack getSipStack() {
        return this.sipStack;
    }

    public MessageChannel createMessageChannel(HostPort targetHostPort) {
        return new UDPMessageChannel(targetHostPort.getHost().getHostname(), targetHostPort.getPort(), this.sipStack, this);
    }

    public MessageChannel createMessageChannel(String host, int port) {
        return new UDPMessageChannel(host, port, this.sipStack, this);
    }

    public boolean isSecure() {
        return false;
    }

    public SIPMessageStack getSIPStack() {
        return this.sipStack;
    }
}

