/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.stack.authentication;

import gov.nist.core.ParseException;
import gov.nist.core.Utils;
import gov.nist.siplite.AuthenticationListener;
import gov.nist.siplite.SipStack;
import gov.nist.siplite.header.AuthenticationHeader;
import gov.nist.siplite.header.AuthorizationHeader;
import gov.nist.siplite.header.CSeqHeader;
import gov.nist.siplite.header.ProxyAuthenticateHeader;
import gov.nist.siplite.header.ProxyAuthorizationHeader;
import gov.nist.siplite.header.WWWAuthenticateHeader;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.parser.Lexer;
import gov.nist.siplite.stack.authentication.Credentials;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.sip.SipException;

public class DigestClientAuthentication
implements AuthenticationListener {
    private static final String MD5 = "MD5";
    private static final String MD5_SESS = "MD5-sess";
    private String realm;
    private String algorithm;
    private String uri;
    private String nonce;
    private String method;
    private String cnonce;
    private String qop;
    private String nonceCountPar;
    private Vector credentials;
    private static final char[] toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public DigestClientAuthentication(Vector credentials) {
        this.credentials = credentials;
    }

    public ProxyAuthorizationHeader createProxyAuthorizationHeader(String scheme) throws ParseException {
        if (scheme == null) {
            throw new NullPointerException("bad scheme arg");
        }
        ProxyAuthorizationHeader p = new ProxyAuthorizationHeader();
        p.setScheme(scheme);
        return p;
    }

    public AuthorizationHeader createAuthorizationHeader(String scheme) throws ParseException {
        if (scheme == null) {
            throw new NullPointerException("null arg scheme ");
        }
        AuthorizationHeader auth = new AuthorizationHeader();
        auth.setScheme(scheme);
        return auth;
    }

    public static String toHexString(byte[] b) {
        int pos = 0;
        char[] c = new char[b.length * 2];
        for (int i = 0; i < b.length; ++i) {
            c[pos++] = toHex[b[i] >> 4 & 0xF];
            c[pos++] = toHex[b[i] & 0xF];
        }
        return new String(c);
    }

    public Request createNewRequest(SipStack sipStack, Request originalRequest, Response response, int count) {
        Throwable ex = null;
        try {
            String digestResponse;
            Request newRequest = (Request)originalRequest.clone();
            CSeqHeader cseqHeader = newRequest.getCSeqHeader();
            cseqHeader.setSequenceNumber(cseqHeader.getSequenceNumber() + 1);
            ProxyAuthenticateHeader proxyAuthHeader = (ProxyAuthenticateHeader)response.getHeader("Proxy-Authenticate");
            WWWAuthenticateHeader wwwAuthenticateHeader = (WWWAuthenticateHeader)response.getHeader("WWW-Authenticate");
            cseqHeader = response.getCSeqHeader();
            this.method = cseqHeader.getMethod();
            this.uri = originalRequest.getRequestURI().toString();
            String opaque = null;
            if (proxyAuthHeader == null) {
                if (wwwAuthenticateHeader == null) {
                    return null;
                }
                this.algorithm = wwwAuthenticateHeader.getAlgorithm();
                this.nonce = wwwAuthenticateHeader.getNonce();
                this.realm = wwwAuthenticateHeader.getRealm();
                if (this.realm == null) {
                    return null;
                }
                this.qop = wwwAuthenticateHeader.getParameter("qop");
                opaque = wwwAuthenticateHeader.getParameter("opaque");
            } else {
                this.algorithm = proxyAuthHeader.getAlgorithm();
                this.nonce = proxyAuthHeader.getNonce();
                this.realm = proxyAuthHeader.getRealm();
                if (this.realm == null) {
                    return null;
                }
                this.qop = proxyAuthHeader.getParameter("qop");
                opaque = proxyAuthHeader.getParameter("opaque");
            }
            if (this.algorithm == null) {
                this.algorithm = MD5;
            }
            if (!this.algorithm.equalsIgnoreCase(MD5) && !this.algorithm.equalsIgnoreCase(MD5_SESS)) {
                return null;
            }
            Credentials credentials = this.getCredentials(this.realm);
            if (credentials == null) {
                return null;
            }
            if (this.nonce == null) {
                this.nonce = "";
            }
            String digestEntityBody = null;
            if (this.qop != null) {
                this.cnonce = DigestClientAuthentication.toHexString(Utils.digest(("" + System.currentTimeMillis() + ":ETag:" + credentials.getPassword()).getBytes()));
                if (this.qop.equalsIgnoreCase("auth-int")) {
                    String entityBody = new String(originalRequest.getRawContent());
                    if (entityBody == null) {
                        entityBody = "";
                    }
                    digestEntityBody = DigestClientAuthentication.toHexString(Utils.digest(entityBody.getBytes()));
                }
            }
            AuthenticationHeader header = null;
            header = proxyAuthHeader == null ? this.createAuthorizationHeader("Digest") : this.createProxyAuthorizationHeader("Digest");
            header.setParameter("username", credentials.getUserName());
            header.setParameter("realm", this.realm);
            header.setParameter("uri", this.uri);
            header.setParameter("algorithm", this.algorithm);
            header.setParameter("nonce", this.nonce);
            if (this.qop != null) {
                Lexer qopLexer = new Lexer("qop", this.qop);
                boolean foundAuth = false;
                while (qopLexer.lookAhead(0) != '\u0000') {
                    String currToken = qopLexer.byteStringNoComma().toLowerCase();
                    if (!currToken.equals("auth") && !currToken.equals("auth-int")) continue;
                    foundAuth = true;
                    this.qop = currToken;
                    break;
                }
                if (!foundAuth) {
                    return null;
                }
                header.setParameter("qop", this.qop);
                header.setParameter("cnonce", this.cnonce);
                String nonceCount = Integer.toHexString(count);
                this.nonceCountPar = "";
                int lengthNonceCount = nonceCount.length();
                if (lengthNonceCount < 8) {
                    for (int i = lengthNonceCount; i < 8; ++i) {
                        this.nonceCountPar = this.nonceCountPar + "0";
                    }
                }
                this.nonceCountPar = this.nonceCountPar + nonceCount;
                header.setParameter("nc", this.nonceCountPar);
            }
            if ((digestResponse = this.generateResponse(credentials.getUserName(), credentials.getPassword(), digestEntityBody)) == null) {
                return null;
            }
            header.setParameter("response", digestResponse);
            if (opaque != null) {
                header.setParameter("opaque", opaque);
            }
            newRequest.setHeader(header);
            return newRequest;
        }
        catch (ParseException pe) {
            ex = pe;
        }
        catch (SipException se) {
            ex = se;
        }
        if (ex != null) {
            // empty if block
        }
        return null;
    }

    private String generateResponse(String userName, String password, String digestEntityBody) {
        if (userName == null) {
            return null;
        }
        if (this.realm == null) {
            return null;
        }
        if (password == null) {
            return null;
        }
        if (this.method == null) {
            return null;
        }
        if (this.uri == null) {
            return null;
        }
        if (this.nonce == null) {
            return null;
        }
        String A1 = userName + ":" + this.realm + ":" + password;
        if (this.algorithm.equalsIgnoreCase(MD5_SESS)) {
            byte[] A1bytes = Utils.digest(A1.getBytes());
            byte[] tmp = (":" + this.nonce + ":" + this.cnonce).getBytes();
            byte[] join = new byte[A1bytes.length + tmp.length];
            System.arraycopy(A1bytes, 0, join, 0, A1bytes.length);
            System.arraycopy(tmp, 0, join, A1bytes.length, tmp.length);
            A1 = new String(join);
        }
        String A2 = this.method.toUpperCase() + ":" + this.uri;
        if (this.qop != null && this.qop.equalsIgnoreCase("auth-int")) {
            A2 = A2 + ":" + digestEntityBody;
        }
        byte[] mdbytes = Utils.digest(A1.getBytes());
        String HA1 = DigestClientAuthentication.toHexString(mdbytes);
        mdbytes = Utils.digest(A2.getBytes());
        String HA2 = DigestClientAuthentication.toHexString(mdbytes);
        String KD = HA1 + ":" + this.nonce;
        if (this.qop != null) {
            KD = KD + ":" + this.nonceCountPar + ":" + this.cnonce + ":" + this.qop;
        }
        KD = KD + ":" + HA2;
        mdbytes = Utils.digest(KD.getBytes());
        String response = DigestClientAuthentication.toHexString(mdbytes);
        return response;
    }

    public Credentials getCredentials(String realm) {
        Enumeration e = this.credentials.elements();
        while (e.hasMoreElements()) {
            Credentials credentials = (Credentials)e.nextElement();
            if (!credentials.getRealm().equals(realm)) continue;
            return credentials;
        }
        return null;
    }
}

