/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.sun.midp.lcdui.Resource;
import com.sun.midp.lcdui.Text;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Screen;

public class Alert
extends Screen {
    public static final int FOREVER = -2;
    public static final Command DISMISS_COMMAND = new Command("", 4, 0);
    CommandListener implicitListener = new CommandListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandAction(Command c, Displayable s) {
            if (Alert.this.userCommandListener != null) {
                if (c == OK) {
                    c = DISMISS_COMMAND;
                }
                Alert.this.userCommandListener.commandAction(c, s);
            } else {
                Object object = Display.LCDUILock;
                synchronized (object) {
                    Alert.this.currentDisplay.clearAlert(Alert.this.returnScreen);
                }
            }
        }
    };
    private static final Command OK = new Command(Resource.getString("Done"), 4, 0);
    private static final int CELL_SPACING = 6;
    private static final int SCROLL_AMOUNT = 40;
    private static final int DEFAULT_TIMEOUT = 2000;
    private AlertType type;
    private String text;
    private Image image;
    private Image mutableImage;
    private Image copyImg = null;
    private int origImgHeight;
    private int origImgWidth;
    private Gauge indicator;
    private int time;
    private int height;
    private static Timer timeoutTimer;
    private TimerTask timerTask;
    private Displayable returnScreen;
    private CommandListener userCommandListener;

    public Alert(String title) {
        this(title, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Alert(String title, String alertText, Image alertImage, AlertType alertType) {
        super(title);
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.time = 2000;
            this.text = alertText;
            this.type = alertType;
            this.setImageImpl(alertImage);
        }
        this.layout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDefaultTimeout() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            return 2000;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTimeout() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.height > this.viewport[3] || this.getCommandCount() > 1) {
                return -2;
            }
            return this.time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(int time) {
        if (time <= 0 && time != -2) {
            throw new IllegalArgumentException();
        }
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.time = time;
            if (this.timerTask != null) {
                try {
                    this.timerTask.cancel();
                    if (time == -2) {
                        this.timerTask = null;
                    } else {
                        this.timerTask = new timeoutTask(this);
                        timeoutTimer.schedule(this.timerTask, time);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public AlertType getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(AlertType type) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.type = type;
        }
    }

    public String getString() {
        return this.text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(String str) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.text = str;
            this.layout();
            if (this.isShown()) {
                this.repaintContents();
            }
            if (this.height > this.viewport[3]) {
                this.setTimeout(-2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.mutableImage != null) {
                return this.mutableImage;
            }
            return this.image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(Image img) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setImageImpl(img);
            this.layout();
            if (this.isShown()) {
                this.repaintContents();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndicator(Gauge indicator) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (indicator == null) {
                if (this.indicator != null) {
                    this.indicator.setOwner(null);
                }
            } else {
                if (!this.isConformantIndicator(indicator)) {
                    throw new IllegalArgumentException("Gauge in wrong state");
                }
                indicator.setOwner(this);
            }
            if (this.indicator != null) {
                this.indicator.setOwner(null);
            }
            this.indicator = indicator;
            this.layout();
            if (this.isShown()) {
                this.repaintContents();
            }
        }
    }

    public Gauge getIndicator() {
        return this.indicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(Command cmd) {
        if (cmd == null) {
            throw new NullPointerException();
        }
        if (cmd == DISMISS_COMMAND) {
            return;
        }
        Object object = Display.LCDUILock;
        synchronized (object) {
            super.addCommandImpl(cmd);
            if (this.getCommandCount() > 1) {
                this.setTimeout(-2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommand(Command cmd) {
        if (cmd == DISMISS_COMMAND) {
            return;
        }
        Object object = Display.LCDUILock;
        synchronized (object) {
            super.removeCommandImpl(cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommandListener(CommandListener l) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.userCommandListener = l;
        }
    }

    void callShowNotify(Display d) {
        super.callShowNotify(d);
        if (this.type != null) {
            d.emuPlayAlertSound(this.type);
        }
        this.layout();
        int timeout = this.getTimeout();
        if (timeout == -2) {
            if (this.getCommandCount() == 0) {
                super.addCommandImpl(OK);
            }
        } else {
            if (timeoutTimer == null) {
                timeoutTimer = new Timer();
            }
            this.timerTask = new timeoutTask(this);
            timeoutTimer.schedule(this.timerTask, timeout);
        }
        super.setCommandListener(this.implicitListener);
    }

    void callHideNotify(Display d) {
        super.callHideNotify(d);
        super.removeCommandImpl(OK);
        super.setCommandListener(null);
        if (this.timerTask != null) {
            try {
                this.timerTask.cancel();
                this.timerTask = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void setImageImpl(Image img) {
        if (img != null) {
            this.origImgWidth = img.width;
            this.origImgHeight = img.height;
        }
        if (img != null && img.isMutable()) {
            if (this.copyImg == null || img.width > this.copyImg.width || img.height > this.copyImg.height) {
                this.copyImg = Image.createImage(img.width, img.height);
            }
            Graphics g = this.copyImg.getGraphics();
            g.drawImage(img, 0, 0, 20);
            this.image = this.copyImg;
            this.mutableImage = img;
        } else {
            this.image = img;
            this.mutableImage = null;
        }
    }

    void callPaint(Graphics g, Object target) {
        int tX;
        super.callPaint(g, target);
        int yOffset = (this.viewport[3] - this.height) / 2;
        if (yOffset < 0) {
            yOffset = 0;
        }
        yOffset += this.viewport[1] - this.view[1];
        int xOffset = this.viewport[0] - this.view[0];
        if (this.image != null) {
            tX = (this.viewport[2] - this.origImgWidth) / 2;
            if (tX < 0) {
                tX = 0;
            }
            g.translate(tX += xOffset, yOffset);
            g.drawRegion(this.image, 0, 0, this.origImgWidth, this.origImgHeight, 0, 0, 0, 20);
            g.translate(-tX, -yOffset);
            yOffset += this.origImgHeight + 6;
        }
        if (this.indicator != null) {
            tX = this.indicator.bounds[0] + xOffset;
            g.translate(tX, yOffset);
            this.indicator.callPaint(g, this.viewport[2], this.viewport[3]);
            g.translate(-tX, -yOffset);
            yOffset += this.indicator.bounds[3] + 6;
        }
        if (this.text != null) {
            g.translate(xOffset, yOffset);
            Text.paint(this.text, Screen.CONTENT_FONT, g, this.viewport[2] - xOffset, this.viewport[3] + this.viewport[1] - yOffset, 0, 0, null);
            g.translate(-xOffset, -yOffset);
        }
        this.setVerticalScroll();
    }

    void layout() {
        super.layout();
        int n = this.height = this.image != null ? this.origImgHeight + 6 : 0;
        if (this.indicator != null) {
            if (this.indicator.bounds == null) {
                this.indicator.bounds = new int[4];
            }
            int pW = this.indicator.callPreferredWidth(-1);
            int pH = this.indicator.callPreferredHeight(-1);
            int xOffset = (this.viewport[2] - pW) / 2;
            if (xOffset < 0) {
                xOffset = 0;
            }
            this.indicator.bounds[0] = xOffset;
            this.indicator.bounds[1] = this.height;
            this.indicator.bounds[2] = pW;
            this.indicator.bounds[3] = pH;
            this.height += pH + 6;
        }
        this.height += Text.getHeightForWidth(this.text, Screen.CONTENT_FONT, this.viewport[2], 0);
        if (this.indicator != null && this.height < this.viewport[3]) {
            this.indicator.bounds[1] = this.indicator.bounds[1] + (this.viewport[3] - this.height) / 2;
        }
        this.view[3] = this.height;
    }

    void setReturnScreen(Displayable d) {
        this.returnScreen = d != null ? d : new Form("");
    }

    boolean isConformantIndicator(Gauge ind) {
        return !ind.isInteractive() && ind.getOwner() == null && ind.getCommandCount() == 0 && ind.getItemCommandListener() == null && ind.getLabel() == null && ind.getLayout() == 0 && ind.lockedWidth == -1 && ind.lockedHeight == -1;
    }

    void callKeyPressed(int keyCode) {
        int gameAction = Display.getGameAction(keyCode);
        switch (gameAction) {
            case 1: 
            case 6: {
                if (!this.scrollViewport(gameAction)) break;
                this.repaintContents();
                break;
            }
        }
    }

    void callKeyRepeated(int keyCode) {
        this.callKeyPressed(keyCode);
    }

    boolean scrollViewport(int dir) {
        if (dir == 6 && this.view[1] + this.viewport[3] < this.height) {
            this.view[1] = this.view[1] + 40;
            return true;
        }
        if (dir == 1 && this.view[1] > 0) {
            this.view[1] = this.view[1] - 40;
            return true;
        }
        return false;
    }

    class timeoutTask
    extends TimerTask {
        Displayable alert;

        public timeoutTask(Displayable d) {
            this.alert = d;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = Display.LCDUILock;
            synchronized (object) {
                Command[] cmds = Alert.this.getCommands();
                Command c = cmds == null ? DISMISS_COMMAND : cmds[0];
                try {
                    Object object2 = Display.calloutLock;
                    synchronized (object2) {
                        Alert.this.implicitListener.commandAction(c, this.alert);
                    }
                }
                catch (Throwable thr) {
                    Display.handleThrowable(thr);
                }
            }
        }
    }
}

