/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.MMHelperImpl;

public abstract class Canvas
extends Displayable {
    public static final int UP = 1;
    public static final int DOWN = 6;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int FIRE = 8;
    public static final int GAME_A = 9;
    public static final int GAME_B = 10;
    public static final int GAME_C = 11;
    public static final int GAME_D = 12;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_STAR = 42;
    public static final int KEY_POUND = 35;
    private boolean suppressKeyEvents;
    private static MMHelperImpl mmHelper = new MMHelperImpl();
    private Vector embeddedVideos = new Vector(1);

    protected Canvas() {
    }

    public boolean isDoubleBuffered() {
        return Display.IS_DOUBLE_BUFFERED;
    }

    public boolean hasPointerEvents() {
        return Display.POINTER_SUPPORTED;
    }

    public boolean hasPointerMotionEvents() {
        return Display.MOTION_SUPPORTED;
    }

    public boolean hasRepeatEvents() {
        return Display.REPEAT_SUPPORTED;
    }

    public int getKeyCode(int gameAction) {
        int n = Display.getKeyCode(gameAction);
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        return n;
    }

    public String getKeyName(int keyCode) {
        String s = Display.getKeyName(keyCode);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return s;
    }

    public int getGameAction(int keyCode) {
        int n = Display.getGameAction(keyCode);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFullScreenMode(boolean mode) {
        if (mode == this.fullScreenMode) {
            return;
        }
        super.grabFullScreen(mode);
        Object object = Display.LCDUILock;
        synchronized (object) {
            super.fullScreenMode(mode);
        }
    }

    protected void keyPressed(int keyCode) {
    }

    protected void keyRepeated(int keyCode) {
    }

    protected void keyReleased(int keyCode) {
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
    }

    protected void pointerDragged(int x, int y) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void repaint(int x, int y, int width, int height) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.callRepaint(x + this.viewport[0], y + this.viewport[1], width, height, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void repaint() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.callRepaint(this.viewport[0], this.viewport[1], this.viewport[2], this.viewport[3], null);
        }
    }

    public final void serviceRepaints() {
        Display d = this.currentDisplay;
        if (d != null) {
            d.serviceRepaints(this);
        }
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
    }

    protected abstract void paint(Graphics var1);

    protected void sizeChanged(int w, int h) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callShowNotify(Display d) {
        super.callShowNotify(d);
        super.layout();
        Object object = Display.calloutLock;
        synchronized (object) {
            try {
                this.showNotify();
            }
            catch (Throwable t) {
                Display.handleThrowable(t);
            }
            Enumeration e = this.embeddedVideos.elements();
            while (e.hasMoreElements()) {
                mmHelper.showVideo(e.nextElement());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callHideNotify(Display d) {
        Object object = Display.calloutLock;
        synchronized (object) {
            Enumeration e = this.embeddedVideos.elements();
            while (e.hasMoreElements()) {
                mmHelper.hideVideo(e.nextElement());
            }
            try {
                this.hideNotify();
            }
            catch (Throwable t) {
                Display.handleThrowable(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callPaint(Graphics g, Object target) {
        super.callPaint(g, target);
        if (g.getClipY() + g.getClipHeight() <= this.viewport[1]) {
            return;
        }
        g.clipRect(this.viewport[0], this.viewport[1], this.viewport[2], this.viewport[3]);
        Object object = Display.calloutLock;
        synchronized (object) {
            g.translate(this.viewport[0], this.viewport[1]);
            try {
                this.paint(g);
            }
            catch (Throwable t) {
                Display.handleThrowable(t);
            }
            Enumeration e = this.embeddedVideos.elements();
            while (e.hasMoreElements()) {
                mmHelper.paintVideo(e.nextElement(), g);
            }
            g.translate(-this.viewport[0], -this.viewport[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callSizeChanged(int w, int h) {
        super.callSizeChanged(w, h);
        if (!this.sizeChangeOccurred) {
            Object object = Display.calloutLock;
            synchronized (object) {
                try {
                    this.sizeChanged(w, h);
                }
                catch (Throwable t) {
                    Display.handleThrowable(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callKeyPressed(int keyCode) {
        if (this.allowKey(keyCode)) {
            Object object = Display.calloutLock;
            synchronized (object) {
                try {
                    this.keyPressed(keyCode);
                }
                catch (Throwable t) {
                    Display.handleThrowable(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callKeyReleased(int keyCode) {
        if (this.allowKey(keyCode)) {
            Object object = Display.calloutLock;
            synchronized (object) {
                try {
                    this.keyReleased(keyCode);
                }
                catch (Throwable t) {
                    Display.handleThrowable(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callKeyRepeated(int keyCode) {
        if (this.allowKey(keyCode)) {
            Object object = Display.calloutLock;
            synchronized (object) {
                try {
                    this.keyRepeated(keyCode);
                }
                catch (Throwable t) {
                    Display.handleThrowable(t);
                }
            }
        }
    }

    private boolean allowKey(int keyCode) {
        if (!this.suppressKeyEvents) {
            return true;
        }
        switch (this.getGameAction(keyCode)) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callPointerPressed(int x, int y) {
        Object object = Display.calloutLock;
        synchronized (object) {
            try {
                this.pointerPressed(x - this.viewport[0], y - this.viewport[1]);
            }
            catch (Throwable t) {
                Display.handleThrowable(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callPointerReleased(int x, int y) {
        Object object = Display.calloutLock;
        synchronized (object) {
            try {
                this.pointerReleased(x - this.viewport[0], y - this.viewport[1]);
            }
            catch (Throwable t) {
                Display.handleThrowable(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callPointerDragged(int x, int y) {
        Object object = Display.calloutLock;
        synchronized (object) {
            try {
                this.pointerDragged(x - this.viewport[0], y - this.viewport[1]);
            }
            catch (Throwable t) {
                Display.handleThrowable(t);
            }
        }
    }

    void addEmbeddedVideo(Object video) {
        this.embeddedVideos.addElement(video);
    }

    void removeEmbeddedVideo(Object video) {
        this.embeddedVideos.removeElement(video);
    }

    public void setCommandListener(CommandListener l) {
        super.setCommandListener(l);
        Canvas.commandListenerSet(l != null);
    }

    private static native void commandListenerSet(boolean var0);
}

