/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.sun.midp.lcdui.DisplayManager;
import com.sun.midp.lcdui.DisplayManagerFactory;
import com.sun.midp.lcdui.Text;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImmutableImage;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Screen;

public class ChoiceGroup
extends Item
implements Choice {
    boolean isList;
    private int choiceType;
    private int fitPolicy;
    private int numOfEls;
    private int selectedIndex = -1;
    private int hilightedIndex = -1;
    private boolean[] selEls;
    private String[] stringEls;
    private Image[] imageEls;
    private Image[] mutableImageEls;
    private Font[] fontEls;
    private int[] elHeights;
    private int cachedWidth;
    private static final int DEFAULT_WIDTH = 80;
    private boolean popUpOpen;
    private boolean traversedIn;
    private DisplayManager displayManager;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private int maxPopupWidth = 80;
    private static final int PU_WIN_HEIGHT = 130;
    private static final Image CKBX_OFF_IMG = ImmutableImage.createIcon("checkbox_off.png");
    private static final Image CKBX_ON_IMG = ImmutableImage.createIcon("checkbox_on.png");
    private static final int CKBX_WIDTH = 10;
    private static final int CKBX_HEIGHT = 11;
    private static final Image RD_OFF_IMG = ImmutableImage.createIcon("radio_off.png");
    private static final Image RD_ON_IMG = ImmutableImage.createIcon("radio_on.png");
    private static final int RD_WIDTH = 11;
    private static final int RD_HEIGHT = 11;
    private static final Image POPUP_ARROW_IMG = ImmutableImage.createIcon("popup_arrow.png");
    private static final int POPUP_AR_WIDTH = 11;
    private static final int POPUP_AR_HEIGHT = 11;
    static final int PREFERRED_IMG_W = 16;
    static final int PREFERRED_IMG_H = 16;
    static final int MAX_IMG_W = 24;
    static final int MAX_IMG_H = 24;
    static final int MIN_IMG_W = 12;
    static final int MIN_IMG_H = 12;

    public ChoiceGroup(String label, int choiceType) {
        this(label, choiceType, new String[0], null);
    }

    public ChoiceGroup(String label, int choiceType, String[] stringElements, Image[] imageElements) {
        this(label, choiceType, stringElements, imageElements, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChoiceGroup(String label, int choiceType, String[] stringElements, Image[] imageElements, boolean implicitAllowed) {
        super(label);
        if (this.displayManager == null) {
            this.displayManager = DisplayManagerFactory.getDisplayManager();
        }
        if (!(choiceType == 2 || choiceType == 1 || choiceType == 3 && implicitAllowed || choiceType == 4)) {
            throw new IllegalArgumentException();
        }
        for (int x = 0; x < stringElements.length; ++x) {
            if (stringElements[x] != null) continue;
            throw new NullPointerException();
        }
        if (imageElements != null && stringElements.length != imageElements.length) {
            throw new IllegalArgumentException();
        }
        Object object = Display.LCDUILock;
        synchronized (object) {
            int i;
            this.choiceType = choiceType;
            this.numOfEls = stringElements.length;
            switch (choiceType) {
                case 2: {
                    this.selEls = new boolean[this.numOfEls];
                    for (i = 0; i < this.numOfEls; ++i) {
                        this.selEls[i] = false;
                    }
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    if (this.numOfEls <= 0) break;
                    this.selectedIndex = 0;
                }
            }
            this.stringEls = new String[this.numOfEls];
            System.arraycopy(stringElements, 0, this.stringEls, 0, this.numOfEls);
            if (imageElements != null) {
                this.imageEls = new Image[this.numOfEls];
                this.mutableImageEls = new Image[this.numOfEls];
                for (i = 0; i < this.numOfEls; ++i) {
                    if (imageElements[i] != null && imageElements[i].isMutable()) {
                        this.mutableImageEls[i] = imageElements[i];
                        this.imageEls[i] = Image.createImage(imageElements[i]);
                        continue;
                    }
                    this.imageEls[i] = imageElements[i];
                }
            }
            this.hilightedIndex = 0;
            this.setImageSize();
        }
    }

    public int size() {
        return this.numOfEls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int elementNum) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.checkIndex(elementNum);
            return this.stringEls[elementNum];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(int elementNum) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.checkIndex(elementNum);
            if (this.imageEls != null) {
                if (this.mutableImageEls[elementNum] != null) {
                    return this.mutableImageEls[elementNum];
                }
                return this.imageEls[elementNum];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int append(String stringPart, Image imagePart) {
        int returnVal = -1;
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.checkNull(stringPart, imagePart);
            returnVal = this.insertImpl(this.numOfEls, stringPart, imagePart);
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int elementNum, String stringPart, Image imagePart) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (elementNum < 0 || elementNum > this.numOfEls) {
                throw new IndexOutOfBoundsException();
            }
            this.checkNull(stringPart, imagePart);
            this.insertImpl(elementNum, stringPart, imagePart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int elementNum) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.checkIndex(elementNum);
            if (elementNum != this.numOfEls - 1) {
                System.arraycopy(this.stringEls, elementNum + 1, this.stringEls, elementNum, this.numOfEls - elementNum - 1);
                if (this.imageEls != null) {
                    System.arraycopy(this.imageEls, elementNum + 1, this.imageEls, elementNum, this.numOfEls - elementNum - 1);
                    System.arraycopy(this.mutableImageEls, elementNum + 1, this.mutableImageEls, elementNum, this.numOfEls - elementNum - 1);
                }
                if (this.fontEls != null) {
                    System.arraycopy(this.fontEls, elementNum + 1, this.fontEls, elementNum, this.numOfEls - elementNum - 1);
                }
                if (this.choiceType == 2) {
                    System.arraycopy(this.selEls, elementNum + 1, this.selEls, elementNum, this.numOfEls - elementNum - 1);
                }
            }
            if (this.choiceType == 2) {
                this.selEls[this.numOfEls - 1] = false;
            }
            --this.numOfEls;
            this.stringEls[this.numOfEls] = null;
            if (this.imageEls != null) {
                this.imageEls[this.numOfEls] = null;
                this.mutableImageEls[this.numOfEls] = null;
            }
            if (this.fontEls != null) {
                this.fontEls[this.numOfEls] = null;
            }
            if (this.numOfEls == 0) {
                this.selectedIndex = -1;
                this.hilightedIndex = -1;
            } else {
                if (elementNum < this.hilightedIndex) {
                    --this.hilightedIndex;
                } else if (elementNum == this.hilightedIndex && this.hilightedIndex == this.numOfEls) {
                    this.hilightedIndex = this.numOfEls - 1;
                }
                if (this.choiceType != 2) {
                    if (elementNum < this.selectedIndex) {
                        --this.selectedIndex;
                    } else if (elementNum == this.selectedIndex && this.selectedIndex == this.numOfEls) {
                        this.selectedIndex = this.numOfEls - 1;
                    }
                }
            }
            this.invalidate();
            this.setImageSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            for (int x = 0; x < this.numOfEls; ++x) {
                this.stringEls[x] = null;
                if (this.imageEls != null) {
                    this.imageEls[x] = null;
                    this.mutableImageEls[x] = null;
                }
                if (this.fontEls == null) continue;
                this.fontEls[x] = null;
            }
            this.numOfEls = 0;
            this.selectedIndex = -1;
            this.hilightedIndex = -1;
            this.invalidate();
            this.setImageSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int elementNum, String stringPart, Image imagePart) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.checkIndex(elementNum);
            this.checkNull(stringPart, imagePart);
            this.setImpl(elementNum, stringPart, imagePart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelected(int elementNum) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.checkIndex(elementNum);
            return this.choiceType == 2 ? this.selEls[elementNum] : this.selectedIndex == elementNum;
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSelectedFlags(boolean[] selectedArray_return) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.checkFlag(selectedArray_return);
            int selectedNum = 0;
            if (this.choiceType == 2) {
                int i;
                System.arraycopy(this.selEls, 0, selectedArray_return, 0, this.numOfEls);
                for (i = 0; i < this.numOfEls; ++i) {
                    if (!this.selEls[i]) continue;
                    ++selectedNum;
                }
                for (i = this.numOfEls; i < selectedArray_return.length; ++i) {
                    selectedArray_return[i] = false;
                }
            } else {
                for (int i = 0; i < selectedArray_return.length; ++i) {
                    selectedArray_return[i] = false;
                }
                if (this.selectedIndex != -1) {
                    selectedArray_return[this.selectedIndex] = true;
                    selectedNum = 1;
                }
            }
            return selectedNum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedIndex(int elementNum, boolean selected) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setSelectedIndexImpl(elementNum, selected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedFlags(boolean[] selectedArray) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.checkFlag(selectedArray);
            if (this.numOfEls == 0) {
                return;
            }
            if (this.choiceType == 2) {
                System.arraycopy(selectedArray, 0, this.selEls, 0, this.numOfEls);
            } else {
                int i;
                for (i = 0; i < this.numOfEls && !selectedArray[i]; ++i) {
                }
                if (i == this.numOfEls) {
                    i = 0;
                }
                this.setSelectedIndexImpl(i, true);
            }
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFitPolicy(int fitPolicy) {
        if (fitPolicy < 0 || fitPolicy > 2) {
            throw new IllegalArgumentException();
        }
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.fitPolicy != fitPolicy) {
                this.fitPolicy = fitPolicy;
                this.invalidate();
            }
        }
    }

    public int getFitPolicy() {
        return this.fitPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(int elementNum, Font font) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.checkIndex(elementNum);
            if (this.fontEls == null) {
                this.fontEls = new Font[this.numOfEls];
            }
            this.fontEls[elementNum] = font;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont(int elementNum) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.checkIndex(elementNum);
            if (this.fontEls != null && this.fontEls[elementNum] != null) {
                return this.fontEls[elementNum];
            }
            return Screen.CONTENT_FONT;
        }
    }

    boolean equateNLA() {
        if (super.equateNLA()) {
            return true;
        }
        return (this.layout & 0x4000) != 16384;
    }

    boolean equateNLB() {
        if (super.equateNLB()) {
            return true;
        }
        return (this.layout & 0x4000) != 16384;
    }

    int callMinimumWidth() {
        int lW = this.getLabelWidth();
        int w = 0;
        int maxElWidth = 0;
        int grWidth = 0;
        if (lW == 0 && this.numOfEls == 0) {
            return 0;
        }
        if (this.choiceType == 1) {
            grWidth = 13;
        } else if (this.choiceType == 2) {
            grWidth = 12;
        }
        if (this.choiceType == 4) {
            this.maxPopupWidth = maxElWidth = this.getMaxElementWidth(grWidth);
        }
        w = lW;
        if (this.choiceType == 4) {
            if (w > 0) {
                w += 2;
            }
            return (w += 13 + maxElWidth) > Item.DEFAULT_WIDTH ? Item.DEFAULT_WIDTH : w;
        }
        maxElWidth = this.getMaxElementWidth(grWidth);
        if (w < grWidth + maxElWidth) {
            w = grWidth + maxElWidth;
        }
        return w < 80 ? w : 80;
    }

    int callPreferredWidth(int h) {
        if (this.isList) {
            return 500;
        }
        int minWidth = this.callMinimumWidth();
        if (this.layout == 0 || this.equateNLB() && this.equateNLA()) {
            int availWidth = this.owner != null ? ((Form)this.owner).getWidth() : Item.DEFAULT_WIDTH;
            return minWidth > availWidth ? minWidth : availWidth;
        }
        return minWidth;
    }

    int callMinimumHeight() {
        return this.callPreferredHeight(this.callMinimumWidth());
    }

    int callPreferredHeight(int width) {
        if (width == -1) {
            width = this.callPreferredWidth(-1);
        }
        if (width == 0) {
            return 0;
        }
        int lH = this.getLabelHeight(width);
        if (this.choiceType == 1) {
            width -= 13;
        } else if (this.choiceType == 2) {
            width -= 12;
        }
        int eHeight = this.calculateElementHeight(width);
        if (lH == 0) {
            if (eHeight == 0) {
                return 0;
            }
        } else {
            lH += 2;
        }
        if (this.choiceType == 4) {
            if (eHeight > 0) {
                eHeight = this.elHeights[this.selectedIndex == -1 ? 0 : this.selectedIndex];
            }
            if (lH <= LABEL_HEIGHT) {
                return eHeight > LABEL_HEIGHT - 2 ? eHeight : LABEL_HEIGHT;
            }
        }
        return lH + eHeight;
    }

    void callPaint(Graphics g, int w, int h) {
        int labelHeight = super.paintLabel(g, w);
        if (this.numOfEls == 0 && this.choiceType != 4) {
            return;
        }
        int translatedX = 0;
        int translatedY = 0;
        if (this.choiceType == 4) {
            int elWidth;
            if (labelHeight > LABEL_HEIGHT) {
                translatedY = labelHeight;
            } else {
                translatedX = this.getLabelWidth();
                translatedX = translatedX > 0 ? translatedX + 2 : 0;
            }
            g.drawImage(POPUP_ARROW_IMG, translatedX, translatedY, 20);
            if (this.numOfEls == 0) {
                return;
            }
            translatedX += 13;
            if (this.imageEls != null && this.imageEls[this.selectedIndex] != null) {
                int iX = g.getClipX();
                int iY = g.getClipY();
                int iW = g.getClipWidth();
                int iH = g.getClipHeight();
                g.clipRect(translatedX, translatedY, this.imageWidth, this.imageHeight);
                g.drawImage(this.imageEls[this.selectedIndex], translatedX, translatedY, 20);
                g.setClip(iX, iY, iW, iH);
            }
            if ((elWidth = w) != this.cachedWidth) {
                this.calculateElementHeight(elWidth);
            }
            elWidth -= 13;
            Font fnt = this.fontEls != null && this.fontEls[this.selectedIndex] != null ? this.fontEls[this.selectedIndex] : Screen.CONTENT_FONT;
            g.translate(translatedX, translatedY);
            int textOffset = 0;
            if (this.imageEls != null && this.imageEls[this.selectedIndex] != null) {
                textOffset = this.imageWidth + 2;
            }
            if (this.hasFocus) {
                g.fillRect(textOffset, 0, g.getClipWidth() - textOffset, this.elHeights[this.selectedIndex]);
                if (textOffset != 0 && this.elHeights[this.selectedIndex] > textOffset) {
                    g.fillRect(0, textOffset, textOffset, this.elHeights[this.selectedIndex] - textOffset);
                }
                Text.paint(this.stringEls[this.selectedIndex], fnt, g, elWidth, this.elHeights[this.selectedIndex], textOffset, 5, null);
            } else {
                Text.paint(this.stringEls[this.selectedIndex], fnt, g, elWidth, this.elHeights[this.selectedIndex], textOffset, 4, null);
            }
            g.translate(-translatedX, -translatedY);
        } else {
            translatedY = labelHeight;
            if (labelHeight > 0) {
                translatedY += 2;
            }
            g.translate(0, translatedY);
            this.paintElements(g, w);
            g.translate(0, -translatedY);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean callTraverse(int dir, int viewportWidth, int viewportHeight, int[] visRect) {
        super.callTraverse(dir, viewportWidth, viewportHeight, visRect);
        if (this.numOfEls == 0) {
            return false;
        }
        if (this.choiceType == 4 && !this.popUpOpen) {
            if (this.traversedIn) return false;
            this.traversedIn = true;
            return true;
        }
        int lh = this.getLabelHeight(visRect[2]);
        visRect[1] = lh > 0 ? lh + 2 : 0;
        for (int i = 0; i < this.hilightedIndex; ++i) {
            visRect[1] = visRect[1] + this.elHeights[i];
        }
        visRect[3] = this.elHeights[this.hilightedIndex];
        if (!this.traversedIn) {
            this.traversedIn = true;
        } else if (dir == 1) {
            if (this.hilightedIndex <= 0) return this.popUpOpen;
            --this.hilightedIndex;
            visRect[1] = visRect[1] - this.elHeights[this.hilightedIndex];
        } else {
            if (dir != 6) return this.popUpOpen;
            if (this.hilightedIndex >= this.numOfEls - 1) return this.popUpOpen;
            visRect[1] = visRect[1] + this.elHeights[this.hilightedIndex];
            ++this.hilightedIndex;
        }
        visRect[3] = this.elHeights[this.hilightedIndex];
        if (this.choiceType == 3) {
            this.selectedIndex = this.hilightedIndex;
        }
        this.repaint();
        return true;
    }

    void callTraverseOut() {
        super.callTraverseOut();
        this.traversedIn = false;
    }

    void callKeyPressed(int keyCode) {
        if (keyCode != Display.KEYCODE_SELECT || this.numOfEls == 0) {
            return;
        }
        switch (this.choiceType) {
            case 4: {
                if (!this.popUpOpen) {
                    this.displayManager.suspendPainting();
                    int lW = this.getLabelWidth();
                    boolean tickerflag = false;
                    boolean titleflag = false;
                    if (this.owner.getTicker() != null) {
                        tickerflag = true;
                    }
                    if (this.owner.getTitle() != null) {
                        titleflag = true;
                    }
                    this.updatePopupElements(this.stringEls, this.imageEls, this.numOfEls, this.selectedIndex, this.bounds[0] + this.owner.viewport[0] - this.owner.view[0] + lW, this.bounds[1] + this.owner.viewport[1] - this.owner.view[1], this.owner.viewport[2], this.owner.viewport[3], this.maxPopupWidth, tickerflag, titleflag);
                    this.popUpOpen = !this.popUpOpen;
                    break;
                }
                this.displayManager.resumePainting();
                this.popUpOpen = !this.popUpOpen;
                int selected = this.getPopupSelection();
                if (selected >= 0) {
                    this.hilightedIndex = selected;
                    this.setSelectedIndexImpl(this.hilightedIndex, true);
                    this.owner.itemStateChanged(this);
                }
                this.invalidate();
                break;
            }
            case 1: {
                if (this.hilightedIndex == this.selectedIndex) {
                    return;
                }
                this.setSelectedIndexImpl(this.hilightedIndex, true);
                this.owner.itemStateChanged(this);
                break;
            }
            case 2: {
                this.setSelectedIndexImpl(this.hilightedIndex, !this.selEls[this.hilightedIndex]);
                this.owner.itemStateChanged(this);
                break;
            }
        }
    }

    int getType() {
        return this.choiceType;
    }

    void setSelectedIndexImpl(int elementNum, boolean selected) {
        this.checkIndex(elementNum);
        switch (this.choiceType) {
            case 3: {
                if (!selected) {
                    return;
                }
                this.selectedIndex = elementNum;
                this.hilightedIndex = elementNum;
                break;
            }
            case 1: 
            case 4: {
                if (this.selectedIndex == elementNum || !selected) {
                    return;
                }
                this.selectedIndex = elementNum;
                break;
            }
            case 2: {
                this.selEls[elementNum] = selected;
            }
        }
        this.repaint();
    }

    boolean shouldSkipTraverse() {
        return (this.label == null || this.label.equals("")) && this.numOfEls == 0;
    }

    private void setImpl(int elementNum, String stringPart, Image imagePart) {
        this.stringEls[elementNum] = stringPart;
        if (imagePart != null && this.imageEls == null) {
            this.imageEls = new Image[this.stringEls.length];
            this.mutableImageEls = new Image[this.stringEls.length];
        }
        if (this.imageEls != null) {
            if (imagePart != null && imagePart.isMutable()) {
                this.mutableImageEls[elementNum] = imagePart;
                this.imageEls[elementNum] = Image.createImage(imagePart);
            } else {
                this.mutableImageEls[elementNum] = null;
                this.imageEls[elementNum] = imagePart;
            }
        }
        this.invalidate();
    }

    private int insertImpl(int elementNum, String stringPart, Image imagePart) {
        if (this.numOfEls == this.stringEls.length) {
            String[] newStrings = new String[this.stringEls.length + 4];
            System.arraycopy(this.stringEls, 0, newStrings, 0, elementNum);
            System.arraycopy(this.stringEls, elementNum, newStrings, elementNum + 1, this.numOfEls - elementNum);
            this.stringEls = newStrings;
            if (this.imageEls != null) {
                Image[] newImages = new Image[this.imageEls.length + 4];
                Image[] newMutableImages = new Image[this.imageEls.length + 4];
                System.arraycopy(this.imageEls, 0, newImages, 0, elementNum);
                System.arraycopy(this.imageEls, elementNum, newImages, elementNum + 1, this.numOfEls - elementNum);
                System.arraycopy(this.mutableImageEls, 0, newMutableImages, 0, elementNum);
                System.arraycopy(this.mutableImageEls, elementNum, newMutableImages, elementNum + 1, this.numOfEls - elementNum);
                this.imageEls = newImages;
                this.mutableImageEls = newMutableImages;
            }
            if (this.fontEls != null) {
                Font[] newFonts = new Font[this.fontEls.length + 4];
                System.arraycopy(this.fontEls, 0, newFonts, 0, elementNum);
                System.arraycopy(this.fontEls, elementNum, newFonts, elementNum + 1, this.numOfEls - elementNum);
            }
        } else {
            System.arraycopy(this.stringEls, elementNum, this.stringEls, elementNum + 1, this.numOfEls - elementNum);
            if (this.imageEls != null) {
                System.arraycopy(this.imageEls, elementNum, this.imageEls, elementNum + 1, this.numOfEls - elementNum);
                System.arraycopy(this.mutableImageEls, elementNum, this.mutableImageEls, elementNum + 1, this.numOfEls - elementNum);
            }
            if (this.fontEls != null) {
                System.arraycopy(this.fontEls, elementNum, this.fontEls, elementNum + 1, this.numOfEls - elementNum);
            }
        }
        if (this.choiceType == 2) {
            if (this.selEls.length == this.numOfEls) {
                boolean[] newSelEls = new boolean[this.numOfEls + 4];
                System.arraycopy(this.selEls, 0, newSelEls, 0, elementNum);
                System.arraycopy(this.selEls, elementNum, newSelEls, elementNum + 1, this.numOfEls - elementNum);
                this.selEls = newSelEls;
            } else {
                System.arraycopy(this.selEls, elementNum, this.selEls, elementNum + 1, this.numOfEls - elementNum);
            }
            this.selEls[elementNum] = false;
        }
        this.stringEls[elementNum] = null;
        if (this.imageEls != null) {
            this.imageEls[elementNum] = null;
            this.mutableImageEls[elementNum] = null;
        }
        if (this.fontEls != null) {
            this.fontEls[elementNum] = null;
        }
        ++this.numOfEls;
        if (this.choiceType != 2 && (elementNum < this.selectedIndex || this.selectedIndex == -1)) {
            ++this.selectedIndex;
            this.hilightedIndex = this.selectedIndex;
        } else if (elementNum < this.hilightedIndex || this.hilightedIndex == -1) {
            ++this.hilightedIndex;
        }
        this.setImpl(elementNum, stringPart, imagePart);
        this.setImageSize();
        return elementNum;
    }

    private void checkIndex(int elementNum) {
        if (elementNum < 0 || elementNum >= this.numOfEls) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkNull(String stringPart, Image imagePart) {
        if (stringPart == null) {
            throw new NullPointerException();
        }
    }

    private void checkFlag(boolean[] flag) {
        if (flag == null) {
            throw new NullPointerException();
        }
        if (flag.length < this.numOfEls) {
            throw new IllegalArgumentException();
        }
    }

    private void paintElements(Graphics g, int w) {
        int elWidth = w;
        int translatedX = 0;
        int translatedY = 0;
        if (this.choiceType == 1) {
            translatedX = 13;
            elWidth -= translatedX;
        } else if (this.choiceType == 2) {
            translatedX = 12;
            elWidth -= translatedX;
        }
        if (elWidth != this.cachedWidth || this.elHeights.length != this.numOfEls) {
            this.calculateElementHeight(elWidth);
        }
        for (int i = 0; i < this.numOfEls; ++i) {
            Image img = this.choiceType == 1 ? (i == this.selectedIndex ? RD_ON_IMG : RD_OFF_IMG) : (this.choiceType == 2 ? (this.selEls[i] ? CKBX_ON_IMG : CKBX_OFF_IMG) : null);
            if (img != null) {
                g.drawImage(img, 0, 0, 20);
                g.translate(translatedX, 0);
            }
            int textOffset = 0;
            if (this.imageEls != null && this.imageEls[i] != null) {
                int iX = g.getClipX();
                int iY = g.getClipY();
                int iW = g.getClipWidth();
                int iH = g.getClipHeight();
                g.clipRect(0, 0, this.imageWidth, this.imageHeight);
                this.clipImage(g, this.imageEls[i]);
                g.setClip(iX, iY, iW, iH);
                textOffset = this.imageWidth + 2;
            }
            Font fnt = this.fontEls != null && this.fontEls[i] != null ? this.fontEls[i] : Screen.CONTENT_FONT;
            int textOffsetHeight = 0;
            if (this.imageHeight > fnt.getHeight()) {
                textOffsetHeight = (this.imageHeight - fnt.getHeight()) / 2;
            }
            if (i == this.hilightedIndex && this.hasFocus) {
                g.fillRect(textOffset, 0, g.getClipWidth() - translatedX - textOffset, this.elHeights[i]);
                if (textOffset != 0 && this.elHeights[i] > textOffset) {
                    g.fillRect(0, textOffset, textOffset, this.elHeights[i] - textOffset);
                }
                g.translate(0, textOffsetHeight);
                Text.paint(this.stringEls[i], fnt, g, elWidth, this.elHeights[i], textOffset, this.fitPolicy == 2 ? 5 : 1, null);
                g.translate(0, -textOffsetHeight);
            } else {
                g.translate(0, textOffsetHeight);
                Text.paint(this.stringEls[i], fnt, g, elWidth, this.elHeights[i], textOffset, this.fitPolicy == 2 ? 4 : 0, null);
                g.translate(0, -textOffsetHeight);
            }
            if (img != null) {
                g.translate(-translatedX, 0);
            }
            g.translate(0, this.elHeights[i]);
            translatedY += this.elHeights[i];
        }
        g.translate(0, -translatedY);
    }

    private int calculateElementHeight(int width) {
        this.cachedWidth = width;
        int eHeight = 0;
        if (this.elHeights == null || this.elHeights.length < this.numOfEls) {
            this.elHeights = new int[this.numOfEls];
        }
        int textOffset = 0;
        int prefHeight = 0;
        for (int x = 0; x < this.numOfEls; ++x) {
            textOffset = this.imageEls == null || this.imageEls[x] == null ? 0 : this.imageWidth + 2;
            Font fnt = this.fontEls == null || this.fontEls[x] == null ? Screen.CONTENT_FONT : this.fontEls[x];
            prefHeight = this.fitPolicy == 2 || this.choiceType == 4 ? fnt.getHeight() : Text.getHeightForWidth(this.stringEls[x], fnt, width, textOffset);
            this.elHeights[x] = this.imageHeight > prefHeight ? this.imageHeight : prefHeight;
            eHeight += this.elHeights[x];
        }
        return eHeight;
    }

    private int getMaxElementWidth(int grWidth) {
        int textOffset = 0;
        int w = 0;
        int maxElWidth = 0;
        for (int i = 0; i < this.numOfEls; ++i) {
            int n = w = this.imageEls == null || this.imageEls[i] == null ? 0 : this.imageWidth + 2;
            if (this.stringEls[i] == null || this.stringEls[i].length() <= 0) continue;
            textOffset = w;
            Font fnt = this.fontEls != null && this.fontEls[i] != null ? this.fontEls[i] : Screen.CONTENT_FONT;
            w = this.choiceType != 4 ? Text.getWidestLineWidth(this.stringEls[i].toCharArray(), textOffset, 80 - grWidth, fnt) : Text.getWidestLineWidth(this.stringEls[i].toCharArray(), textOffset, 240, fnt);
            if (w <= maxElWidth) continue;
            maxElWidth = w;
        }
        return maxElWidth;
    }

    private void setImageSize() {
        if (this.imageEls != null) {
            int maxW = 0;
            int maxH = 0;
            for (int i = 0; i < this.imageEls.length; ++i) {
                if (this.imageEls[i] == null) continue;
                int w = this.imageEls[i].getWidth();
                int h = this.imageEls[i].getHeight();
                if (maxW < w) {
                    maxW = w;
                }
                if (maxH >= h) continue;
                maxH = h;
            }
            if (maxW < 12) {
                maxW = 12;
            }
            if (maxH < 12) {
                maxH = 12;
            }
            this.imageWidth = maxW > 24 ? 24 : maxW;
            this.imageHeight = maxH > 24 ? 24 : maxH;
        } else {
            this.imageWidth = 12;
            this.imageHeight = 12;
        }
    }

    private void clipImage(Graphics g, Image im) {
        int w = im.width;
        int h = im.height;
        int offsetW = Math.abs((w - this.imageWidth) / 2);
        int offsetH = Math.abs((h - this.imageHeight) / 2);
        if (w > this.imageWidth || h > this.imageHeight) {
            im = Image.createImage(im, offsetW, offsetH, this.imageWidth, this.imageHeight, 0);
            offsetW = Math.abs((im.width - this.imageWidth) / 2);
            offsetH = Math.abs((im.height - this.imageHeight) / 2);
        }
        g.drawImage(im, offsetH, offsetW, 20);
    }

    private native void updatePopupElements(String[] var1, Image[] var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, boolean var10, boolean var11);

    private native int getPopupSelection();
}

