/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.sun.midp.lcdui.Text;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.Ticker;

public abstract class Displayable {
    Display currentDisplay;
    Command[] commands;
    int numCommands;
    CommandListener listener;
    static final int X = 0;
    static final int Y = 1;
    static final int WIDTH = 2;
    static final int HEIGHT = 3;
    int[] viewport;
    boolean fullScreenMode;
    boolean sizeChangeOccurred;
    Displayable paintDelegate;
    private static final Font TITLE_FONT = Font.getFont(0, 1, 0);
    static final int TITLE_HEIGHT = TITLE_FONT.getHeight() + 1;
    private String title;
    private Ticker ticker;
    private static final Timer tickerTimer = new Timer();
    private TickerPainter tickerPainter;
    private int tickerHeight;
    private int totalHeight;
    private int vScrollPosition = 0;
    private int vScrollProportion = 100;

    Displayable() {
        this.setupViewport();
        this.translateViewport();
        this.paintDelegate = this;
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitle(String s) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setTitleImpl(s);
        }
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTicker(Ticker ticker) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setTickerImpl(ticker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShown() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.currentDisplay == null ? false : this.currentDisplay.isShown(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(Command cmd) {
        if (cmd == null) {
            throw new NullPointerException();
        }
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.addCommandImpl(cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommand(Command cmd) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.removeCommandImpl(cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommandListener(CommandListener l) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.listener = l;
        }
    }

    public int getWidth() {
        return this.viewport[2];
    }

    public int getHeight() {
        return this.viewport[3];
    }

    protected void sizeChanged(int w, int h) {
    }

    void commitPendingInteraction() {
    }

    void invalidate(Item src) {
        Display d = this.currentDisplay;
        if (d != null) {
            d.invalidate(src);
        }
    }

    void callInvalidate(Item src) {
    }

    void itemStateChanged(Item src) {
        Display d = this.currentDisplay;
        if (d != null) {
            d.itemStateChanged(src);
        }
    }

    void setTickerImpl(Ticker t) {
        boolean sizeChange;
        if (this.ticker == t) {
            return;
        }
        Ticker oldTicker = this.ticker;
        this.ticker = t;
        boolean bl = sizeChange = oldTicker != null && this.ticker == null || oldTicker == null && this.ticker != null;
        if (sizeChange) {
            if (this.ticker != null) {
                this.ticker.reset();
                this.startTicker();
            } else {
                this.stopTicker();
            }
            this.layout();
            this.callSizeChanged(this.viewport[2], this.viewport[3]);
            this.callRepaint();
        } else {
            this.ticker.reset();
        }
    }

    void setTitleImpl(String s) {
        boolean sizeChange;
        if (this.title == s || this.title != null && this.title.equals(s)) {
            return;
        }
        String oldTitle = this.title;
        this.title = s;
        if (this.fullScreenMode) {
            return;
        }
        boolean bl = sizeChange = oldTitle != null && this.title == null || oldTitle == null && this.title != null;
        if (sizeChange) {
            this.layout();
            this.callSizeChanged(this.viewport[2], this.viewport[3]);
            this.callRepaint();
        } else {
            this.repaintTitle();
        }
    }

    void callSizeChanged(int w, int h) {
        this.sizeChangeOccurred = this.currentDisplay == null || !this.currentDisplay.isShown(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callPaint(Graphics g, Object target) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (!(this.fullScreenMode || this.title == null && this.ticker == null)) {
                if (g.getClipY() < this.totalHeight) {
                    if (g.getClipY() < this.tickerHeight) {
                        this.paintTicker(g);
                    }
                    if (this.title != null && g.getClipY() + g.getClipHeight() > this.totalHeight - this.tickerHeight + 1) {
                        g.translate(0, this.tickerHeight);
                        this.paintTitle(g);
                        g.translate(0, -this.tickerHeight);
                    }
                }
            } else {
                g.setColor(0x606060);
                g.drawLine(0, 0, Display.WIDTH, 0);
                g.setColor(Display.FG_COLOR);
            }
        }
    }

    void paintTicker(Graphics g) {
        if (this.ticker != null) {
            this.ticker.paintContent(g);
        } else if (this.title != null) {
            g.setColor(0x606060);
            g.drawLine(0, 0, Display.WIDTH, 0);
            g.setColor(Display.ERASE_COLOR);
            g.drawLine(0, 1, Display.WIDTH, 1);
            g.setColor(Display.FG_COLOR);
        }
    }

    void paintTitle(Graphics g) {
        g.setColor(0xAFAFAF);
        g.fillRect(0, 0, Display.WIDTH, TITLE_HEIGHT - 1);
        g.setColor(Display.FG_COLOR);
        Text.paint(this.title, TITLE_FONT, g, Display.WIDTH, TITLE_HEIGHT, 1, 4, null);
        g.setColor(0x606060);
        g.drawLine(0, TITLE_HEIGHT - 1, Display.WIDTH, TITLE_HEIGHT - 1);
        g.setColor(Display.FG_COLOR);
    }

    void layout() {
        this.setupViewport();
        this.translateViewport();
    }

    void fullScreenMode(boolean onOff) {
        if (this.fullScreenMode == onOff) {
            return;
        }
        this.fullScreenMode = onOff;
        this.layout();
        this.updateCommandSet();
        this.callSizeChanged(this.viewport[2], this.viewport[3]);
        this.callRepaint();
        if (this.fullScreenMode) {
            this.stopTicker();
        } else {
            this.startTicker();
        }
    }

    private void setupViewport() {
        if (this.viewport == null) {
            this.viewport = new int[4];
        }
        this.viewport[1] = 0;
        this.viewport[0] = 0;
        this.viewport[2] = Display.WIDTH;
        this.viewport[3] = this.fullScreenMode ? Display.HEIGHT : Display.ADORNEDHEIGHT;
    }

    private void translateViewport() {
        if (!(this.fullScreenMode || this.title == null && this.ticker == null)) {
            this.tickerHeight = this.ticker != null ? Ticker.PREFERRED_HEIGHT : (this.title != null ? 2 : 0);
            this.totalHeight = this.title != null ? TITLE_HEIGHT + this.tickerHeight : this.tickerHeight;
        } else {
            this.totalHeight = 1;
        }
        this.viewport[1] = this.viewport[1] + this.totalHeight;
        this.viewport[3] = this.viewport[3] - this.totalHeight;
    }

    void callKeyPressed(int keyCode) {
    }

    void callKeyRepeated(int keyCode) {
    }

    void callKeyReleased(int keyCode) {
    }

    void callKeyTyped(char c) {
    }

    void callPointerPressed(int x, int y) {
    }

    void callPointerDragged(int x, int y) {
    }

    void callPointerReleased(int x, int y) {
    }

    final void callRepaint(int x, int y, int width, int height, Object target) {
        if (this.currentDisplay != null) {
            this.currentDisplay.repaintImpl(this.paintDelegate, x, y, width, height, target);
        }
    }

    final void callRepaint() {
        this.callRepaint(0, 0, this.viewport[0] + this.viewport[2], this.viewport[1] + this.viewport[3], null);
    }

    final void repaintContents() {
        this.callRepaint(this.viewport[0], this.viewport[1], this.viewport[2], this.viewport[3], null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setVerticalScroll(int scrollPosition, int scrollProportion) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.vScrollPosition = scrollPosition;
            this.vScrollProportion = scrollProportion;
            if (this.currentDisplay != null) {
                this.currentDisplay.setVerticalScroll(scrollPosition, scrollProportion);
            }
        }
    }

    int getVerticalScrollPosition() {
        return this.vScrollPosition;
    }

    int getVerticalScrollProportion() {
        return this.vScrollProportion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callShowNotify(Display d) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.currentDisplay = d;
            this.grabFullScreen(this.fullScreenMode);
            if (this.sizeChangeOccurred) {
                this.callSizeChanged(this.viewport[2], this.viewport[3]);
            }
            this.startTicker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callHideNotify(Display d) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.currentDisplay = null;
            this.stopTicker();
        }
    }

    Command[] getCommands() {
        return this.commands;
    }

    int getCommandCount() {
        return this.numCommands;
    }

    Item getCurrentItem() {
        return null;
    }

    CommandListener getCommandListener() {
        return this.listener;
    }

    void addCommandImpl(Command cmd) {
        for (int i = 0; i < this.numCommands; ++i) {
            if (this.commands[i] != cmd) continue;
            return;
        }
        if (this.commands == null || this.numCommands == this.commands.length) {
            Command[] newCommands = new Command[this.numCommands + 4];
            if (this.commands != null) {
                System.arraycopy(this.commands, 0, newCommands, 0, this.numCommands);
            }
            this.commands = newCommands;
        }
        this.commands[this.numCommands] = cmd;
        ++this.numCommands;
        this.updateCommandSet();
    }

    void removeCommandImpl(Command cmd) {
        for (int i = 0; i < this.numCommands; ++i) {
            if (this.commands[i] != cmd) continue;
            this.commands[i] = this.commands[--this.numCommands];
            this.commands[this.numCommands] = null;
            this.updateCommandSet();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCommandSet() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.currentDisplay != null && this.currentDisplay.isShown(this)) {
                this.currentDisplay.updateCommandSet();
            }
        }
    }

    private void repaintTitle() {
        if (this.currentDisplay != null) {
            this.currentDisplay.repaintImpl(this.paintDelegate, 0, this.ticker != null ? Ticker.PREFERRED_HEIGHT : 2, this.viewport[2], TITLE_HEIGHT, this.title);
        }
    }

    private void startTicker() {
        if (this.ticker == null || this.fullScreenMode) {
            return;
        }
        this.stopTicker();
        this.tickerPainter = new TickerPainter();
        tickerTimer.schedule((TimerTask)this.tickerPainter, 0L, 250L);
    }

    private void stopTicker() {
        if (this.tickerPainter == null) {
            return;
        }
        this.tickerPainter.cancel();
        this.tickerPainter = null;
    }

    private void repaintTickerText() {
        if (this.currentDisplay != null && this.currentDisplay.isShown(this.paintDelegate)) {
            this.currentDisplay.repaintImpl(this.paintDelegate, 0, 2, this.viewport[2], Screen.CONTENT_HEIGHT, this.ticker);
        }
    }

    native void grabFullScreen(boolean var1);

    private class TickerPainter
    extends TimerTask {
        private TickerPainter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            Object object = Display.LCDUILock;
            synchronized (object) {
                Displayable.this.repaintTickerText();
            }
        }
    }
}

