/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.Spacer;
import javax.microedition.lcdui.StringItem;

public class Form
extends Screen {
    final boolean TRAVERSE_HORIZONTAL;
    final boolean TRAVERSE_VERTICAL;
    static final int CELL_SPACING = 4;
    static final int ONE_PIXEL_BOX = 0;
    static final int TRIANGLE_CORNERS = 1;
    static final int TRAVERSE_INDICATOR = 0;
    static final int TRAVERSE_INDICATOR_COLOR = 0x606060;
    static final int LAYOUT_HMASK = 3;
    static final int LAYOUT_VMASK = 48;
    private int formMode;
    private static final int FORM_TRAVERSE = 0;
    private static final int ITEM_TRAVERSE = 2;
    private int traverseIndex = -1;
    private boolean indicateTraverse = true;
    private boolean validateVisibility = true;
    private int[] viewable;
    private int[] visRect;
    private static final int GROW_SIZE = 4;
    private Item[] items;
    private int numOfItems;
    private int cellSpacing;
    private ItemStateListener itemStateListener;
    private boolean pointerPressed;
    private int currentAlignment = 1;

    public Form(String title) {
        this(title, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Form(String title, Item[] items) {
        super(title);
        this.TRAVERSE_HORIZONTAL = true;
        this.TRAVERSE_VERTICAL = true;
        Object object = Display.LCDUILock;
        synchronized (object) {
            int i;
            this.visRect = new int[4];
            if (items == null) {
                this.items = new Item[4];
                return;
            }
            this.items = new Item[items.length > 4 ? items.length : 4];
            for (i = 0; i < items.length; ++i) {
                if (items[i].getOwner() == null) continue;
                throw new IllegalStateException();
            }
            this.numOfItems = items.length;
            this.cellSpacing = this.numOfItems > 1 ? 4 : 1;
            for (i = 0; i < this.numOfItems; ++i) {
                items[i].setOwner(this);
                this.items[i] = items[i];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int append(Item item) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (item.getOwner() != null) {
                throw new IllegalStateException();
            }
            return this.insertImpl(this.numOfItems, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int append(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.insertImpl(this.numOfItems, new StringItem(null, str));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int append(Image img) {
        if (img == null) {
            throw new NullPointerException();
        }
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.insertImpl(this.numOfItems, new ImageItem(null, img, 0, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int itemNum, Item item) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (item.getOwner() != null) {
                throw new IllegalStateException();
            }
            if (itemNum < 0 || itemNum > this.numOfItems) {
                throw new IndexOutOfBoundsException();
            }
            this.insertImpl(itemNum, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int itemNum) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (itemNum < 0 || itemNum >= this.numOfItems) {
                throw new IndexOutOfBoundsException();
            }
            Item deletedItem = this.items[itemNum];
            deletedItem.setOwner(null);
            --this.numOfItems;
            int n = this.cellSpacing = this.numOfItems > 1 ? 4 : 1;
            if (this.traverseIndex == itemNum) {
                this.formMode = 0;
            }
            if (this.traverseIndex > itemNum || this.traverseIndex == this.numOfItems) {
                --this.traverseIndex;
            }
            if (itemNum < this.numOfItems) {
                System.arraycopy(this.items, itemNum + 1, this.items, itemNum, this.numOfItems - itemNum);
            }
            this.items[this.numOfItems] = null;
            if (this.numOfItems == 0 && this.items.length > 4) {
                this.items = new Item[4];
            }
            this.invalidate(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.numOfItems == 0) {
                return;
            }
            for (int x = 0; x < this.numOfItems; ++x) {
                this.items[x].setOwner(null);
                this.items[x] = null;
            }
            if (this.items.length > 4) {
                this.items = new Item[4];
            }
            this.numOfItems = 0;
            this.cellSpacing = 1;
            this.formMode = 0;
            this.traverseIndex = -1;
            this.invalidate(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int itemNum, Item item) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (item.getOwner() != null) {
                throw new IllegalStateException();
            }
            if (itemNum < 0 || itemNum >= this.numOfItems) {
                throw new IndexOutOfBoundsException();
            }
            this.setImpl(itemNum, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item get(int itemNum) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (itemNum < 0 || itemNum >= this.numOfItems) {
                throw new IndexOutOfBoundsException();
            }
            return this.items[itemNum];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItemStateListener(ItemStateListener iListener) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.itemStateListener = iListener;
        }
    }

    public int size() {
        return this.numOfItems;
    }

    public int getWidth() {
        return this.viewport[2] - 2 * this.cellSpacing;
    }

    public int getHeight() {
        return this.viewport[3] - 2 * this.cellSpacing;
    }

    void commitPendingInteraction() {
        Item curItem = this.getCurrentItem();
        if (curItem != null) {
            curItem.commitPendingInteraction();
        }
    }

    void setCurrentItem(Item i) {
        if (i == null || i.owner != this) {
            return;
        }
        if (this.traverseIndex != -1 && this.items[this.traverseIndex] == i) {
            return;
        }
        for (int x = 0; x < this.numOfItems; ++x) {
            if (this.items[x] != i) continue;
            this.setTraverseIndex(0, this.traverseIndex, x);
            ((Screen)this.paintDelegate).resetToTop = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callShowNotify(Display d) {
        super.callShowNotify(d);
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.layout();
            if (((Screen)this.paintDelegate).resetToTop) {
                this.traverseIndex = -1;
                this.view[1] = 0;
                this.view[0] = 0;
            } else {
                ((Screen)this.paintDelegate).resetToTop = true;
            }
        }
        this.traverse(0);
    }

    void callHideNotify(Display d) {
        if (this.traverseIndex != -1) {
            try {
                this.items[this.traverseIndex].callTraverseOut();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        super.callHideNotify(d);
        for (int x = 0; x < this.numOfItems; ++x) {
            try {
                if (!this.items[x].visible) continue;
                this.items[x].callHideNotify();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callKeyPressed(int keyCode) {
        Item i = null;
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.numOfItems == 0 || this.traverseIndex < 0) {
                return;
            }
            i = this.items[this.traverseIndex];
        }
        if (keyCode == Display.KEYCODE_UP || keyCode == Display.KEYCODE_DOWN || keyCode == Display.KEYCODE_LEFT || keyCode == Display.KEYCODE_RIGHT) {
            this.traverse(Display.getGameAction(keyCode));
            return;
        }
        if (i != null) {
            i.callKeyPressed(keyCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callKeyReleased(int keyCode) {
        Item i = null;
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.numOfItems == 0 || this.traverseIndex < 0) {
                return;
            }
            i = this.items[this.traverseIndex];
        }
        i.callKeyReleased(keyCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callKeyRepeated(int keyCode) {
        Item i = null;
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.numOfItems == 0 || this.traverseIndex < 0) {
                return;
            }
            i = this.items[this.traverseIndex];
        }
        if (i instanceof CustomItem) {
            i.callKeyRepeated(keyCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callKeyTyped(char c) {
        Item i = null;
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.numOfItems == 0 || this.traverseIndex < 0) {
                return;
            }
            i = this.items[this.traverseIndex];
        }
        i.callKeyTyped(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callPointerPressed(int x, int y) {
        Item i = null;
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.numOfItems == 0 || this.traverseIndex < 0) {
                return;
            }
            i = this.items[this.traverseIndex];
            if (i.bounds == null) {
                return;
            }
            x = x - this.viewport[0] + this.view[0] - i.bounds[0];
            y = y - this.viewport[1] + this.view[1] - i.bounds[1];
            if (x < 0 || x > i.bounds[2] || y < 0 || y > i.bounds[3]) {
                return;
            }
            this.pointerPressed = true;
        }
        i.callPointerPressed(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callPointerReleased(int x, int y) {
        Item i = null;
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.numOfItems == 0 || this.traverseIndex < 0 || !this.pointerPressed) {
                return;
            }
            i = this.items[this.traverseIndex];
            if (i.bounds == null) {
                return;
            }
            x = x - this.viewport[0] + this.view[0] - i.bounds[0];
            y = y - this.viewport[1] + this.view[1] - i.bounds[1];
            this.pointerPressed = false;
        }
        i.callPointerReleased(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callPointerDragged(int x, int y) {
        Item i = null;
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.numOfItems == 0 || this.traverseIndex < 0 || !this.pointerPressed) {
                return;
            }
            i = this.items[this.traverseIndex];
            if (i.bounds == null) {
                return;
            }
            x = x - this.viewport[0] + this.view[0] - i.bounds[0];
            y = y - this.viewport[1] + this.view[1] - i.bounds[1];
        }
        i.callPointerDragged(x, y);
    }

    void traverse(int dir) {
        switch (this.formMode) {
            case 0: {
                try {
                    this.formTraverse(dir);
                }
                catch (Throwable t) {}
                break;
            }
            case 2: {
                try {
                    if (this.itemTraverse(dir)) break;
                    this.formTraverse(dir);
                    break;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    void formTraverse(int dir) {
        if (this.numOfItems == 0) {
            return;
        }
        if (dir == 0) {
            this.setTraverseIndex(dir, this.traverseIndex, this.traverseIndex == -1 ? 0 : this.traverseIndex);
            return;
        }
        if (this.traverseIndex >= 0 && !this.items[this.traverseIndex].shouldSkipTraverse() && this.scrollForBounds(dir, this.items[this.traverseIndex].bounds)) {
            this.validateVisibility = true;
            this.repaintContents();
            return;
        }
        int bendDir = dir;
        if (dir == 6) {
            bendDir = 5;
        } else if (dir == 1) {
            bendDir = 2;
        }
        int newIndex = this.traverseIndex;
        do {
            int oldIndex = newIndex;
            switch (bendDir) {
                case 2: {
                    if (newIndex <= 0) break;
                    --newIndex;
                    break;
                }
                case 5: {
                    if (newIndex >= this.numOfItems - 1) break;
                    ++newIndex;
                }
            }
            if (oldIndex != newIndex) continue;
            return;
        } while (this.items[newIndex].shouldSkipTraverse());
        this.setTraverseIndex(dir, this.traverseIndex, newIndex);
    }

    void setTraverseIndex(int dir, int oldIndex, int newIndex) {
        if (dir == 0) {
            int newTraveseIndex = newIndex;
            boolean allSkipped = false;
            while (!allSkipped && this.items[newIndex].shouldSkipTraverse()) {
                if (++newIndex != this.numOfItems) continue;
                allSkipped = true;
            }
            if (allSkipped) {
                if (newTraveseIndex > 0) {
                    newIndex = newTraveseIndex - 1;
                    while (this.items[newIndex].shouldSkipTraverse()) {
                        if (--newIndex != -1) continue;
                        return;
                    }
                } else {
                    return;
                }
            }
        }
        this.formMode = 0;
        this.traverseIndex = newIndex;
        if (oldIndex >= 0 && oldIndex < this.numOfItems) {
            this.items[oldIndex].callTraverseOut();
        }
        if (this.items[this.traverseIndex].bounds == null) {
            return;
        }
        if (dir == 0) {
            dir = newIndex >= oldIndex ? 6 : 1;
        }
        this.scrollForTraversal(dir, this.items[this.traverseIndex].bounds);
        this.itemTraverse(dir);
        this.validateVisibility = true;
        this.repaintContents();
        this.updateCommandSet();
    }

    boolean itemTraverse(int dir) {
        if (this.traverseIndex == -1) {
            return false;
        }
        if (this.formMode == 2 && this.scrollForBounds(dir, this.visRect)) {
            this.validateVisibility = true;
            this.repaintContents();
            return true;
        }
        this.visRect[1] = 0;
        this.visRect[0] = 0;
        this.visRect[2] = this.items[this.traverseIndex].bounds[2];
        this.visRect[3] = this.items[this.traverseIndex].bounds[3];
        if (this.items[this.traverseIndex].callTraverse(dir, this.viewport[2], this.viewport[3], this.visRect)) {
            this.visRect[0] = this.visRect[0] + this.items[this.traverseIndex].bounds[0];
            this.visRect[1] = this.visRect[1] + this.items[this.traverseIndex].bounds[1];
            this.formMode = 2;
            if (this.scrollForTraversal(dir, this.visRect)) {
                this.validateVisibility = true;
                this.repaintContents();
            }
            return true;
        }
        this.visRect[0] = this.visRect[0] + this.items[this.traverseIndex].bounds[0];
        this.visRect[1] = this.visRect[1] + this.items[this.traverseIndex].bounds[1];
        return false;
    }

    boolean scrollForBounds(int dir, int[] bounds) {
        if (this.view[3] < this.viewport[3]) {
            return false;
        }
        switch (dir) {
            case 1: {
                if (bounds[1] >= this.view[1]) {
                    return false;
                }
                this.view[1] = this.view[1] - Screen.CONTENT_HEIGHT;
                if (this.view[1] < 0) {
                    this.view[1] = 0;
                }
                return true;
            }
            case 6: {
                if (bounds[1] + bounds[3] + this.cellSpacing <= this.view[1] + this.viewport[3]) {
                    return false;
                }
                this.view[1] = this.view[1] + Screen.CONTENT_HEIGHT;
                if (this.view[1] > this.view[3] - this.viewport[3]) {
                    this.view[1] = this.view[3] - this.viewport[3];
                }
                return true;
            }
            case 2: {
                break;
            }
        }
        return false;
    }

    boolean scrollForTraversal(int dir, int[] bounds) {
        if (this.view[3] < this.viewport[3]) {
            if (this.view[1] > 0) {
                this.view[1] = 0;
                return true;
            }
            return false;
        }
        if (bounds[1] > this.view[1] && bounds[1] + bounds[3] < this.view[1] + this.viewport[3]) {
            return false;
        }
        if (bounds[3] > this.viewport[3]) {
            if (dir == 6 || dir == 2 || dir == 0) {
                this.view[1] = bounds[1] - this.cellSpacing;
            } else if (dir == 1 || dir == 5) {
                this.view[1] = bounds[1] + bounds[3] + this.cellSpacing - this.viewport[3];
            }
        } else if (dir == 6 || dir == 2 || dir == 0) {
            this.view[1] = bounds[1] + bounds[3] + this.cellSpacing - this.viewport[3];
        } else if (dir == 1 || dir == 5) {
            this.view[1] = bounds[1] - this.cellSpacing;
        }
        if (this.view[1] + this.viewport[3] > this.view[3]) {
            this.view[1] = this.view[3] - this.viewport[3];
        }
        if (this.view[1] < 0) {
            this.view[1] = 0;
        }
        return true;
    }

    void layout() {
        super.layout();
        this.currentAlignment = 1;
        if (this.numOfItems == 0) {
            return;
        }
        int rowStart = 0;
        if (this.viewable == null) {
            this.viewable = new int[4];
        }
        this.viewable[0] = this.cellSpacing;
        this.viewable[1] = this.cellSpacing;
        this.viewable[2] = this.viewport[2] - this.cellSpacing;
        this.viewable[3] = this.viewport[3] - this.cellSpacing;
        this.view[2] = this.viewable[2] - this.cellSpacing;
        this.view[3] = this.cellSpacing;
        int lineHeight = 0;
        for (int index = 0; index < this.numOfItems; ++index) {
            int pW = this.items[index].shouldHShrink() ? this.items[index].callMinimumWidth() : (this.items[index].lockedWidth != -1 ? this.items[index].lockedWidth : this.items[index].callPreferredWidth(this.items[index].lockedHeight));
            if (pW > this.view[2]) {
                pW = this.view[2];
            }
            int itemAlignment = (this.items[index].layout & 3) == 0 ? this.currentAlignment : this.items[index].layout & 3;
            boolean newLine = index > 0 && this.items[index - 1].equateNLA();
            newLine = newLine || this.items[index].equateNLB();
            newLine = newLine || pW > this.viewable[2] - this.cellSpacing;
            boolean bl = newLine = newLine || itemAlignment != this.currentAlignment;
            if (this.items[index] instanceof ImageItem) {
                boolean bl2 = newLine = newLine || (this.items[index].layout & 0x4000) == 0 && this.items[index].getLabel() != null && this.items[index].getLabel().length() > 0;
            }
            if (newLine && lineHeight > 0) {
                try {
                    lineHeight = this.layoutRowHorizontal(rowStart, index - 1, this.viewable[2], lineHeight);
                    this.layoutRowVertical(rowStart, index - 1, lineHeight);
                    this.view[3] = this.view[3] + (lineHeight + this.cellSpacing);
                }
                catch (Throwable t) {
                    Display.handleThrowable(t);
                }
                this.viewable[0] = this.cellSpacing;
                this.viewable[1] = this.view[3];
                this.viewable[2] = this.viewport[2] - this.cellSpacing;
                this.viewable[3] = this.viewable[3] - (lineHeight + this.cellSpacing);
                lineHeight = 0;
                rowStart = index;
            }
            this.currentAlignment = (this.items[index].layout & 3) == 0 ? this.currentAlignment : this.items[index].layout & 3;
            int pH = this.getItemHeight(index, pW);
            if (this.items[index].bounds == null) {
                this.items[index].bounds = new int[4];
            }
            if (this.items[index].bounds[2] != pW || this.items[index].bounds[3] != pH) {
                this.items[index].sizeChanged = true;
            }
            this.items[index].bounds[0] = this.viewable[0];
            this.items[index].bounds[1] = this.viewable[1];
            this.items[index].bounds[2] = pW;
            this.items[index].bounds[3] = pH;
            if (pH > lineHeight) {
                lineHeight = pH;
            }
            if (pW <= 0) continue;
            if (this.items[index] instanceof Spacer || index + 1 < this.numOfItems && this.items[index + 1] instanceof Spacer) {
                this.viewable[2] = this.viewable[2] - pW;
                this.viewable[0] = this.viewable[0] + pW;
                continue;
            }
            this.viewable[2] = this.viewable[2] - (pW + this.cellSpacing);
            this.viewable[0] = this.viewable[0] + (pW + this.cellSpacing);
        }
        try {
            lineHeight = this.layoutRowHorizontal(rowStart, this.numOfItems - 1, this.viewable[2], lineHeight);
            this.layoutRowVertical(rowStart, this.numOfItems - 1, lineHeight);
            this.view[3] = this.view[3] + (lineHeight + this.cellSpacing);
        }
        catch (Throwable t) {
            Display.handleThrowable(t);
        }
    }

    void callPaint(Graphics g, Object target) {
        super.callPaint(g, target);
        try {
            if (this.numOfItems == 0) {
                return;
            }
            int[] clip = new int[]{g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight()};
            if (clip[1] + clip[3] <= this.viewport[1]) {
                return;
            }
            this.setVerticalScroll();
            if (target instanceof Item) {
                if (((Item)target).owner == this) {
                    this.paintItem((Item)target, g, clip);
                }
            } else {
                for (int i = 0; i < this.numOfItems; ++i) {
                    this.paintItem(this.items[i], g, clip);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void paintItem(Item item, Graphics g, int[] clip) {
        if (item.bounds == null) {
            return;
        }
        int tX = item.bounds[0] + this.viewport[0] - this.view[0];
        int tY = item.bounds[1] + this.viewport[1] - this.view[1];
        if (!(tY + item.bounds[3] >= clip[1] && tY <= clip[1] + clip[3] || this.validateVisibility)) {
            return;
        }
        g.clipRect(tX, tY, item.bounds[2], item.bounds[3]);
        if (g.getClipWidth() > 0 && g.getClipHeight() > 0) {
            if (this.validateVisibility && !item.visible) {
                item.callShowNotify();
            }
            if (item.sizeChanged) {
                item.callSizeChanged(item.bounds[2], item.bounds[3]);
                item.sizeChanged = false;
            }
            g.translate(tX, tY);
            item.callPaint(g, item.bounds[2], item.bounds[3]);
        } else if (this.validateVisibility && item.visible) {
            item.callHideNotify();
        }
        g.reset(clip[0], clip[1], clip[0] + clip[2], clip[1] + clip[3]);
        if (this.traverseIndex >= 0 && this.numOfItems > 1 && item == this.items[this.traverseIndex] && this.indicateTraverse) {
            g.clipRect(tX - this.cellSpacing, tY - this.cellSpacing, item.bounds[2] + 2 * this.cellSpacing, item.bounds[3] + 2 * this.cellSpacing);
            this.paintTraversalIndicator(g, tX, tY);
            g.setClip(clip[0], clip[1], clip[2], clip[3]);
        }
    }

    void paintTraversalIndicator(Graphics g, int x, int y) {
        g.setColor(0x606060);
        g.drawRect(x - (this.cellSpacing - 1), y - (this.cellSpacing - 1), this.items[this.traverseIndex].bounds[2] + (this.cellSpacing + 1), this.items[this.traverseIndex].bounds[3] + (this.cellSpacing + 1));
        g.setColor(Display.FG_COLOR);
    }

    Item getCurrentItem() {
        return this.traverseIndex < 0 ? null : this.items[this.traverseIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callInvalidate(Item item) {
        if (!this.paintDelegate.isShown()) {
            return;
        }
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.layout();
        }
        this.repaintContents();
        this.traverse(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callItemStateChanged(Item item) {
        ItemStateListener isl = this.itemStateListener;
        if (isl == null || item == null) {
            return;
        }
        try {
            Object object = Display.calloutLock;
            synchronized (object) {
                isl.itemStateChanged(item);
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
        }
    }

    private int getItemHeight(int index, int pW) {
        int pH;
        if (this.items[index].shouldVShrink()) {
            pH = this.items[index].callMinimumHeight();
        } else {
            pH = this.items[index].lockedHeight;
            if (pH == -1) {
                pH = this.items[index].callPreferredHeight(pW);
            }
        }
        return pH;
    }

    private int layoutRowHorizontal(int rowStart, int rowEnd, int hSpace, int rowHeight) {
        int layout;
        hSpace = this.inflateHShrinkables(rowStart, rowEnd, hSpace);
        hSpace = this.inflateHExpandables(rowStart, rowEnd, hSpace);
        rowHeight = 0;
        for (int i = rowStart; i <= rowEnd; ++i) {
            if (rowHeight >= this.items[i].bounds[3]) continue;
            rowHeight = this.items[i].bounds[3];
        }
        if (hSpace == 0) {
            return rowHeight;
        }
        while (rowStart <= rowEnd && ((layout = this.callGetLayout(this.items[rowEnd])) & 3) == 2) {
            this.items[rowEnd].bounds[0] = this.items[rowEnd].bounds[0] + hSpace;
            --rowEnd;
        }
        int hLayout = 0;
        hSpace /= 2;
        while (rowStart <= rowEnd) {
            hLayout = this.callGetLayout(this.items[rowStart]) & 3;
            if (hLayout != 1) {
                if (hLayout != 3) break;
                this.items[rowStart].bounds[0] = this.items[rowStart].bounds[0] + hSpace;
            }
            ++rowStart;
        }
        return rowHeight;
    }

    private int inflateHShrinkables(int rowStart, int rowEnd, int space) {
        int pW;
        int i;
        if (space == 0) {
            return 0;
        }
        int baseline = Integer.MAX_VALUE;
        int prop = 0;
        for (i = rowStart; i <= rowEnd; ++i) {
            if (!this.items[i].shouldHShrink()) continue;
            pW = this.items[i].lockedWidth;
            if (pW == -1) {
                pW = this.items[i].callPreferredWidth(this.items[i].lockedHeight);
            }
            if ((prop = pW - this.items[i].getMinimumWidth()) <= 0 || prop >= baseline) continue;
            baseline = prop;
        }
        if (baseline == Integer.MAX_VALUE) {
            return space;
        }
        prop = 0;
        for (i = rowStart; i <= rowEnd; ++i) {
            if (!this.items[i].shouldHShrink()) continue;
            pW = this.items[i].lockedWidth;
            if (pW == -1) {
                pW = this.items[i].callPreferredWidth(this.items[i].lockedHeight);
            }
            prop += (pW - this.items[i].getMinimumWidth()) / baseline;
        }
        int adder = space / prop;
        for (int i2 = rowStart; i2 <= rowEnd; ++i2) {
            if (!this.items[i2].shouldHShrink()) continue;
            pW = this.items[i2].lockedWidth;
            if (pW == -1) {
                pW = this.items[i2].callPreferredWidth(this.items[i2].lockedHeight);
            }
            if ((space = pW - this.items[i2].getMinimumWidth()) > (prop = adder * (space / baseline))) {
                space = prop;
            }
            this.items[i2].bounds[2] = this.items[i2].bounds[2] + space;
            this.items[i2].bounds[3] = this.getItemHeight(i2, this.items[i2].bounds[2]);
            for (int j = i2 + 1; j <= rowEnd; ++j) {
                this.items[j].bounds[0] = this.items[j].bounds[0] + space;
            }
        }
        space = this.viewport[2] - this.cellSpacing - (this.items[rowEnd].bounds[0] + this.items[rowEnd].bounds[2]);
        return space;
    }

    private int inflateHExpandables(int rowStart, int rowEnd, int space) {
        int i;
        if (space == 0) {
            return 0;
        }
        int numExp = 0;
        for (i = rowStart; i <= rowEnd; ++i) {
            if (!this.items[i].shouldHExpand()) continue;
            ++numExp;
        }
        if (numExp == 0 || space < numExp) {
            return space;
        }
        space /= numExp;
        for (i = rowStart; i <= rowEnd; ++i) {
            if (!this.items[i].shouldHExpand()) continue;
            this.items[i].bounds[2] = this.items[i].bounds[2] + space;
            this.items[i].bounds[3] = this.getItemHeight(i, this.items[i].bounds[2]);
            for (int j = i + 1; j <= rowEnd; ++j) {
                this.items[j].bounds[0] = this.items[j].bounds[0] + space;
            }
        }
        space = this.viewport[2] - this.cellSpacing - (this.items[rowEnd].bounds[0] + this.items[rowEnd].bounds[2]);
        return space;
    }

    private void layoutRowVertical(int rowStart, int rowEnd, int lineHeight) {
        int space = 0;
        int pH = 0;
        block4: for (int i = rowStart; i <= rowEnd; ++i) {
            if (this.items[i].shouldVExpand()) {
                this.items[i].bounds[3] = lineHeight;
            } else if (this.items[i].shouldVShrink()) {
                pH = this.items[i].lockedHeight;
                if (pH == -1) {
                    pH = this.items[i].callPreferredHeight(this.items[i].bounds[2]);
                }
                if (pH > lineHeight) {
                    pH = lineHeight;
                }
                this.items[i].bounds[3] = pH;
            }
            switch (this.callGetLayout(this.items[i]) & 0x30) {
                case 48: {
                    space = lineHeight - this.items[i].bounds[3];
                    if (space <= 0) continue block4;
                    this.items[i].bounds[1] = this.items[i].bounds[1] + space / 2;
                    continue block4;
                }
                case 16: {
                    continue block4;
                }
                default: {
                    space = lineHeight - this.items[i].bounds[3];
                    if (space <= 0) continue block4;
                    this.items[i].bounds[1] = this.items[i].bounds[1] + space;
                }
            }
        }
    }

    private int insertImpl(int itemNum, Item item) {
        if (this.traverseIndex >= itemNum || this.traverseIndex == -1) {
            ++this.traverseIndex;
        }
        if (this.items.length == this.numOfItems) {
            Item[] newItems = new Item[this.numOfItems + 4];
            System.arraycopy(this.items, 0, newItems, 0, itemNum);
            System.arraycopy(this.items, itemNum, newItems, itemNum + 1, this.numOfItems - itemNum);
            this.items = newItems;
        } else if (itemNum != this.numOfItems) {
            System.arraycopy(this.items, itemNum, this.items, itemNum + 1, this.numOfItems - itemNum);
        }
        ++this.numOfItems;
        this.cellSpacing = this.numOfItems > 1 ? 4 : 1;
        this.items[itemNum] = null;
        this.setImpl(itemNum, item);
        return itemNum;
    }

    private void setImpl(int itemNum, Item item) {
        Item oldItem = this.items[itemNum];
        if (oldItem != null) {
            oldItem.setOwner(null);
        }
        item.setOwner(this);
        this.items[itemNum] = item;
        this.invalidate(null);
    }

    private int callGetLayout(Item item) {
        if ((item.layout & 3) == 0) {
            item.layout |= this.currentAlignment;
        }
        return item.layout;
    }
}

