/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageGraphics;

public class Graphics {
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int BASELINE = 64;
    public static final int SOLID = 0;
    public static final int DOTTED = 1;
    private int transX;
    private int transY;
    private short clipX1;
    private short clipY1;
    private int clipX2;
    private int clipY2;
    private int translatedX1;
    private int translatedY1;
    private int translatedX2;
    private int translatedY2;
    private short[] clip = new short[4];
    private boolean clipped = false;
    private int rgbColor;
    private int gray;
    private int pixel;
    private int style;
    private Font currentFont;
    private short maxWidth;
    private short maxHeight;
    Image destination = null;

    private native void init();

    Graphics(int w, int h) {
        this.maxWidth = (short)(w & Short.MAX_VALUE);
        this.maxHeight = (short)(h & Short.MAX_VALUE);
        this.init();
        this.reset();
    }

    public void translate(int x, int y) {
        this.transX += x;
        this.transY += y;
    }

    public int getTranslateX() {
        return this.transX;
    }

    public int getTranslateY() {
        return this.transY;
    }

    public int getColor() {
        return this.rgbColor;
    }

    public int getRedComponent() {
        return this.rgbColor >> 16 & 0xFF;
    }

    public int getGreenComponent() {
        return this.rgbColor >> 8 & 0xFF;
    }

    public int getBlueComponent() {
        return this.rgbColor & 0xFF;
    }

    public int getGrayScale() {
        return this.gray;
    }

    public void setColor(int red, int green, int blue) {
        if (red < 0 || red > 255 || green < 0 || green > 255 || blue < 0 || blue > 255) {
            throw new IllegalArgumentException("Value out of range");
        }
        this.rgbColor = red << 16 | green << 8 | blue;
        this.gray = Graphics.grayVal(red, green, blue);
        this.pixel = this.getPixel(this.rgbColor, this.gray, false);
    }

    public void setColor(int RGB2) {
        int red = RGB2 >> 16 & 0xFF;
        int green = RGB2 >> 8 & 0xFF;
        int blue = RGB2 & 0xFF;
        this.rgbColor = RGB2 & 0xFFFFFF;
        this.gray = Graphics.grayVal(red, green, blue);
        this.pixel = this.getPixel(this.rgbColor, this.gray, false);
    }

    public void setGrayScale(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Gray value out of range");
        }
        this.rgbColor = value << 16 | value << 8 | value;
        this.gray = value;
        this.pixel = this.getPixel(this.rgbColor, this.gray, true);
    }

    public Font getFont() {
        return this.currentFont;
    }

    public void setStrokeStyle(int style) {
        if (style != 0 && style != 1) {
            throw new IllegalArgumentException("Invalid line style");
        }
        this.style = style;
    }

    public int getStrokeStyle() {
        return this.style;
    }

    public void setFont(Font font) {
        this.currentFont = font == null ? Font.getDefaultFont() : font;
    }

    public int getClipX() {
        return this.clip[0] - this.transX;
    }

    public int getClipY() {
        return this.clip[1] - this.transY;
    }

    public int getClipWidth() {
        return this.clip[2];
    }

    public int getClipHeight() {
        return this.clip[3];
    }

    public void clipRect(int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            this.clip[2] = 0;
            this.clip[3] = 0;
            this.clipped = true;
            return;
        }
        this.translatedX1 = x + this.transX;
        this.translatedY1 = y + this.transY;
        if (this.translatedX1 < 0) {
            int n = this.translatedX1 = x < 0 || this.transX < 0 ? 0 : (int)this.maxWidth;
        }
        if (this.translatedY1 < 0) {
            this.translatedY1 = y < 0 || this.transY < 0 ? 0 : (int)this.maxHeight;
        }
        this.clipX2 = this.clip[0] + this.clip[2];
        this.clipY2 = this.clip[1] + this.clip[3];
        if (this.clipX2 < this.translatedX1 || this.clipY2 < this.translatedY1) {
            this.clip[2] = 0;
            this.clip[3] = 0;
            this.clipped = true;
            return;
        }
        if (this.translatedX1 > this.clip[0]) {
            this.clip[0] = (short)(this.translatedX1 & Short.MAX_VALUE);
            this.clipped = true;
        }
        if (this.translatedY1 > this.clip[1]) {
            this.clip[1] = (short)(this.translatedY1 & Short.MAX_VALUE);
            this.clipped = true;
        }
        this.translatedX2 = x + this.transX + width;
        this.translatedY2 = y + this.transY + height;
        if (this.translatedX2 < 0) {
            int n = this.translatedX2 = x < 0 || this.transX < 0 ? 0 : (int)this.maxWidth;
        }
        if (this.translatedY2 < 0) {
            int n = this.translatedY2 = y < 0 || this.transY < 0 ? 0 : (int)this.maxHeight;
        }
        if (this.translatedX2 < this.clip[0] || this.translatedY2 < this.clip[1]) {
            this.clip[2] = 0;
            this.clip[3] = 0;
            this.clipped = true;
            return;
        }
        if (this.translatedX2 <= this.clipX2) {
            this.clipX2 = this.translatedX2;
            this.clipped = true;
        }
        if (this.translatedY2 <= this.clipY2) {
            this.clipY2 = this.translatedY2;
            this.clipped = true;
        }
        if (this.clipped) {
            this.clipX2 -= this.clip[0];
            this.clipY2 -= this.clip[1];
            this.clip[2] = this.clipX2 > 0 ? (short)(this.clipX2 & Short.MAX_VALUE) : (short)0;
            this.clip[3] = this.clipY2 > 0 ? (short)(this.clipY2 & Short.MAX_VALUE) : (short)0;
        }
    }

    public void setClip(int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            this.clip[3] = 0;
            this.clip[2] = 0;
            this.clip[1] = 0;
            this.clip[0] = 0;
            this.clipped = true;
            return;
        }
        this.translatedX1 = x + this.transX;
        this.translatedY1 = y + this.transY;
        if (this.translatedX1 < 0) {
            int n = this.translatedX1 = x < 0 || this.transX < 0 ? 0 : (int)this.maxWidth;
        }
        if (this.translatedY1 < 0) {
            this.translatedY1 = y < 0 || this.transY < 0 ? 0 : (int)this.maxHeight;
        }
        this.clipX1 = (short)(this.translatedX1 & Short.MAX_VALUE);
        this.clipY1 = (short)(this.translatedY1 & Short.MAX_VALUE);
        if (this.translatedX1 >= this.maxWidth || this.translatedY1 >= this.maxHeight) {
            this.clip[3] = 0;
            this.clip[2] = 0;
            this.clip[1] = 0;
            this.clip[0] = 0;
            this.clipped = true;
            return;
        }
        this.clip[0] = this.clipX1;
        this.clip[1] = this.clipY1;
        this.translatedX2 = x + this.transX + width;
        this.translatedY2 = y + this.transY + height;
        if (this.translatedX2 < 0) {
            int n = this.translatedX2 = x < 0 || this.transX < 0 ? 0 : (int)this.maxWidth;
        }
        if (this.translatedY2 < 0) {
            this.translatedY2 = y < 0 || this.transY < 0 ? 0 : (int)this.maxHeight;
        }
        this.clip[2] = (short)(this.translatedX2 - this.clipX1 & Short.MAX_VALUE);
        this.clip[3] = (short)(this.translatedY2 - this.clipY1 & Short.MAX_VALUE);
        if (this.clip[2] > this.maxWidth) {
            this.clip[2] = this.maxWidth;
        }
        if (this.clip[3] > this.maxHeight) {
            this.clip[3] = this.maxHeight;
        }
        if (this.clip[0] > 0 || this.clip[1] > 0 || this.clip[2] < this.maxWidth || this.clip[3] < this.maxHeight) {
            this.clipped = true;
        }
    }

    public native void drawLine(int var1, int var2, int var3, int var4);

    public native void fillRect(int var1, int var2, int var3, int var4);

    public native void drawRect(int var1, int var2, int var3, int var4);

    public native void drawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void fillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawString(String var1, int var2, int var3, int var4);

    public native void drawSubstring(String var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawChar(char var1, int var2, int var3, int var4);

    public native void drawChars(char[] var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawImage(Image var1, int var2, int var3, int var4);

    public native void drawRegion(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public void copyArea(int x_src, int y_src, int width, int height, int x_dest, int y_dest, int anchor) {
        if (Display.isGraphicsDisplay(this)) {
            throw new IllegalStateException();
        }
        this.doCopyArea(x_src, y_src, width, height, x_dest, y_dest, anchor);
    }

    public native void fillTriangle(int var1, int var2, int var3, int var4, int var5, int var6);

    private native void doCopyArea(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public native void drawRGB(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    public native int getDisplayColor(int var1);

    static Graphics getGraphics(Image img) {
        if (img == null) {
            return new Graphics(Display.WIDTH, Display.HEIGHT);
        }
        return new ImageGraphics(img);
    }

    void reset(int x1, int y1, int x2, int y2) {
        this.transY = 0;
        this.transX = 0;
        this.currentFont = Font.getDefaultFont();
        this.style = 0;
        this.gray = 0;
        this.rgbColor = 0;
        this.pixel = this.getPixel(this.rgbColor, this.gray, true);
        this.setClip(x1, y1, x2 - x1, y2 - y1);
    }

    void reset() {
        this.reset(0, 0, this.maxWidth, this.maxHeight);
    }

    private static int grayVal(int red, int green, int blue) {
        return red * 76 + green * 150 + blue * 29 >> 8;
    }

    private native int getPixel(int var1, int var2, boolean var3);
}

