/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.sun.midp.io.Util;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

class ImmutableImage
extends Image {
    private static final int INVERTED_AXES = 4;

    private ImmutableImage() {
    }

    ImmutableImage(Image img) {
        this.width = img.width;
        this.height = img.height;
        this.createImmutableCopy(this.width, this.height, img);
    }

    ImmutableImage(Image img, int x, int y, int width, int height, int transform) {
        if ((transform & 4) != 0) {
            this.width = height;
            this.height = width;
        } else {
            this.width = width;
            this.height = height;
        }
        this.createImmutableImageRegion(img, x, y, width, height, transform);
    }

    ImmutableImage(byte[] imageData, int imageOffset, int imageLength) {
        this.decodeImage(imageData, imageOffset, imageLength);
    }

    ImmutableImage(int[] rgbImageData, int width, int height, boolean parseAlpha) {
        this.decodeRGBImage(rgbImageData, width, height, parseAlpha);
    }

    ImmutableImage(String str) throws IOException {
        InputStream is = null;
        is = this.getClass().getResourceAsStream(str);
        this.getImageFromStream(is);
        is.close();
    }

    ImmutableImage(InputStream stream) throws IOException {
        this.getImageFromStream(stream);
    }

    private void getImageFromStream(InputStream istream) throws IOException {
        int blocksize = 4096;
        if (istream == null) {
            throw new IOException();
        }
        int l = istream.available();
        byte[] buffer = new byte[l + 1];
        int length = 0;
        while ((l = istream.read(buffer, length, buffer.length - length)) != -1) {
            if ((length += l) != buffer.length) continue;
            byte[] b = new byte[buffer.length + blocksize];
            System.arraycopy(buffer, 0, b, 0, length);
            buffer = b;
        }
        this.decodeImage(buffer, 0, length);
    }

    static Image createIcon(String imageName) {
        if (imageName.indexOf(47) >= 0 || imageName.indexOf(92) >= 0) {
            throw new IllegalArgumentException("illegal character");
        }
        ImmutableImage image = new ImmutableImage();
        byte[] asciiName = Util.toCString(imageName);
        image.loadIcon(asciiName);
        return image;
    }

    private native void createImmutableCopy(int var1, int var2, Image var3);

    private native void createImmutableImageRegion(Image var1, int var2, int var3, int var4, int var5, int var6);

    private native void decodeImage(byte[] var1, int var2, int var3);

    private native void loadIcon(byte[] var1);

    private native void finalize();

    private native void decodeRGBImage(int[] var1, int var2, int var3, boolean var4);
}

